SET QUOTED_IDENTIFIER ON 
GO
SET ANSI_NULLS ON 
GO

-- ****************************************************************************
--
-- Copyright (c) 2006, Telemtica Sistemas Inteligentes.
--  
--    NAME
--      sp_rastreamento - Rastreamento de pessoas
--
--    VERSION <<< SQL SERVER 2000 >>>
--      1.0 - RN 
--
--    AUTHOR
--      Raphael Loureno de Jesus (TSI)
--   
--    DESCRIPTION
--      Verificar se usurio pode estar no local
-- ****************************************************************************
drop procedure sp_rastreamento 
go
create PROCEDURE sp_rastreamento 
--	@sp_end_ip char(15),
--	@sp_icard char(12)
AS
begin
	select * from dam03
	declare @sp_motivo char(3)
        declare @sp_grupo char(3)
	declare @sp_matricula integer
	declare @sp_situa char(1)
	declare @sp_Val_situa char(1)
	declare @sp_datahora char(20)
	declare	@sp_Val_datahora char(1)
	declare @mensagem varchar(255) 
	declare @valor integer
	declare @cFaixa AS varchar(56)
	declare @NumLaces int
	
	declare @contador integer
	set @contador = (select count(*) from dam03)
--	CLOSE NEWCURSOR
--	DEALLOCATE NEWCURSOR
	
	select * into #tmp_dam03 from dam03 
	delete from dam03
	DECLARE NEWCURSOR CURSOR FOR ( select ICARD, DIAM, MESM, ANOM, HORAM, SEGUNDO, CODAC, POSIC, BLUEB, CODTT, END_IP,CODFNC, VEICULO  from #tmp_dam03 )
	OPEN NEWCURSOR
	DECLARE @sp_DIAM char(2)
	DECLARE @sp_MESM char(2)
	DECLARE @sp_ANOM char(2)
	DECLARE @sp_HORAM char(4)
	DECLARE @sp_SEGUNDO char(2)
	DECLARE @sp_CODAC char(2) 
	DECLARE @sp_POSIC char(1)
	DECLARE @sp_BLUEB char(2)
	DECLARE @sp_CODTT char(2)
	DECLARE @sp_CODFNC char(2)
	DECLARE @sp_VEICULO varchar(15)
	DECLARE @sp_icard char(12)
	DECLARE @sp_end_ip char(15)
	DECLARE @DATA char(20)
	DECLARE @DATA_FER char(20)
	
	fetch next from NEWCURSOR into @sp_icard,@sp_DIAM , @sp_MESM,@sp_ANOM,@sp_HORAM,@sp_SEGUNDO,@sp_CODAC,@sp_POSIC,@sp_BLUEB,@sp_CODTT,@sp_end_ip, @sp_CODFNC,@sp_VEICULO
	
	while @@fetch_status != -1
	begin
	SET @DATA = @sp_DIAM + '/' + @sp_MESM + '/' + @sp_ANOM + ' ' + SUBSTRING(@sp_HORAM,1,2) + ':'+SUBSTRING(@sp_HORAM,3,2)+':' + @sp_SEGUNDO
	set @DATA_FER = @sp_DIAM + '/' + @sp_MESM + '/' + @sp_ANOM
	set @sp_motivo = '01'

		set @sp_matricula = (select count(*)from controle where icard = @sp_icard)
		if @sp_matricula = 0  
		begin
			set @sp_motivo = '22'
			goto MAIN_LOOP
		end
		
		set @sp_grupo = (select grupo from controle where icard = @sp_icard)
		
		select @NumLaces = 0
		IF NOT EXISTS (select * from TABGRPSETFX WHERE END_IP = @sp_end_ip AND
			                   convert(int,GRUPO) = convert(int,@sp_grupo))
		begin
			set @sp_motivo = '47'
			goto MAIN_LOOP
		end
		else
		begin
			SELECT @NumLaces = convert(int, LACES),
				@cFaixa = FXPERM	
			FROM TABGRPSETFX
			WHERE 
			END_IP = @sp_end_ip AND
			convert(int,GRUPO) = convert(int,@sp_grupo)
		end 	
		
		set @sp_situa = (select situa from controle where icard = @sp_icard)
		if @sp_situa <> 0 
		begin
			set @sp_motivo = '24'
			goto MAIN_LOOP
		end
		
		declare @data_tab char(14)
		declare @dia_tab char(2)
		declare @mes_tab char(2)
		declare @ano_tab char(2)
		declare @hor_tab char(2)
		declare @min_tab char(2)
		set @sp_datahora = (select datahora from controle where icard = @sp_icard)		
		
		set @dia_tab = (substring(@sp_datahora,0,3))
		set @mes_tab = (substring(@sp_datahora,3,2))
		set @ano_tab = (substring(@sp_datahora,5,2))
		set @hor_tab = (substring(@sp_datahora,7,2))
		set @min_tab = (substring(@sp_datahora,9,2))
	
		set @data_tab = @dia_tab+'/'+@mes_tab+'/'+@ano_tab+' '+@hor_tab+':'+@min_tab
		
		declare @dia_Atu char(2)
		declare @mes_Atu char(2)
		declare @ano_Atu char(6)
		declare @hor_Atu char(2)
		declare @min_Atu char(2)
		declare @data_Atu char(20)
		
		set @dia_Atu = (Select DATEPART(day,getdate()))
		set @mes_Atu = (Select DATEPART(month,getdate()))
		set @ano_Atu = (Select DATEPART(year,getdate()))
		set @ano_Atu = substring(@ano_atu,3,2)
		set @hor_Atu = (Select DATEPART(hour,getdate()))
		set @min_Atu = (Select DATEPART(minute,getdate()))
		
		if len(@dia_Atu) = 1 
		begin
			set @dia_Atu = '0' + @dia_Atu
		end

		if len(@mes_Atu) = 1 
		begin
			set @mes_Atu = '0' + @mes_Atu
		end

		set @data_Atu = @dia_Atu+'/'+@mes_Atu+'/'+@ano_Atu+' '+@hor_Atu+':'+@min_Atu
		
		if @data_Atu > @data_tab
		begin
			set @sp_motivo = '15'
			goto MAIN_LOOP
		end
			
		declare @Afastado int
		set @afastado = (select count(*) from controle where icard = @sp_icard and @data between datini and datfim)
		if @afastado > 0 
		begin
			set @sp_motivo = '17'
			goto MAIN_LOOP
		end
		
		
		DECLARE @DIA INT
		DECLARE @sp_grupo_SAB char(3)
		DECLARE @sp_grupo_DOM char(3)
		DECLARE @sp_grupo_FER char(3)
		declare @SP_quantidade_fer integer

		SELECT @DIA = (DATEPART(DW,@data ))
		
		set @SP_quantidade_fer = (select count(*) from feriado  where data_fer = convert(datetime,@data_fer))
		if  @SP_quantidade_fer > 0
		begin
			set @sp_grupo_FER = (select CONVERT(INT,grupo_fer) from controle where icard = @sp_icard)
			if @sp_grupo_FER = 0
			begin
				set @sp_motivo = '46'
				goto MAIN_LOOP
			end
		end
		else
		begin
			if @dia IN (1,7)
			begin
				if @dia = 1 
				begin
					set @sp_grupo_SAB = (select CONVERT(INT,grupo_sab) from controle where icard = @sp_icard)
					if @sp_grupo_SAB = 0
					begin
						set @sp_motivo = '46'
						goto MAIN_LOOP
					end
				end
				else
				if @dia = 7
				begin
					set @sp_grupo_DOM = (select CONVERT(INT,grupo_dom) from controle where icard = @sp_icard)
					if @sp_grupo_DOM = 0
					begin
						set @sp_motivo = '46'
						goto MAIN_LOOP
					end
				end 
			end
		end

	MAIN_LOOP:		
		INSERT INTO DAM00 (ICARD, DIAM, MESM, ANOM, HORAM, SEGUNDO,CODAC, POSIC, BLUEB, CODTT, END_IP, CODFNC, ONOFF, VEICULO)	
			VALUES(@sp_icard,@sp_DIAM , @sp_MESM,@sp_ANOM,@sp_HORAM,@sp_SEGUNDO,@sp_motivo,@sp_POSIC,@sp_BLUEB,@sp_CODTT,@sp_end_ip, @sp_CODFNC,0,@sp_VEICULO)

	fetch next from NEWCURSOR into @sp_icard,@sp_DIAM , @sp_MESM,@sp_ANOM,@sp_HORAM,@sp_SEGUNDO,@sp_CODAC,@sp_POSIC,@sp_BLUEB,@sp_CODTT,@sp_end_ip, @sp_CODFNC,@sp_VEICULO
	end
	CLOSE NEWCURSOR
	DEALLOCATE NEWCURSOR
end

GO
SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS ON 
GO
