drop procedure sp_expiroupendencia 
go
CREATE PROCEDURE sp_expiroupendencia 
@sp_expiredtime tinyint ,
@sp_limitexpiredtime tinyint
AS
BEGIN
DECLARE @dtlimite char(14) 
declare @data datetime, @dexp datetime
DECLARE @end_ip char(15)

	SET DATEFORMAT YMD
	SET LOCK_TIMEOUT 2000

	-- CALCULA DATA LIMITE PARA EXPIRACAO 60 (sp_limitexpiredtime) DIAS
	set @data = DATEADD(day, @sp_limitexpiredtime * -1, getdate())
	execute dbo.sqldata_asc @data, @dtlimite output
	
	-- CALCULA HORA LIMITE PARA RECARGA DAS PENDENCIAS (12 - sp_expiredtime HORAS)
	set @dexp = DATEADD (hour, @sp_expiredtime, getdate())
		
		
	declare cur_endip cursor for (SELECT END_IP from PEND_ON002ON )
	open cur_endip
	fetch next from cur_endip into @end_ip
	
	while @@fetch_status != -1
	begin
		-- VERIFICA AS ATUALIZACOES QUE DEVERAO EXCLUIDAS APOS 60 (sp_limitexpiredtime) DIAS 
		delete from pend_on001 
			where 	numserial > '0000000000' and
					end_ip = @end_ip and 
					identif < @dtlimite 


		-- VERIFICA AS ATUALIZACOES QUE DEVERAO SER REENVIADAS (12 horas - sp_expiredtime) AOS CODINS
		update pend_on001 set 
			data_exp = null, status = 0 
			where 	end_ip = @end_ip and 
					tipo_atu = '1' and
					data_exp <> null and
					dbo.trunc_data (data_exp, 'HH') <= dbo.trunc_data (@dexp, 'HH') and
					status = '5' 

		fetch next from cur_endip into @end_ip
		
	end
	close cur_endip
	deallocate cur_endip
	
	-- DELETA DA ATUALI AS PENDENCIAS ANTIGAS DE 60 DIAS (sp_limitexpiredtime)
	delete from atuali where identif < @dtlimite   
	
	SET LOCK_TIMEOUT -1
		
END

GO
