DROP PROCEDURE sqlver_RepPonto
GO
CREATE PROCEDURE sqlver_RepPonto @cMatric char(12) AS

DECLARE @dDtaHoraTab DATETIME, @dDtaHorUlt DATETIME
DECLARE @cDataHora varchar(20)
DECLARE @ret SMALLINT
declare @hora char(2), @minuto char(2), @segundo char(2), @dia char(2), @mes char(2), @ano char(4), @diasemana char(1),
	@data char(14)



	-- CONEXREP
		-- coletara do REPEMPR002 todos os IFUNCS q foram cadastrados com o mesmo PIS
		-- guardar em REPPONTO, todos esses IFUNCS+ PIS com a DATA e HORA da marcacao de Ponto. Exemplo: titular e varios provisrios com o mesmo valor de PIS
	-- FIM CONEXREP
	
	
	-- CONEX ACESSO:
		-- situacao 1: o Conex Acesso ao passar o crach Titular, procurara pelo Icard  em REPPONTO e far a validacao de datahora para interjornada
		-- situacao 2: o Conex Acesso ao passar o crach Provisrio, procurara pelo Icard (agora do Titular)  em REPPONTO e far a validacao de datahora para interjornada
		-- ou seja, apesar de ter sido armazenado em REPPONTO vrios Icards com mesmo PIs, o Conex s procurar pelo Icard (q  do Titular), e caso encontre mais de uma linha
		-- com o mesmo Icard, s ser considerado o de datahora mais recente
	-- FIM CONEX ACESSO
	


    SET DATEFORMAT dmy

	SET @ret = 1
	SET @dDtaHorUlt = CAST(('01-01-01 00:00:00') AS datetime);
    
    SELECT @dDtaHoraTab = MAX (DTAHORAREP) 
    	FROM REPPONTO 
		WHERE 	IFUNC = @cMatric 
	
  	IF (@dDtaHoraTab > @dDtaHorUlt) 
		SET @dDtaHorUlt = @dDtaHoraTab


	SET @segundo = convert(char(2),datepart(second,@dDtaHorUlt))
	SET @minuto = convert(char(2),datepart(minute,@dDtaHorUlt))
	SET @hora = convert(char(2),datepart(hour,@dDtaHorUlt))
	SET @dia = convert(char(2),datepart(day,@dDtaHorUlt))
	SET @mes = convert(char(2),datepart(month,@dDtaHorUlt))
	SET @ano = convert(char(4),datepart(year,@dDtaHorUlt))

	-- HORA
	execute dbo.aux_data @xvalor = @hora output
	-- MINUTO
	execute dbo.aux_data @xvalor = @minuto output
	-- SEGUNDO
	execute dbo.aux_data @xvalor = @segundo output
	-- DIA
	execute dbo.aux_data @xvalor = @dia output
	-- MES
	execute dbo.aux_data @xvalor = @mes output

	SET @cDataHora  = @dia+ @mes+ substring(@ano,3,2)+ @hora+ @minuto+ @segundo 

	SELECT @cDataHora, @ret

GO

SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS ON 
GO
