if object_id('sqlvermat_nrefeit', 'p') is null
    exec ('create procedure sqlvermat_nrefeit as select 1')
go

ALTER PROCEDURE sqlvermat_nrefeit @cMatric char(12), @cEndIp char(15)
AS

DECLARE @nCont int, @nMax int
DECLARE @cPlanta CHAR(5), @cCredito CHAR(2), @cFaixa CHAR(8)
DECLARE @cRegFaixa VARCHAR(120)	-- maximo 15 faixas horarias (15*8 = 120)
DECLARE @cRegCred  VARCHAR(40)	-- maximo 15 creditos (15*2 = 30)
DECLARE @cUltPasRef CHAR(10);		-- DDMMYYHHMI
	
	SET DATEFORMAT DMY
	SET @nMax = 15;
	SET @nCont = 0;
	SET @cRegFaixa = ''
	SET @cRegCred  = ''
	SET @cUltPasRef  = SPACE(10);
	SET @cPlanta  = ''


	-- PROCURA POR TODOS AS FAIXAS DE REFEITORIO DO USUARIO DE ACORDO COM A PLANTA DO QUAL O EQUIPAMENTO FAZ PARTE
	SELECT @cPlanta = PLANTA FROM DAT07 
		WHERE END_IP = @cEndIp 

		
	DECLARE cur_NREFEIT cursor FOR 
		SELECT top (@nMax ) FX_REF, CRED_FXREF 
			FROM MATNREFEIT  
			WHERE ICARD = @cMatric  AND
			  	  CONVERT(INT, PLANTA) = CONVERT(INT, @cPlanta)  ORDER BY FX_REF ASC
			  
	OPEN cur_NREFEIT
	FETCH NEXT FROM cur_NREFEIT INTO @cFaixa, @cCredito
	WHILE (@@fetch_status != -1)
	begin
		SET @cRegFaixa = @cRegFaixa + @cFaixa
		SET @cRegCred  = @cRegCred + @cCredito
		SET @nCont = @nCont + 1
		
		FETCH NEXT FROM cur_NREFEIT INTO @cFaixa, @cCredito
	end

	CLOSE cur_NREFEIT
	DEALLOCATE cur_NREFEIT


	-- PROCURA PELA ULTIMA PASSAGEM EM REFEITORIO FEITA PELA MATRICULA NESTA PLANTA
	IF (@nCont != 0) 
		SELECT @cUltPasRef = ULTPAS_REF FROM AUXMATNREFEIT  
			WHERE ICARD = @cMatric AND 
				  CONVERT(INT, PLANTA) = CONVERT(INT, @cPlanta)
		
	
	SELECT @nCont, @cPlanta, @cRegFaixa, @cRegCred, @cUltPasRef
	GO
			

SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS ON 
GO
