if object_id('SQLVERMAT_NGRUPOS', 'p') is null
    exec ('create procedure SQLVERMAT_NGRUPOS as select 1')
go

ALTER PROCEDURE SQLVERMAT_NGRUPOS @cMatric char(12), @cEndIp char(15), @cHoraCodin char(4), @cTipoDia char(1)
AS

DECLARE @i int, @achou int, @k int, @ini int, @fim int
DECLARE @hora_ini varchar(4), @hora_fim varchar(4), @cGrupo char(3), @cFaixa char(56)
DECLARE @hHoraOcor TIME
DECLARE @nLaces INT, @cLocal varchar(9)

	
	SET DATEFORMAT DMY
	SET @achou = 0
	SET @nLaces = -1

	--SET @hHoraOcor = CAST( (substring(@cHoraCodin,1,2)+':'+
	--						substring(@cHoraCodin,3,2) AS TIME);


	-- PROCURA POR TODOS OS GRUPOS DO USUARIO DE ACORDO COM O TIPO DE DATA (cTipoDia) , SE DOMINGO, SABADO, FERIADO OU 2a. A 6a.
	DECLARE cur_MATNGRUPOS cursor FOR 
		SELECT 
			a.GRUPO, a.FXPERM, a.LACES 
		FROM  
			TABGRPSETFX a, MATNGRUPOS b 
		WHERE a.END_IP = @cEndIp  AND 
			  b.ICARD = @cMatric AND 
			  convert(int, b.GRUPO) = convert(int, a.GRUPO) AND
			  b.DIA_TIPO = @cTipoDia
			  
	OPEN cur_MATNGRUPOS
	FETCH NEXT FROM cur_MATNGRUPOS INTO @cGrupo, @cFaixa, @cLocal
	WHILE (@@fetch_status != -1) and (@achou != 1) 
	begin
		SET @achou = 2
		SET @nLaces = CONVERT(INT, @cLocal)

		SET @i = 0
		WHILE (@i < 7)				-- verifica enquanto nao esgotar as 7 faixas horarias ou at encontrar a faixa
		begin
			SET @k = (8 * @i)		-- vai 'andar' de 8 em 8 porque a faixa  hhmmhhmm
			SET @ini = @k + 1;		-- posicao de inicio de faixa
			SET @fim = @k + 5;		-- posicao de fim  de faixa

			SET @hora_ini = substring(@cFaixa, @ini, 4);	-- string de hhmi inicial
			SET @hora_fim = substring(@cFaixa, @fim, 4);	-- string de hhmi final
			
			if @hora_ini = '2400' 
				SET @hora_ini = '2359'
			if @hora_fim = '2400' 
				SET @hora_fim = '2359'
			
			-- verifica se hora/minuto da ocorrencia est dentro da faixa de pesquisa
			IF ((@cHoraCodin >= @hora_ini) and	
				(@cHoraCodin <= @hora_fim) )
			begin				
				SET @i = 7			-- indica parada de busca
				SET @achou = 1		-- indica parada de busca do cursor
			end
			else
				SET @i = @i + 1;	-- vai para proxima faixa horaria
		end
		FETCH NEXT FROM cur_MATNGRUPOS INTO @cGrupo, @cFaixa, @cLocal
	end
	
	CLOSE cur_MATNGRUPOS
	DEALLOCATE cur_MATNGRUPOS


	SELECT @achou, @nLaces
	GO
			

SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS ON 
GO
