IF EXISTS (SELECT name FROM sysobjects WHERE name = 'trgrepptoI' AND type = 'TR')
    DROP TRIGGER trgrepptoI
GO

CREATE TRIGGER trgrepptoI ON REPPONTO FOR UPDATE, INSERT
AS

declare @NovoDHPto DATETIME;
declare @OldDHPto DATETIME
declare @DHAntigo DATETIME
declare @cMat VARCHAR(12)
declare @cMatOld VARCHAR(12)
declare @aux VARCHAR(12)
declare @Qtde int
declare @nSegundos SMALLINT

	-- ESTA TRIGGER FAR COM QUE ANTES QUE A MARCACAO 'ANTIGA' SEJA SUBSTITUIDA EM REPPONTO PELA NOVA MARCAO, 
	-- ESSA MARCACAO 'ANTIGA' SEJA INSERIDA EM TABELA ULTREPPONTO
	
	set dateformat dmy
	set @cMat = (select IFUNC from inserted)				-- MATRICULA DO NOVA MARCACAO QUE SERA CADASTRADA EM REPPONTO
	set @NovoDHPto = (select DTAHORAREP from inserted)		-- DATA/HORA DA NOVA MARCACAO QUE SERA CADASTRADA EM REPPONTO

	set @cMatOld = (select IFUNC from deleted)				-- MATRICULA EXISTENTE EM REPPONTO. SE NAO EXISTIR ESSA MATRICULA EM REPPONTO, VALOR DE @cMatOld SER NULO
	set @OldDHPto = (select DTAHORAREP from deleted)		-- DATA/HORA DA ULTIMA MARCACAO (EXISTENTE EM REPPONTO)
	
	SET @nSegundos = 77
	
	-- PARA VERIFICAR SE J EXISTE ALGUMA MARCACAO DESTA MATRICULA EM REPPONTO. SE NO HOUVER ( O PRIMEIRO INSERT EM REPPONTO), NADA FAZ RELATIVO  INSERCAO EM ULTREPPONTO
	IF (@cMat = @cMatOld) begin
		IF (@NovoDHPto > DATEADD(SECOND, @nSegundos, @OldDHPto)) BEGIN 		-- PARA HAVER TRANSFERENCIA , DEVE TER DIFERENCA MAIOR Q 77 SEGUNDOS
			-- procurar pela marcacao que esta sendo trocada (ultima ja marcada presente em REPPONTO) em tabela ULTREPPONTO
			IF NOT EXISTS (SELECT IFUNC FROM ULTREPPONTO WHERE
				IFUNC = @cMat and
				DTAHORAREP = @OldDHPto) begin

				-- verifica quantas marcacoes tem para o mesmo icard
				SET @Qtde = (SELECT COUNT (*) FROM ULTREPPONTO WHERE IFUNC = @cMat)		

				-- verifica se atingiu qtde maxima de marcacoes para o funcionario. obs: pode mudar o valor de 8, pois foi aleatorio este valor
				IF (@Qtde >= 8) begin			
					SELECT @DHAntigo = MIN(DTAHORAREP) FROM ULTREPPONTO WHERE IFUNC = @cMat;		-- procura pela marcacao mais antiga deste usuario, para que seja deletada 
					DELETE FROM ULTREPPONTO WHERE IFUNC = @cMat AND DTAHORAREP = @DHAntigo;
				end

				-- insere em ULTREPPONTO A MARCACAO QUE EST SENDO SUBSTITUIDA EM REPPONTO
				INSERT INTO ULTREPPONTO (IFUNC, DTAHORAREP) VALUES (@cMat, @OldDHPto);
			end
		END
	end
		
go	
