IF EXISTS (SELECT name FROM sysobjects WHERE name = 'trgoffrepptoIU' AND type = 'TR')
    DROP TRIGGER trgoffrepptoIU
GO

CREATE TRIGGER trgoffrepptoIU ON OFFREPPONTO FOR UPDATE, INSERT
AS

declare @NovoDHPto DATETIME;
declare @DHMenor DATETIME
declare @DHMaior DATETIME
declare @cMat VARCHAR(12)
declare @Qtde int

	-- ESTA TRIGGER FAR COM QUE A MARCACAO QUE FOI INSERIDA EM OFFREPPONTO SEJA ANALISADA PARA VER VIABILIDADE DE SER INSERIDA EM ULTREPPONTO.
	-- (OBS: A MARCACAO FOI INSERIDA EM OFFREPPONTO E NO EM REPPONTO, PORQUE ESTA 'NOVA' MARCACAO  ANTERIOR  QUE EST EM REPPONTO)
	
	set dateformat dmy
	set @cMat = (select IFUNC from inserted)				-- MATRICULA DO NOVA MARCACAO QUE FOI INSERIDA/ALTERADA EM OFFREPPONTO
	set @NovoDHPto = (select DTAHORAREP from inserted)		-- DATA/HORA DA NOVA MARCACAO QUE FOI INSERIDA/ALTERADA EM OFFREPPONTO

	IF NOT EXISTS (SELECT IFUNC FROM ULTREPPONTO WHERE IFUNC = @cMat) 
		-- insere esta nova marcao, pois ainda nao atingiu a qtde  maxima (8)
		INSERT INTO ULTREPPONTO (IFUNC, DTAHORAREP) VALUES (@cMat, @NovoDHPto);		
						
	ELSE BEGIN
		-- procura pela menor data/hora do usuario
		SET @DHMenor = 	(SELECT MIN(DTAHORAREP) FROM ULTREPPONTO 
							WHERE IFUNC = @cMat GROUP BY IFUNC)		
							
		-- procura pela maior data/hora do usuario
		SET @DHMaior = 	(SELECT MAX(DTAHORAREP) FROM ULTREPPONTO 
							WHERE IFUNC = @cMat GROUP BY IFUNC)		
							
		-- verifica as marcaoes existentes
		IF (@DHMenor = @DHMaior) begin
			-- verifica se  a mesma marcao
			IF (@NovoDHPto != @DHMenor) BEGIN
				-- insere esta nova marcacao de ponto 
				INSERT INTO ULTREPPONTO (IFUNC, DTAHORAREP) VALUES (@cMat, @NovoDHPto);		
			END;
		end
		ELSE begin	-- tem mais de 1 marcao para o usuario, verifica se esta nova marcao j existe ou precisa ser inserida na tabela apos analise de data
			-- procurar pela marcacao  em tabela ULTREPPONTO
			IF NOT EXISTS (SELECT IFUNC  FROM ULTREPPONTO WHERE IFUNC = @cMat AND DTAHORAREP = @NovoDHPto) 
			BEGIN 
				-- verifica quantas marcacoes tem para o mesmo icard
				SET @Qtde = (SELECT COUNT (*) FROM ULTREPPONTO WHERE IFUNC = @cMat)		
				-- verifica se ha 8 marcacoes ou mais
				IF (@Qtde >= 8) begin				-- VERIFICA SE TEM MAIS DE 8 MARCACOES		
					-- verifica se esta nova marcacao  maior do que a menor data para este usuario
					IF (@NovoDHPto > @DHMenor) begin 
						-- atualiza a data mais antiga com esta nova
						UPDATE ULTREPPONTO SET DTAHORAREP = @NovoDHPto 
							WHERE IFUNC = @cMat AND DTAHORAREP = @DHMenor;	
					end
					-- se for menor, nada faz pois j tem  a qtde.maxima (8)
				end
				ELSE
					-- insere esta nova marcao, pois ainda nao atingiu a qtde  maxima (8)
					INSERT INTO ULTREPPONTO (IFUNC, DTAHORAREP) VALUES (@cMat, @NovoDHPto);		
			END							

			-- tem qtde de marcaes menor que o mximo (8)
			ELSE begin
				-- insere esta nova marcao, pois ainda nao atingiu a qtde  maxima (8)
				INSERT INTO ULTREPPONTO (IFUNC, DTAHORAREP) VALUES (@cMat, @NovoDHPto);		
			end
		END
	END
	
go	
