if object_id('trata_OutrosBios', 'p') is null
    exec ('create procedure trata_OutrosBios as select 1')
go

ALTER PROCEDURE trata_OutrosBios AS

DECLARE @ret CHAR(1)
DECLARE @z_endip CHAR(15)
DECLARE @z_biotipo CHAR(1)
DECLARE @z_status CHAR(1)

DECLARE @z_mat CHAR(12)
DECLARE @aux_icard CHAR(12)
DECLARE @aux_endip CHAR(15)

SET DATEFORMAT YMD

	SET LOCK_TIMEOUT 3000


	-- ********************   ARRUMAR SITUAES PARA outras bios    -  INCLUSAO
	-- ***********************  TRATA AS BIOMETRIAS  QUE FICARAM PENDENTES NA CARGA E QUE NAO SERAO REENVIADAS AUTOMATICAMENTE
	-- SITUACAO EM QUE CARGA FICOU PENDENTE PORQUE EQUIPAMENTO REJEITOU A CARGA  (status '4')
	DECLARE cur_troubleIns1 CURSOR FOR 
		(SELECT distinct ICARD from DIG004 
			WHERE STATUS = '4'
		)
	OPEN cur_troubleIns1
	FETCH NEXT FROM cur_troubleIns1 INTO @z_mat
	WHILE (@@fetch_status != -1) BEGIN
		DECLARE cur_troubleIns2 CURSOR FOR 
			(SELECT END_IP from DIG004 
				WHERE (ICARD = @z_mat and STATUS = '4')
			)
		OPEN cur_troubleIns2
		FETCH NEXT FROM cur_troubleIns2 INTO @z_endip

		WHILE (@@fetch_status != -1) BEGIN
			DELETE DIG004 WHERE (END_IP = @z_endip and ICARD = @z_mat and STATUS = '4')

			UPDATE DIG002 set status = '1'WHERE (END_IP =  @z_endip AND STATUS = '3') ;

			FETCH NEXT FROM cur_troubleIns2 INTO @z_endip
		END


		CLOSE cur_troubleIns2
		deallocate cur_troubleIns2

		FETCH NEXT FROM cur_troubleIns1 INTO @z_mat
	END
	
	CLOSE cur_troubleIns1
	deallocate cur_troubleIns1

	

	-- ***********************  TRATA AS BIOMETRIAS  QUE FICARAM PENDENTES NA CARGA
	-- SITUACAO EM QUE CARGA FICOU PENDENTE PORQUE HOUVE DELETE DE REGISTROS DOS bios (DA TAB.CONTDIG_OUTROS CADASTRO)
	-- delete registro de DIG004 se nao houver cadastro de BIO  desta matricula
	DECLARE cur_autoIns1 CURSOR FOR 
		(SELECT distinct ICARD, BIO_TIPO from DIG004 
			WHERE STATUS = '3'
		)
	OPEN cur_autoIns1
	FETCH NEXT FROM cur_autoIns1 INTO @z_mat, @z_biotipo
	WHILE (@@fetch_status != -1) BEGIN
		
		-- VERIFICA SE H CADASTRO DO BIO  DA MATRICULA
		SELECT @aux_icard = ICARD FROM CONTDIG_OUTROS 
			WHERE ICARD = @z_mat AND BIO_TIPO = @z_biotipo
			
		IF (@@ROWCOUNT = 0)	BEGIN
			-- nao ha cadastro de BIO  desta matricula
			DECLARE cur_autoIns2 CURSOR FOR 
				(SELECT END_IP from DIG004 
					WHERE (ICARD = @z_mat 	and 
						   STATUS = '3' 	and 
						   BIO_TIPO = @z_biotipo)
				)
			OPEN cur_autoIns2
			FETCH NEXT FROM cur_autoIns2 INTO @z_endip

			WHILE (@@fetch_status != -1) BEGIN
				DELETE DIG004 WHERE (END_IP = @z_endip and ICARD = @z_mat and STATUS = '3')

				UPDATE DIG002 set status = '1'WHERE (END_IP =  @z_endip AND STATUS = '3') ;

				FETCH NEXT FROM cur_autoIns2 INTO @z_endip
			END


			CLOSE cur_autoIns2
			deallocate cur_autoIns2
		END

		FETCH NEXT FROM cur_autoIns1 INTO @z_mat, @z_biotipo
	END
	
	CLOSE cur_autoIns1
	deallocate cur_autoIns1

	-- ***********************  TRATA AS BIOMETRIAS  QUE FICARAM PENDENTES NA INCLUSAO
	-- altera status de todos os codins para carga de digitais, se esses no estiverem com carga de digitais ou estiverem pendentes

	DECLARE cur_endip CURSOR FOR 
		(SELECT distinct END_IP, BIO_TIPO, STATUS from DIG004 
			WHERE (STATUS != '0' and STATUS != '2') 
		)
	OPEN cur_endip
	FETCH NEXT FROM cur_endip INTO @z_endip, @z_biotipo, @z_status
	
	while @@fetch_status != -1
	begin
		UPDATE DIG002 set status = '1'
			WHERE (END_IP = @z_endip and 
					(STATUS = '0' or STATUS= '3') and 
					BIO_TIPO = @z_biotipo)
		FETCH NEXT FROM cur_endip INTO @z_endip, @z_biotipo, @z_status
	end
	CLOSE cur_endip
	deallocate cur_endip



	-- ********************   TRATA EQUIPAMENTOS TSI1 QUE FICARAM EM ESTADO CARREGANDO OU SOFRERAM CARGA DE APLICATIVO
	-- equipamentos  q ficaram em estado de carregando '2' por mais de 2 minutos OU
	-- equipamentos  q tiveram carga de aplicativo 
	DECLARE cur_dig02 CURSOR FOR 
		(SELECT END_IP, BIO_TIPO, STATUS from DIG002 
			WHERE ((status = '5' or status = '6' or 		-- CARGA DE APLICATIVO
				   (status = '2' and DATEADD (MINUTE, 2, data_load)  < getdate())) 
				   and 
				   ((BIO_TIPO != '8') and (BIO_TIPO != '6') and (BIO_TIPO != '7')) 
				  )
		)
	OPEN cur_dig02
	FETCH NEXT FROM cur_dig02 INTO @z_endip, @z_biotipo, @z_status

	WHILE @@fetch_status != -1
	begin
		-- OBSERVACAO: PARA BIOMETRIA , A CARGA DE APLICATIVO NO EQUIPAMENTO NAO APAGA AS BIOMETRIAS, POIS BIOMETRIA  FICA NO LEITOR E NAO NO EQUIPAMENTO,
		-- LOGO NAO  NECESSARIO FAZER A RECARGA DE BIOMETRIA
		IF (@z_status = '2') begin		-- situao q estava fazendo a carga e deu problema

			UPDATE DIG004 set STATUS = '1'			-- status = 1 : a carregar
				WHERE (END_IP = @z_endip and STATUS = '2'  and BIO_TIPO = @z_biotipo) 

			UPDATE DIG002 set status = '1' 
				where (END_IP = @z_endip and BIO_TIPO = @z_biotipo)
		end

		ELSE begin
			IF (@z_status = '5' or @z_status = '6') begin		-- HOUVE CARGA DE APLICATIVO, MAS NAO VAI RECARREGAR AS BIOMETRIAS
				UPDATE DIG002 set status = '0' 
					WHERE (end_ip = @z_endip  and BIO_TIPO = @z_biotipo)
			end
		end
		
		FETCH NEXT FROM cur_dig02 INTO @z_endip, @z_biotipo, @z_status
	end

	CLOSE cur_dig02
	DEALLOCATE cur_dig02
	


	-- ***********************  TRATA AS BIOMETRIAS QUE FICARAM EM ESTADO DE CARREGANDO E NAO SAI DESTA SITUAO
	-- para BIOMETRIAS   DE DIG004 que ficaram em estado carregando '2', e o equipamento est em estado de repouso	, forca o equipamento a carrega-lo novamente

	DECLARE cur_dig02 CURSOR FOR 
		(SELECT A.END_IP, A.STATUS, A.BIO_TIPO from DIG002 A 
			INNER JOIN DIG004 B ON
				A.END_IP = B.END_IP and 
				A.STATUS = '0' and 
				B.STATUS = '2' and
				A.BIO_TIPO = B.BIO_TIPO)
	OPEN cur_dig02
	FETCH NEXT FROM cur_dig02 INTO @z_endip, @z_status, @z_biotipo 

	WHILE (@@fetch_status != -1) BEGIN
		UPDATE DIG004 SET STATUS = '1' 
			WHERE END_IP = @z_endip AND STATUS = '2' AND BIO_TIPO = @z_biotipo;
		UPDATE DIG002 set STATUS = '1' 
			WHERE END_IP = @z_endip  and BIO_TIPO = @z_biotipo;
			
		FETCH NEXT FROM cur_dig02 INTO @z_endip, @z_status, @z_biotipo;
	END
	CLOSE cur_dig02
	deallocate cur_dig02
	


	-- ********************   ARRUMAR SITUAES PARA   outras bios   -  EXCLUSAO
	-- ***********************  TRATA AS BIOMETRIAS  QUE FICARAM PENDENTES NA EXCLUSAO
	-- altera status dos codins Sagem para exclusao de biometria, se esses no estiverem com exclusao de biometria ou estiverem pendentes

	DECLARE cur_autoExc1 CURSOR FOR 
		(SELECT distinct END_IP, BIO_TIPO from DIG104 
			--WHERE (STATUS != '0' and STATUS != '2' and BIO_TIPO = '8')
			WHERE (STATUS != '0' and STATUS != '2' and STATUS != '4')		-- statys 4 indica resposta do rep de nao implementado
		)
	OPEN cur_autoExc1
	FETCH NEXT FROM cur_autoExc1 INTO @z_endip, @z_biotipo

	WHILE (@@fetch_status != -1) BEGIN
		UPDATE DIG102 set STATUS = '1'
			WHERE (END_IP = @z_endip) and 
			  	  --(STATUS = '0' or STATUS = '3') and 
			  	  (STATUS = '0' or STATUS = '3' or STATUS = '4') and 		-- statys 4 indica resposta do rep de nao implementado
				  (BIO_TIPO = @z_biotipo)

		FETCH NEXT FROM cur_autoExc1 INTO @z_endip, @z_biotipo
	END
	CLOSE cur_autoExc1
	deallocate cur_autoExc1
	


	-- ********************   TRATA EQUIPAMENTOS TSI1 QUE FICARAM EM ESTADO EXCLUINDO OU SOFRERAM CARGA DE APLICATIVO
	-- equipamentos  q ficaram em estado de excluindo '2' por mais de 2 minutos ou
	-- equipamentos que sofreram exclusao/recarga de aplicativo 

	DECLARE cur_autoExc1 CURSOR FOR 
		(SELECT distinct END_IP, BIO_TIPO, STATUS from DIG102 
			WHERE (((BIO_TIPO != '6') and (BIO_TIPO != '7') and (BIO_TIPO != '8')) 
					and
					(status = '5' or status = '6' or 													-- CARGA DE APLICATIVO
					(status = '2' and DATEADD (MINUTE, 2, data_load)  < getdate()))   
				  )			
		)			
	OPEN cur_autoExc1
	FETCH NEXT FROM cur_autoExc1 INTO @z_endip,  @z_biotipo, @z_status

	while @@fetch_status != -1
	begin
		if (@z_status = '2') begin
			UPDATE DIG104 set status = '1'
				WHERE (END_IP = @z_endip) and (status = '2') and (BIO_TIPO = @z_biotipo)	-- deixa como status a carregar somente na situacao de problemas (status = '2')

			UPDATE DIG102 set status = '1' 
				WHERE (END_IP = @z_endip  and BIO_TIPO = @z_biotipo)
		end
				
		else if (@z_status = '5'  or @z_status = '6') begin
			UPDATE DIG102 set status = '0' where (end_ip = @z_endip and BIO_TIPO = @z_biotipo)	
		end;
				
		FETCH NEXT FROM cur_autoExc1 INTO @z_endip, @z_biotipo, @z_status
	end
	CLOSE cur_autoExc1
	deallocate cur_autoExc1



	-- ***********************  TRATA AS BIOMETRIAS TSI1 QUE FICARAM EM ESTADO DE EXCLUINDO E NAO SAI DESTA SITUAO
	-- para digitais de DIG104 que ficaram em estado excluindo '2'	, forca o equipamento a exclui-lo novamente

	DECLARE cur_autoExc1 CURSOR FOR 
		(SELECT  A.END_IP, A.STATUS, A.BIO_TIPO from DIG102 A 
			INNER JOIN DIG104 B ON
				A.END_IP = B.END_IP and
				A.STATUS = '0' and 
				B.STATUS = '2' and
				A.BIO_TIPO = B.BIO_TIPO)
	OPEN cur_autoExc1
	FETCH NEXT FROM cur_autoExc1 INTO @z_endip, @z_status, @z_biotipo

	WHILE (@@fetch_status != -1) BEGIN
		UPDATE DIG104 SET STATUS = '1' 
			WHERE END_IP = @z_endip AND STATUS = '2' and BIO_TIPO = @z_biotipo;
		UPDATE DIG102 set STATUS = '1' 
			WHERE END_IP = @z_endip and BIO_TIPO = @z_biotipo;
	
		FETCH NEXT FROM cur_autoExc1 INTO @z_endip, @z_status, @z_biotipo;
	END
	CLOSE cur_autoExc1
	deallocate cur_autoExc1

	SET LOCK_TIMEOUT -1
	
	GO



SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS ON 
GO
