if object_id('trata4_tsi1', 'p') is null
    exec ('create procedure trata4_tsi1 as select 1')
go

ALTER PROCEDURE trata4_tsi1 AS

DECLARE @ret CHAR(1)
DECLARE @z_endip CHAR(15)
DECLARE @z_biotipo CHAR(1)
DECLARE @z_status CHAR(1)

DECLARE @z_mat CHAR(12)
DECLARE @aux_icard CHAR(12)
DECLARE @aux_endip CHAR(15)

SET DATEFORMAT YMD

	SET LOCK_TIMEOUT 3000


	-- ********************   ARRUMAR SITUAES PARA TSI1    -  INCLUSAO
	-- ***********************  TRATA AS BIOMETRIAS SAGEM QUE FICARAM PENDENTES NA CARGA E QUE NAO SERAO REENVIADAS AUTOMATICAMENTE
	-- SITUACAO EM QUE CARGA FICOU PENDENTE PORQUE EQUIPAMENTO REJEITOU A CARGA  (status '4')
	DECLARE cur_troubleIns1 CURSOR FOR 
		(SELECT distinct ICARD from DIG003 
			WHERE STATUS = '4'
		)
	OPEN cur_troubleIns1
	FETCH NEXT FROM cur_troubleIns1 INTO @z_mat
	WHILE (@@fetch_status != -1) BEGIN
		DECLARE cur_troubleIns2 CURSOR FOR 
			(SELECT END_IP from DIG003 
				WHERE (ICARD = @z_mat and STATUS = '4')
			)
		OPEN cur_troubleIns2
		FETCH NEXT FROM cur_troubleIns2 INTO @z_endip

		WHILE (@@fetch_status != -1) BEGIN
			--DELETE DIG003 WHERE (END_IP = @z_endip and ICARD = @z_mat and STATUS = '4')
			UPDATE DIG003 SET STATUS = '0' WHERE (END_IP = @z_endip and ICARD = @z_mat and STATUS = '4')

			UPDATE DIG002 set status = '1'WHERE (END_IP =  @z_endip AND STATUS = '3') ;

			FETCH NEXT FROM cur_troubleIns2 INTO @z_endip
		END


		CLOSE cur_troubleIns2
		deallocate cur_troubleIns2

		FETCH NEXT FROM cur_troubleIns1 INTO @z_mat
	END
	
	CLOSE cur_troubleIns1
	deallocate cur_troubleIns1

	

	-- ***********************  TRATA AS BIOMETRIAS TSI1 QUE FICARAM PENDENTES NA CARGA
	-- SITUACAO EM QUE CARGA FICOU PENDENTE PORQUE HOUVE DELETE DE REGISTROS DOS TSI1 (DA TAB.CONTDIG_TSI1 CADASTRO)
	-- delete registro de DIG003 se nao houver cadastro de BIO TSI1 desta matricula
	DECLARE cur_autoIns1 CURSOR FOR 
		(SELECT distinct ICARD from DIG003 
			WHERE STATUS = '3'
		)
	OPEN cur_autoIns1
	FETCH NEXT FROM cur_autoIns1 INTO @z_mat
	WHILE (@@fetch_status != -1) BEGIN
		-- VERIFICA SE H CADASTRO DO BIO TSI1 DA MATRICULA
		SELECT @aux_icard = ICARD FROM CONTDIG_TSI1 WHERE ICARD = @z_mat;
		IF (@@ROWCOUNT = 0)	BEGIN
			-- nao ha cadastro de BIO TSI1 desta matricula
			DECLARE cur_autoIns2 CURSOR FOR 
				(SELECT END_IP from DIG003 
					WHERE (ICARD = @z_mat and STATUS = '3')
				)
			OPEN cur_autoIns2
			FETCH NEXT FROM cur_autoIns2 INTO @z_endip

			WHILE (@@fetch_status != -1) BEGIN
				--UPDATE DIG003 set status = '0' WHERE (END_IP = @z_endip and ICARD = @z_mat and STATUS = '3')
				DELETE DIG003 WHERE (END_IP = @z_endip and ICARD = @z_mat and STATUS = '3')

				UPDATE DIG002 set status = '1'WHERE (END_IP =  @z_endip AND STATUS = '3') ;

				FETCH NEXT FROM cur_autoIns2 INTO @z_endip
			END


			CLOSE cur_autoIns2
			deallocate cur_autoIns2
		END

		FETCH NEXT FROM cur_autoIns1 INTO @z_mat
	END
	
	CLOSE cur_autoIns1
	deallocate cur_autoIns1







	-- altera status de todos os codins para carga de digitais, se esses no estiverem com carga de digitais ou estiverem pendentes

	DECLARE cur_endip CURSOR FOR 
		(SELECT distinct END_IP, BIO_TIPO from DIG003 
			WHERE (STATUS != '0' and STATUS != '2' AND BIO_TIPO = '8')		-- biometrias pendentes na carga
		)
	OPEN cur_endip
	FETCH NEXT FROM cur_endip INTO @z_endip, @z_biotipo
	
	while @@fetch_status != -1
	begin
		UPDATE DIG002 set status = '1'
			WHERE (END_IP = @z_endip and 
					(STATUS = '0' or STATUS= '3') and 
				  	BIO_TIPO = @z_biotipo)
		FETCH NEXT FROM cur_endip INTO @z_endip, @z_biotipo
	end
	CLOSE cur_endip
	deallocate cur_endip



	-- ********************   TRATA EQUIPAMENTOS TSI1 QUE FICARAM EM ESTADO CARREGANDO OU SOFRERAM CARGA DE APLICATIVO
	-- equipamentos TSI1 q ficaram em estado de carregando '2' por mais de 2 minutos OU
	-- equipamentos TSI1 q tiveram carga de aplicativo 
	DECLARE cur_dig02 CURSOR FOR 
		(SELECT END_IP, BIO_TIPO, STATUS from DIG002 
			WHERE ((BIO_TIPO = '8')
					and
				   (status = '5' or status = '6' OR			-- CARGA DE APLICATIVO
				   (status = '2' and DATEADD (MINUTE, 2, data_load)  < getdate()))
				  )
		)
	OPEN cur_dig02
	FETCH NEXT FROM cur_dig02 INTO @z_endip, @z_biotipo, @z_status

	WHILE @@fetch_status != -1
	begin
		-- OBSERVACAO: PARA BIOMETRIA TSI1, A CARGA DE APLICATIVO NO EQUIPAMENTO NAO APAGA AS BIOMETRIAS, POIS BIOMETRIA TSI1 FICA NO LEITOR E NAO NO EQUIPAMENTO,
		-- LOGO NAO  NECESSARIO FAZER A RECARGA DE BIOMETRIA
		IF (@z_status = '2') begin		-- situao q estava fazendo a carga e deu problema

			UPDATE DIG003 set STATUS = '1'			-- status = 1 : a carregar
				WHERE (END_IP = @z_endip and STATUS = '2'  and BIO_TIPO = @z_biotipo) 

			UPDATE DIG002 set status = '1' 
				where (END_IP = @z_endip and BIO_TIPO = @z_biotipo)
		end

		ELSE begin
			IF (@z_status = '5' or @z_status = '6') begin		-- HOUVE CARGA DE APLICATIVO, MAS NAO VAI RECARREGAR AS BIOMETRIAS
				UPDATE DIG002 set status = '0' 
					WHERE (end_ip = @z_endip  and BIO_TIPO = @z_biotipo)
			end
		end
		
		FETCH NEXT FROM cur_dig02 INTO @z_endip, @z_biotipo, @z_status
	end

	CLOSE cur_dig02
	DEALLOCATE cur_dig02
	


	-- ***********************  TRATA AS BIOMETRIAS TSI1 QUE FICARAM EM ESTADO DE CARREGANDO E NAO SAI DESTA SITUAO
	-- para BIOMETRIAS  TSI1 DE DIG003 que ficaram em estado carregando '2', e o equipamento est em estado de repouso	, forca o equipamento a carrega-lo novamente

	DECLARE cur_dig02 CURSOR FOR 
		(SELECT A.END_IP, A.status from DIG002 A 
			INNER JOIN DIG003 B ON
				A.END_IP = B.END_IP and 
				A.STATUS = '0' and 
				B.STATUS = '2' and
				A.BIO_TIPO = '8')
	OPEN cur_dig02
	FETCH NEXT FROM cur_dig02 INTO @z_endip, @z_status

	WHILE (@@fetch_status != -1) BEGIN
		UPDATE DIG003 SET STATUS = '1' 
			WHERE END_IP = @z_endip AND STATUS = '2' AND BIO_TIPO = '8';
		UPDATE DIG002 set STATUS = '1' 
			WHERE END_IP = @z_endip  and BIO_TIPO = '8';
			
		FETCH NEXT FROM cur_dig02 INTO @z_endip, @z_status;
	END
	CLOSE cur_dig02
	deallocate cur_dig02
	


	-- ********************   ARRUMAR SITUAES PARA   TSI1   -  EXCLUSAO
	-- ***********************  TRATA AS BIOMETRIAS TSI1 QUE FICARAM PENDENTES NA EXCLUSAO
	-- altera status dos codins Sagem para exclusao de biometria, se esses no estiverem com exclusao de biometria ou estiverem pendentes

	DECLARE cur_autoExc1 CURSOR FOR 
		(SELECT distinct END_IP, BIO_TIPO from DIG103 
			WHERE (STATUS != '0' and STATUS != '2' and BIO_TIPO = '8')
		)
	OPEN cur_autoExc1
	FETCH NEXT FROM cur_autoExc1 INTO @z_endip, @z_biotipo

	WHILE (@@fetch_status != -1) BEGIN
		UPDATE DIG102 set STATUS = '1'
			WHERE (END_IP = @z_endip) and 
			  	  (STATUS = '0' or STATUS = '3') and 
				  (BIO_TIPO = '8')

		FETCH NEXT FROM cur_autoExc1 INTO @z_endip, @z_biotipo
	END
	CLOSE cur_autoExc1
	deallocate cur_autoExc1
	


	-- ********************   TRATA EQUIPAMENTOS TSI1 QUE FICARAM EM ESTADO EXCLUINDO OU SOFRERAM CARGA DE APLICATIVO
	-- equipamentos  q ficaram em estado de excluindo '2' por mais de 2 minutos ou
	-- equipamentos que sofreram exclusao/recarga de aplicativo 

	DECLARE cur_autoExc1 CURSOR FOR 
		(SELECT distinct END_IP, BIO_TIPO, STATUS from DIG102 
			WHERE ( (BIO_TIPO = '8')
					and
					(status = '5' or status = '6' or 													-- CARGA DE APLICATIVO
					(status = '2' and DATEADD (MINUTE, 2, data_load)  < getdate()))   
				  )			
		)			
	OPEN cur_autoExc1
	FETCH NEXT FROM cur_autoExc1 INTO @z_endip,  @z_biotipo, @z_status

	while @@fetch_status != -1
	begin
		if (@z_status = '2') begin
			UPDATE DIG103 set status = '1'
				WHERE (END_IP = @z_endip) and (status = '2') and (BIO_TIPO = @z_biotipo)	-- deixa como status a carregar somente na situacao de problemas (status = '2')

			UPDATE DIG102 set status = '1' 
				WHERE (END_IP = @z_endip  and BIO_TIPO = @z_biotipo)
		end
				
		else if (@z_status = '5' or @z_status = '6') begin
			UPDATE DIG102 set status = '0' where (end_ip = @z_endip and BIO_TIPO = @z_biotipo)	
		end;
				
		FETCH NEXT FROM cur_autoExc1 INTO @z_endip, @z_biotipo, @z_status
	end
	CLOSE cur_autoExc1
	deallocate cur_autoExc1



	-- ***********************  TRATA AS BIOMETRIAS TSI1 QUE FICARAM EM ESTADO DE EXCLUINDO E NAO SAI DESTA SITUAO
	-- para digitais de DIG103 que ficaram em estado excluindo '2'	, forca o equipamento a exclui-lo novamente

	DECLARE cur_autoExc1 CURSOR FOR 
		(SELECT  A.END_IP, A.status from DIG102 A 
			INNER JOIN DIG103 B ON
				A.END_IP = B.END_IP and
				A.STATUS = '0' and 
				B.STATUS = '2' and
				A.BIO_TIPO = '8')
	OPEN cur_autoExc1
	FETCH NEXT FROM cur_autoExc1 INTO @z_endip, @z_status

	WHILE (@@fetch_status != -1) BEGIN
		UPDATE DIG103 SET STATUS = '1' 
			WHERE END_IP = @z_endip AND STATUS = '2' and BIO_TIPO = '8';
		UPDATE DIG102 set STATUS = '1' 
			WHERE END_IP = @z_endip and BIO_TIPO = '8';
	
		FETCH NEXT FROM cur_autoExc1 INTO @z_endip, @z_status;
	END
	CLOSE cur_autoExc1
	deallocate cur_autoExc1

	SET LOCK_TIMEOUT -1
	
	GO



SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS ON 
GO
