if object_id('trata4_sagem', 'p') is null
    exec ('create procedure trata4_sagem as select 1')
go

ALTER PROCEDURE trata4_sagem AS

DECLARE @ret CHAR(1)
DECLARE @z_endip CHAR(15)
DECLARE @z_biotipo CHAR(1)
DECLARE @z_status CHAR(1)

DECLARE @z_mat CHAR(12)
DECLARE @aux_icard CHAR(12)
DECLARE @aux_endip CHAR(15)

SET DATEFORMAT YMD

	SET LOCK_TIMEOUT 3000


	-- ********************   ARRUMAR SITUAES PARA SAGEM    -  INCLUSAO
	-- ***********************  TRATA AS BIOMETRIAS SAGEM QUE FICARAM PENDENTES NA CARGA E QUE NAO SERAO REENVIADAS AUTOMATICAMENTE
	-- SITUACAO EM QUE CARGA FICOU PENDENTE PORQUE EQUIPAMENTO REJEITOU A CARGA (status '4')
	DECLARE cur_troubleIns1 CURSOR FOR 
		(SELECT distinct ICARD from DIG001 
			WHERE STATUS = '4'
		)
	OPEN cur_troubleIns1
	FETCH NEXT FROM cur_troubleIns1 INTO @z_mat
	WHILE (@@fetch_status != -1) BEGIN
		DECLARE cur_troubleIns2 CURSOR FOR 
			(SELECT END_IP from DIG001 
				WHERE (ICARD = @z_mat and STATUS = '4')
			)
		OPEN cur_troubleIns2
		FETCH NEXT FROM cur_troubleIns2 INTO @z_endip

		WHILE (@@fetch_status != -1) BEGIN
			--DELETE DIG001 WHERE (END_IP = @z_endip and ICARD = @z_mat and STATUS = '4')	-- vai excluir registro porque nao adianta reenviar 
			UPDATE DIG001 SET STATUS = '0' WHERE (END_IP = @z_endip and ICARD = @z_mat and STATUS = '4')	-- vai alterar status para concluido  porque nao adianta reenviar 

			UPDATE DIG002 set status = '1'WHERE (END_IP =  @z_endip AND STATUS = '3') ;

			FETCH NEXT FROM cur_troubleIns2 INTO @z_endip
		END


		CLOSE cur_troubleIns2
		deallocate cur_troubleIns2

		FETCH NEXT FROM cur_troubleIns1 INTO @z_mat
	END
	
	CLOSE cur_troubleIns1
	deallocate cur_troubleIns1



	-- ***********************  TRATA AS BIOMETRIAS SAGEM QUE FICARAM PENDENTES NA CARGA
	-- SITUACAO EM QUE CARGA FICOU PENDENTE PORQUE HOUVE DELETE DE REGISTROS DOS SAGEM (DA TAB.CONTDIG_SAGEM CADASTRO)
	-- delete registro de DIG001 se nao houver cadastro de BIO SAGEM desta matricula
	DECLARE cur_autoIns1 CURSOR FOR 
		(SELECT distinct ICARD from DIG001 
			WHERE STATUS = '3'
		)
	OPEN cur_autoIns1
	FETCH NEXT FROM cur_autoIns1 INTO @z_mat
	WHILE (@@fetch_status != -1) BEGIN
		-- VERIFICA SE H CADASTRO DO BIO SAGEM DA MATRICULA
		SELECT @aux_icard = ICARD FROM CONTDIG_SAGEM WHERE ICARD = @z_mat;
		IF (@@ROWCOUNT = 0)	BEGIN
			-- nao ha cadastro de BIO SAGEM desta matricula
			DECLARE cur_autoIns2 CURSOR FOR 
				(SELECT END_IP from DIG001 
					WHERE (ICARD = @z_mat and STATUS = '3')
				)
			OPEN cur_autoIns2
			FETCH NEXT FROM cur_autoIns2 INTO @z_endip

			WHILE (@@fetch_status != -1) BEGIN
				--UPDATE DIG001 set status = '0' WHERE (END_IP = @z_endip and ICARD = @z_mat and STATUS = '3')
				DELETE DIG001 WHERE (END_IP = @z_endip and ICARD = @z_mat and STATUS = '3')

				UPDATE DIG002 set status = '1'WHERE (END_IP =  @z_endip AND STATUS = '3') ;

				FETCH NEXT FROM cur_autoIns2 INTO @z_endip
			END


			CLOSE cur_autoIns2
			deallocate cur_autoIns2
		END

		FETCH NEXT FROM cur_autoIns1 INTO @z_mat
	END
	
	CLOSE cur_autoIns1
	deallocate cur_autoIns1



	-- altera status de todos os codins para carga de digitais, se esses no estiverem com carga de digitais ou estiverem pendentes

	DECLARE cur_endip CURSOR FOR 
		(SELECT distinct END_IP, BIO_TIPO from DIG001 
			WHERE ( status != '0' and status != '2' and			-- biometrias pendentes na carga
					(BIO_TIPO = '6' OR BIO_TIPO = '7')
				  )
		)
	OPEN cur_endip
	FETCH NEXT FROM cur_endip INTO @z_endip, @z_biotipo
	
	WHILE @@fetch_status != -1
	begin
		UPDATE DIG002 set status = '1'						-- FORCA RECARGA DAS BIOMETRIAS PENDENTES, ATIVANDO DIG002
			WHERE (END_IP = @z_endip and 
					(STATUS = '0' or STATUS = '3') and 
					BIO_TIPO = @z_biotipo)
		FETCH NEXT FROM cur_endip INTO @z_endip, @z_biotipo
	end

	CLOSE cur_endip
	deallocate cur_endip




	-- ********************   TRATA EQUIPAMENTOS SAGEM QUE FICARAM EM ESTADO CARREGANDO OU SOFRERAM CARGA DE APLICATIVO
	-- equipamentos SAGEM q ficaram em estado de carregando '2' por mais de 2 minutos OU
	-- equipamentos SAGEM que tiveram carga de aplicativo ('5') de devem voltar ao estado de repouso. OBS: nao est fazenda a recarga de biometria automaticamente.
	
	DECLARE cur_dig02 CURSOR FOR 
		(SELECT END_IP, BIO_TIPO, STATUS from DIG002 
			WHERE ((BIO_TIPO = '6' or BIO_TIPO = '7')
				   and
				   (status = '5' or status = '6' OR		-- CARGA DE APLICATIVO
				   (status = '2' and DATEADD (MINUTE, 2, data_load)  < getdate())) 
				  )
		)
	OPEN cur_dig02
	FETCH NEXT FROM cur_dig02 INTO @z_endip, @z_biotipo, @z_status
	
	WHILE @@fetch_status != -1
	begin
		if (@z_status = '2') begin
			UPDATE DIG001 set STATUS = '1'			-- status = 1 (A carregar)
				WHERE (end_ip = @z_endip and status = '2' and BIO_TIPO = @z_biotipo)	-- deixa como status a carregar somente na situacao de problemas (status = '2')
					
			UPDATE DIG002 set status = '1'  		-- FORA A RECARGA PARA AQUELS QUE DERAM PROBLEMA
				where (end_ip = @z_endip and BIO_TIPO = @z_biotipo)
		end

		else if (@z_status = '5' or @z_status = '6') begin
			-- exec TELESSVR.recarga_sagem @z_endip							-- CHAMADA DE PROCEDURE QUE PREPARA DIG001 COM AS MATRICULAS A SEREM CARREGADAS NO EQUIPMENTO QUE TEVE CARGA DE APLICATIVO
			-- UPDATE DIG002 set status = '1' where (end_ip = @z_endip)		-- FAZ RECARGA DE BIOMETRIAS SAGEM APOS CARGA DE APLICATIVO, automaticamente

			UPDATE DIG002 set status = '0' where (end_ip = @z_endip and BIO_TIPO = @z_biotipo)		-- NAO FAZ RECARGA DE BIOMETRIAS SAGEM APOS CARGA DE APLICATIVO
		end;
		
		FETCH NEXT FROM cur_dig02 INTO @z_endip, @z_biotipo, @z_status
	end
	CLOSE cur_dig02
	DEALLOCATE cur_dig02
	

	-- ***********************  TRATA AS BIOMETRIAS SAGEM QUE FICARAM EM ESTADO DE CARREGANDO E NAO SAI DESTA SITUAO
	-- para BIOMETRIAS  SAGEM DE DIG001 que ficaram em estado carregando '2', e o equipamento est em estado de repouso	, forca o equipamento a carrega-lo novamente
	
	DECLARE cur_dig02 CURSOR FOR 
		(SELECT A.END_IP, A.STATUS from DIG002 A 
			INNER JOIN DIG001 B ON
				A.END_IP = B.END_IP and 
				A.STATUS = '0' and 
				B.STATUS = '2' and
				(A.BIO_TIPO = '6') or (A.BIO_TIPO = '7')) 
	OPEN cur_dig02
	FETCH NEXT FROM cur_dig02 INTO @z_endip, @z_status

	WHILE (@@fetch_status != -1) BEGIN
		UPDATE DIG001 SET STATUS = '1' 
			WHERE END_IP = @z_endip AND STATUS = '2' and (BIO_TIPO = '6' or BIO_TIPO = '7');
		UPDATE DIG002 set STATUS = '1' 
			WHERE END_IP = @z_endip and (BIO_TIPO = '6' or BIO_TIPO = '7');
		
		FETCH NEXT FROM cur_dig02 INTO @z_endip, @z_status;
	END
	CLOSE cur_dig02
	deallocate cur_dig02
	

	


	-- ********************   ARRUMAR SITUAES PARA SAGEM    -  EXCLUSAO
	
	-- ***********************  TRATA AS BIOMETRIAS SAGEM QUE FICARAM PENDENTES NA EXCLUSAO
	-- altera status dos codins Sagem para exclusao de biometria, se esses no estiverem com exclusao de biometria ou estiverem pendentes

	DECLARE cur_autoExc1 CURSOR FOR 
		(SELECT distinct END_IP, BIO_TIPO  from DIG101 
			WHERE ( STATUS != '0' and STATUS != '2' and  STATUS != '4' and 
					(BIO_TIPO = '6' or BIO_TIPO = '7')
				  )
		)
	OPEN cur_autoExc1
	FETCH NEXT FROM cur_autoExc1 INTO @z_endip, @z_biotipo

	WHILE (@@fetch_status != -1) BEGIN
		UPDATE DIG102 set status = '1'
			WHERE (END_IP = @z_endip) and 
				(STATUS = '0' or STATUS = '3') and 
				(BIO_TIPO = '6' or BIO_TIPO = '7')

		FETCH NEXT FROM cur_autoExc1 INTO @z_endip, @z_biotipo
	END
	CLOSE cur_autoExc1
	deallocate cur_autoExc1



	
	
	-- ********************   TRATA EQUIPAMENTOS SAGEM QUE FICARAM EM ESTADO EXCLUINDO OU SOFRERAM CARGA DE APLICATIVO
	-- equipamentos  q ficaram em estado de excluindo '2' por mais de 2 minutos ou
	-- equipamentos que sofreram exclusao/recarga de aplicativo 

	DECLARE cur_autoExc1 CURSOR FOR 
		(SELECT distinct END_IP, BIO_TIPO, STATUS from DIG102 
			WHERE ( (BIO_TIPO = '6' or BIO_TIPO = '7')
					and
					(status = '5' or status = '6' or 													-- CARGA DE APLICATIVO
					(status = '2' and DATEADD (MINUTE, 2, data_load)  < getdate()))   
				  )			
		)			
	OPEN cur_autoExc1
	FETCH NEXT FROM cur_autoExc1 INTO @z_endip, @z_biotipo, @z_status

	while @@fetch_status != -1
	begin
		if (@z_status = '2') begin

			UPDATE DIG101 set status = '1'
				WHERE (END_IP = @z_endip and STATUS = '2' and BIO_TIPO = @z_biotipo)	-- deixa como status a carregar somente na situacao de problemas (status = '2')

			UPDATE DIG102 set status = '1' 
					where (end_ip = @z_endip and BIO_TIPO = @z_biotipo)
		end
		
		else if (@z_status = '5' or @z_status = '6') begin
			UPDATE DIG102 set status = '0' where (end_ip = @z_endip and BIO_TIPO = @z_biotipo)	
		end;

		FETCH NEXT FROM cur_autoExc1 INTO @z_endip, @z_biotipo, @z_status
	end
	CLOSE cur_autoExc1
	deallocate cur_autoExc1



	-- ***********************  TRATA AS BIOMETRIAS SAGEM QUE FICARAM EM ESTADO DE EXCLUINDO E NAO SAI DESTA SITUAO
	-- para digitais de DIG101 que ficaram em estado excluindo '2'	, forca o equipamento a exclui-lo novamente

	DECLARE cur_autoExc1 CURSOR FOR 
		(SELECT  A.END_IP, A.status from DIG102 A 
			INNER JOIN DIG101 B ON
				A.END_IP = B.END_IP and
				A.STATUS = '0' and 
				B.STATUS = '2' and
				(A.BIO_TIPO = '6' or A.BIO_TIPO = '7'))
	OPEN cur_autoExc1
	FETCH NEXT FROM cur_autoExc1 INTO @z_endip, @z_status

	WHILE (@@fetch_status != -1) BEGIN
		UPDATE DIG101 SET STATUS = '1' 
			WHERE END_IP = @z_endip AND STATUS = '2' and (BIO_TIPO = '6' or BIO_TIPO = '7');
		UPDATE DIG102 set STATUS = '1' 
			WHERE END_IP = @z_endip AND (BIO_TIPO = '6' or BIO_TIPO = '7');

		FETCH NEXT FROM cur_autoExc1 INTO @z_endip, @z_status;
	END
	CLOSE cur_autoExc1
	deallocate cur_autoExc1

	SET LOCK_TIMEOUT -1

GO
