if object_id('trata3_palmv', 'p') is null
    exec ('create procedure trata3_palmv as select 1')
go

ALTER PROCEDURE trata3_palmv AS

DECLARE @ret CHAR(1)
DECLARE @z_endip CHAR(15)
DECLARE @z_status CHAR(1)
DECLARE @z_mat CHAR(12)
DECLARE @aux_icard CHAR(12)
DECLARE @aux_endip CHAR(15)

SET DATEFORMAT YMD

	SET LOCK_TIMEOUT 3000

	-- ********************   ARRUMAR SITUAES PARA PALMVEIN INCLUSAO
	-- ***********************  TRATA AS BIOMETRIAS PALMVEIN QUE FICARAM PENDENTES NA CARGA E QUE NAO SERAO REENVIADAS AUTOMATICAMENTE
	-- SITUACAO EM QUE CARGA FICOU PENDENTE PORQUE EQUIPAMENTO REJEITOU A CARGA (status '4')
	DECLARE cur_troubleIns1 CURSOR FOR 
		(SELECT distinct ICARD from PALMV014 
			WHERE STATUS = '4'
		)
	OPEN cur_troubleIns1
	FETCH NEXT FROM cur_troubleIns1 INTO @z_mat
	WHILE (@@fetch_status != -1) BEGIN
		DECLARE cur_troubleIns2 CURSOR FOR 
			(SELECT END_CTRLPALMV from PALMV014 
				WHERE (ICARD = @z_mat and STATUS = '4')
			)
		OPEN cur_troubleIns2
		FETCH NEXT FROM cur_troubleIns2 INTO @z_endip
	
		WHILE (@@fetch_status != -1) BEGIN
			--DELETE PALMV014 WHERE (END_CTRLPALMV = @z_endip and ICARD = @z_mat and STATUS = '4')	-- vai excluir registro porque nao adianta reenviar 
			UPDATE PALMV014 SET STATUS = '0' WHERE (END_CTRLPALMV = @z_endip and ICARD = @z_mat and STATUS = '4')	-- vai alterar status para 0  porque nao adianta reenviar 
	
			UPDATE PALMV004 set status = '1'WHERE (END_CTRLPALMV =  @z_endip AND STATUS = '3') ;
	
			FETCH NEXT FROM cur_troubleIns2 INTO @z_endip
		END
	
	
		CLOSE cur_troubleIns2
		deallocate cur_troubleIns2
	
		FETCH NEXT FROM cur_troubleIns1 INTO @z_mat
	END
		
	CLOSE cur_troubleIns1
	deallocate cur_troubleIns1
	

	-- ***********************  TRATA AS PALMVEIN QUE FICARAM PENDENTES NA CARGA	
	-- SITUACAO EM QUE CARGA FICOU PENDENTE PORQUE HOUVE DELETE DE REGISTROS DOS PALMVEINS (DA TAB.PALMV001 CADASTRO)
	-- delete registro de PALMV014 se nao houver cadastro de palmvein desta matricula
	DECLARE cur_autoIns1 CURSOR FOR 
		(SELECT distinct ICARD from PALMV014 
			WHERE STATUS = '3'
		)
	OPEN cur_autoIns1
	FETCH NEXT FROM cur_autoIns1 INTO @z_mat
	WHILE (@@fetch_status != -1) BEGIN
		-- VERIFICA SE H CADASTRO DO PALMVEIN DA MATRICULA
		SELECT @aux_icard = ICARD FROM PALMV001 WHERE ICARD = @z_mat;
		IF (@@ROWCOUNT = 0)	BEGIN
			-- nao ha cadastro de palmvein desta matricula
			DECLARE cur_autoIns2 CURSOR FOR 
				(SELECT END_CTRLPALMV from PALMV014 
					WHERE (ICARD = @z_mat and STATUS = '3')
				)
			OPEN cur_autoIns2
			FETCH NEXT FROM cur_autoIns2 INTO @z_endip

			WHILE (@@fetch_status != -1) BEGIN
				--UPDATE PALMV014 set status = '0' WHERE (END_CTRLPALMV = @z_endip and ICARD = @z_mat and STATUS = '3')
				DELETE PALMV014 WHERE (END_CTRLPALMV = @z_endip and ICARD = @z_mat and STATUS = '3')

				UPDATE PALMV004 set status = '1'WHERE (END_CTRLPALMV =  @z_endip AND STATUS = '3') ;

				FETCH NEXT FROM cur_autoIns2 INTO @z_endip
			END


			CLOSE cur_autoIns2
			deallocate cur_autoIns2
		END

		FETCH NEXT FROM cur_autoIns1 INTO @z_mat
	END
	
	CLOSE cur_autoIns1
	deallocate cur_autoIns1
	
	
	-- altera status dos codins SensoBox para carga de palmvein, se esses no estiverem com carga de palmvein ou estiverem pendentes
	DECLARE cur_autoIns1 CURSOR FOR 
		(SELECT distinct END_CTRLPALMV from PALMV014 
			WHERE (STATUS != '0' and STATUS != '2')
		)
	OPEN cur_autoIns1
	FETCH NEXT FROM cur_autoIns1 INTO @z_endip
	
	WHILE (@@fetch_status != -1) BEGIN
		UPDATE PALMV004 set status = '1'
			WHERE END_CTRLPALMV = @z_endip and (STATUS = '0' or STATUS = '3')
			
		FETCH NEXT FROM cur_autoIns1 INTO @z_endip
	END
		
	CLOSE cur_autoIns1
	deallocate cur_autoIns1
	
	
	-- ********************   TRATA EQUIPAMENTOS PALMVEIN QUE FICARAM EM ESTADO CARREGANDO OU SOFRERAM CARGA DE APLICATIVO
	-- equipamentos PALMVEIN q ficaram em estado de carregando '2' por mais de 2 minutos OU
	-- equipamentos PALMVEIN q tiveram carga de aplicativo 

	DECLARE cur_autoIns1 CURSOR FOR 
		(SELECT distinct END_CTRLPALMV, STATUS from PALMV004 
			WHERE ((status = '5') or 		-- CARGA DE APLICATIVO
				   ((status = '2') and (DATEADD (MINUTE, 2, data_load)  < getdate()) )
				  )
		)
	OPEN cur_autoIns1
	FETCH NEXT FROM cur_autoIns1 INTO @z_endip, @z_status
	while @@fetch_status != -1
	begin
		IF (@z_status = '2') begin		-- situao q estava fazendo a carga e deu problema
			UPDATE PALMV014 set status = '1' WHERE (END_CTRLPALMV = @z_endip and STATUS = '2')
			UPDATE PALMV004 set status = '1' WHERE (END_CTRLPALMV = @z_endip)
		end

		ELSE begin
			IF (@z_status = '5') begin		-- HOUVE CARGA DE APLICATIVO, MAS NAO VAI RECARREGAR AS BIOMETRIAS
				UPDATE PALMV004 set status = '0' WHERE (END_CTRLPALMV = @z_endip)
			end
		end
		
				
		FETCH NEXT FROM cur_autoIns1 INTO @z_endip, @z_status
	end
	CLOSE cur_autoIns1
	deallocate cur_autoIns1
	
	
	-- ***********************  TRATA AS PALMVEIN QUE FICARAM EM ESTADO DE CARREGANDO E NAO SAI DESTA SITUAO
	-- para palms DE PALMV014 que ficaram em estado carregando '2'	, e o equipamento est em estado de repouso	, forca o equipamento a carrega-lo novamente
	
	DECLARE cur_autoIns1 CURSOR FOR 
		(SELECT A.END_CTRLPALMV, A.STATUS from PALMV004 A 
			INNER JOIN PALMV014 B ON
				A.status = '0' AND 
				A.END_CTRLPALMV = B.END_CTRLPALMV AND 
				B.STATUS = '2')
	OPEN cur_autoIns1
	FETCH NEXT FROM cur_autoIns1 INTO @z_endip, @z_status
	
	WHILE (@@fetch_status != -1) BEGIN
		UPDATE PALMV014 SET STATUS = '1' 
			WHERE END_CTRLPALMV = @z_endip AND STATUS = '2';
		UPDATE PALMV004 set STATUS = '1' 
			WHERE END_CTRLPALMV = @z_endip;

		FETCH NEXT FROM cur_autoIns1 INTO @z_endip, @z_status;
	END

	
	CLOSE cur_autoIns1
	deallocate cur_autoIns1
	
	
	-- ********************   ARRUMAR SITUAES PARA PALMV EXCLUSAO
	
	-- ***********************  TRATA AS PALMV QUE FICARAM PENDENTES NA EXCLUSAO
	-- altera status dos codins PALMV para exclusao de palmv, se esses no estiverem com exclusao de palmv ou estiverem pendentes
	DECLARE cur_autoExc1 CURSOR FOR 
		(SELECT distinct END_CTRLPALMV from PALMV015 
			WHERE STATUS != '0' and STATUS != '2' and STATUS != '4')
	OPEN cur_autoExc1
	FETCH NEXT FROM cur_autoExc1 INTO @z_endip
	
	WHILE (@@fetch_status != -1) BEGIN
		UPDATE PALMV005 set status = '1'
			WHERE (END_CTRLPALMV = @z_endip) and 
				  (STATUS = '0' or STATUS = '3')
			
		FETCH NEXT FROM cur_autoExc1 INTO @z_endip
	END
	
	CLOSE cur_autoExc1
	deallocate cur_autoExc1
	
	
	-- ********************   TRATA EQUIPAMENTOS PALMV QUE FICARAM EM ESTADO EXCLUINDO OU SOFRERAM CARGA DE APLICATIVO
	-- equipamentos  q ficaram em estado de excluindo '2' por mais de 2 minutos ou
	-- equipamentos que sofreram exclusao/recarga de aplicativo 
	
	DECLARE cur_autoExc1 CURSOR FOR 
		(SELECT distinct END_CTRLPALMV,STATUS from PALMV005 
			WHERE ( (status = '5') or 													-- CARGA DE APLICATIVO
					(status = '2' and DATEADD (MINUTE, 2, data_load)  < getdate())   
				  )			
		)			
	OPEN cur_autoExc1
	FETCH NEXT FROM cur_autoExc1 INTO @z_endip, @z_status

	while @@fetch_status != -1
	begin
		if (@z_status = '2') begin
			UPDATE PALMV015 set status = '1'
				WHERE (END_CTRLPALMV = @z_endip and status = '2')

			UPDATE PALMV005 set status = '1' 
					where (END_CTRLPALMV = @z_endip )
		end
				
		else if (@z_status = '5') begin
			UPDATE PALMV005 set status = '0' where (END_CTRLPALMV = @z_endip)	
		end;
				
				
		FETCH NEXT FROM cur_autoExc1 INTO @z_endip, @z_status
	end
	CLOSE cur_autoExc1
	deallocate cur_autoExc1
	

	-- ***********************  TRATA AS PALMV QUE FICARAM EM ESTADO DE EXCLUINDO E NAO SAI DESTA SITUAO
	-- para palmv de PALMV015 que ficaram em estado excluindo '2'	, forca o equipamento a exclui-lo novamente

	DECLARE cur_autoExc1 CURSOR FOR 
		(SELECT a.END_CTRLPALMV, a.status 
			from PALMV005 A 
			INNER JOIN PALMV015 B ON
				A.END_CTRLPALMV = B.END_CTRLPALMV AND 
				A.status = '0' AND 
				B.STATUS = '2') 
	OPEN cur_autoExc1
	FETCH NEXT FROM cur_autoExc1 INTO @z_endip, @z_status
	
	WHILE (@@fetch_status != -1) BEGIN
		UPDATE PALMV015 SET STATUS = '1' 
			WHERE END_CTRLPALMV = @z_endip AND STATUS = '2';
		UPDATE PALMV005 set STATUS = '1' 
			WHERE END_CTRLPALMV = @z_endip;
		
		FETCH NEXT FROM cur_autoExc1 INTO @z_endip, @z_status;
	END
	
	
	CLOSE cur_autoExc1
	deallocate cur_autoExc1

	SET LOCK_TIMEOUT -1
	
	GO



SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS ON 
GO
