DROP PROCEDURE sqllim_tempo_cred2
GO
CREATE PROCEDURE sqllim_tempo_cred2 @cMatric VARCHAR(12), @cData VARCHAR(25), @nTipo INT, @cOk VARCHAR(1) OUTPUT AS 
DECLARE
   @RetFun INT,
   @xAno varchar(2),
   @xMes varchar(2),
   @xDia varchar(2),
   @xHora varchar(2),
   @xMinuto varchar(2),
   @xLinha varchar(14),
   @cAno varchar(2),
   @cMes varchar(2),
   @cDia varchar(2),
   @cHora varchar(2),
   @cMinuto varchar(2),
   @nCont INT,
   @nTempoB INT,
   @nTempoR INT,
   @nTempo INT,
   @pos INT,
   @cDatault varchar(10),
   @horario1 DECIMAL(10,0),
   @horario2 DECIMAL(10,0),
   @xBranco varchar(2)
BEGIN
    SELECT @RetFun = 1
    SELECT @nTempoB = 3		-- tempo limite minimo de Beneficio
    SELECT @nTempoR = 3		-- tempo limite minimo de Refeitorio
    SELECT @nCont = 0

    SELECT @cDia = substring(@cData,1,2)
    SELECT @cMes = substring(@cData,3,2)
    SELECT @cAno = substring(@cData,5,2)
    SELECT @cHora = substring(@cData,7,2)
    SELECT @cMinuto = substring(@cData,9,2)

    set @cOk = '1'
    SET @RetFun = 0
    SET @xBranco = '  '

    IF (@nTipo = 1)		-- nTipo = 1 : Beneficio
    BEGIN
	SELECT @nTempo = @nTempoB
        IF (@nTempo = 0)
        BEGIN
	  SET @cOk = '1'
          RETURN (@RetFun)
        END
        SELECT @nCont = count(*) FROM CREDLOG 
          WHERE ICARD = @cMatric and 
                TIPO = CONVERT(VARCHAR(2), @nTipo)
        IF (@nCont > 0)
        BEGIN
	  SELECT @xLinha = MAX(ANO + MES + DIA + HORA) FROM CREDLOG 
	    WHERE ICARD = @cMatric and TIPO = CONVERT(VARCHAR(2), @nTipo) 
	  SELECT @xAno = substring(@xLinha,3,2)            	
          SELECT @xMes = substring(@xLinha,5,2)
	  SELECT @xDia = substring(@xLinha,7,2)
	  SELECT @xHora = substring(@xLinha,9,2)
	  SELECT @xMinuto = substring(@xLinha,11,2)
        END
	ELSE
        BEGIN
	  SET @cOk = '1'
          RETURN (@RetFun)
        END
    END
    ELSE			-- nTipo = 0 : Refeitorio
    BEGIN
	SELECT @nTempo = @nTempoR
        IF (@nTempo = 0)
        BEGIN
	  SET @cOk = '1'
          RETURN (@RetFun)
        END

        SELECT @cDatault = substring (@cData, 11,10);
        SET @pos = PATINDEX ('% %', @cData);
        IF (@pos != 0)
	BEGIN
	  SET @cOk = '1'
          RETURN (@RetFun)
	END

        SELECT @xDia = substring(@cData,11,2)
        SELECT @xMes = substring(@cData,13,2)
        SELECT @xAno = substring(@cData,15,2)
        SELECT @xHora = substring(@cData,17,2)
        SELECT @xMinuto = substring(@cData,19,2)
    END 

    IF ((@xDia = @xBranco) or (@xMes = @xBranco) or (@xAno = @xBranco) or (@xHora = @xBranco) or (@xMinuto = @xBranco))
    BEGIN
	SET @cOk = '1'
        RETURN (@RetFun)
    END

    SELECT @horario1 = convert (int, @cMinuto) + 
                       convert (int, @cHora) * 60 +
                       convert (int, @cDia) * 24 * 60 +
                       convert (int, @cMes) * 31 * 24 * 60 +
                       convert (int, @cAno) * 12 * 31 * 24 * 60
    SELECT @horario2 = convert (int, @xMinuto) +
                       convert (int, @xHora) * 60 +
                       convert (int, @xDia) * 24 * 60 +
                       convert (int, @xMes) * 31 * 24 * 60 +
                       convert (int, @xAno) * 12 * 31 * 24 * 60
    IF (@horario1 >= @horario2) and (@horario1 <= (@horario2 + @nTempo))  
    BEGIN	
      SET @cOk = '0'
    END       
    ELSE
    BEGIN	
      SET @cOk = '1'
    END       
    return (@RetFun)
END
GO


