IF EXISTS (SELECT name FROM sysobjects WHERE name = 'TRGUSUVEIC' AND type = 'TR')
    DROP TRIGGER TRGUSUVEIC
GO
CREATE TRIGGER TRGUSUVEIC ON CONTVEI FOR INSERT , UPDATE, DELETE
      AS
  DECLARE @ICARDV VARCHAR(12),
          @DELETADO SMALLINT
  IF UPDATE (ICARDV) 
  BEGIN
    UPDATE COUNT_BY_VEIC SET ICARDV = INSERTED.ICARDV, CNT = CNT+1
                         FROM COUNT_BY_VEIC, INSERTED
                         WHERE COUNT_BY_VEIC.ICARDV = INSERTED.ICARDV
    IF (@@ROWCOUNT  = 0)     -- NO EXISTE NA TABELA COUNT_BY_VEIC, INSERE
    BEGIN
      INSERT INTO COUNT_BY_VEIC SELECT ICARDV, 1 FROM INSERTED
    END
  END
  SET @DELETADO = (SELECT COUNT(*) FROM DELETED WHERE ICARDV = DELETED.ICARDV)
  IF (@DELETADO > 0)
  BEGIN
    UPDATE COUNT_BY_VEIC SET CNT = CNT-1
    FROM COUNT_BY_VEIC, DELETED
    WHERE COUNT_BY_VEIC.ICARDV = DELETED.ICARDV
  END
GO
