drop procedure sqlsel_oldrepponto
go
CREATE PROCEDURE sqlsel_oldrepponto @cMat CHAR(12)
AS

DECLARE @cRegDatas VARCHAR(104)
declare @hora char(2), @minuto char(2), @segundo char(2), @dia char(2), @mes char(2), @ano char(4), @diasemana char(1),
	@data char(12), @auxDate datetime, @XCONT INT, @fim smallint
	


-- cursor para coletar as marcacoes recentes da matricula
DECLARE CURSOR_ULTREPPTO CURSOR FOR
            SELECT   DTAHORAREP 
            FROM     ULTREPPONTO
            WHERE    IFUNC = @cMat 
            ORDER BY DTAHORAREP DESC

	
	
	
	SET @XCONT = 0			-- contador de marcacoes
	set @fim = 0;			-- condicao para parada de coleta de marcacoes
	
	--SET @cRegDatas = REPLACE(SPACE(100),' ','0'); -- string com 160 '0's
	SET @cRegDatas = ''

	OPEN CURSOR_ULTREPPTO
	FETCH NEXT FROM CURSOR_ULTREPPTO INTO @auxDate
	--WHILE (@@FETCH_STATUS = 0) and (@fim = 0)
	WHILE (@@FETCH_STATUS = 0)
	BEGIN
		SET DATEFIRST 7
		SET @segundo = convert(char(2),datepart(second,@auxDate))
		SET @minuto = convert(char(2),datepart(minute,@auxDate))
		SET @hora = convert(char(2),datepart(hour,@auxDate))
		SET @dia = convert(char(2),datepart(day,@auxDate))
		SET @mes = convert(char(2),datepart(month,@auxDate))
		SET @ano = convert(char(4),datepart(year,@auxDate))

		-- HORA
		execute dbo.aux_data @xvalor = @hora output
		-- MINUTO
		execute dbo.aux_data @xvalor = @minuto output
		-- SEGUNDO
		execute dbo.aux_data @xvalor = @segundo output
		-- DIA
		execute dbo.aux_data @xvalor = @dia output
		-- MES
		execute dbo.aux_data @xvalor = @mes output

		SET @data = @hora+ @minuto+ @segundo+ @dia+ @mes+ substring(@ano,3,2)		-- data e hora: hhmissddmmyy
	
		-- junta as datas/horas de todas as marcacoes
		SET @cRegDatas = @cRegDatas + @data
		SET @XCONT = @XCONT+1
		
		-- obs: s ser coletadas 8 marcacoes. No podera ser mais, pois a tabela ULTREPPONTO S INSERE AT 8. 
		-- CASO QUEIRA COLETAR ACIMA DE 8 MARCACOES, DEVE-SE  TAMBEM ALTERAR A TRIGGER DA TAB.REPPONTO, E ALTERAR O TAMANHO DA VARIAVEL QUE COMPORTA AS 8 MARCACOES
		IF (@XCONT >= 8)
			--SET @fim = 1
			break;
			
		FETCH NEXT FROM CURSOR_ULTREPPTO INTO @auxDate
		
	END
	CLOSE CURSOR_ULTREPPTO
	DEALLOCATE CURSOR_ULTREPPTO

	SELECT  @XCONT, @cRegDatas  
	

SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS ON 
GO


