drop procedure recarga_sagem 
go
create PROCEDURE recarga_sagem 
	@sp_end_ip char(15)
AS
DECLARE @c_status CHAR(1)
DECLARE @c_icard CHAR(12)

DECLARE @xc_status CHAR(1)
DECLARE @xc_icard CHAR(12)
DECLARE @xc_endip CHAR(15)
DECLARE @xc_tipobio CHAR(1)
DECLARE @ret CHAR(1)

DECLARE @z_endip CHAR(15)
DECLARE @nCont SMALLINT

SET DATEFORMAT YMD


	set @ret = 0

	-- cursor para matriculas QUE TEM ACESSO AO CODIN QUE SOFREU A CARGA D APLICATIVO
	DECLARE cur_stdigital CURSOR FOR (select ICARD, STATUS from CONTDIG_SAGEM)

	OPEN cur_stdigital
	FETCH NEXT FROM cur_stdigital INTO @c_icard, @c_status
	WHILE @@fetch_status != -1
	begin

		-- ******************************************************************
		-- para todos icards q alteraram digital, distribui nos equipamentos de acordo com o grupo cadastrado em 
		-- CONTROLE, DAT07,DAT08 
		-- MONTA temporaria matricula com codins com permissao acesso
			
		insert into TMP_DIG001 (ICARD, END_IP, STATUS, BIO_TIPO)
		SELECT distinct A.icard,  A.end_ip, A.st, A.bio_tipo
			FROM 
				-- seleciona os equipamentos que fazem parte dos grupos do usurio
				(SELECT distinct @c_icard as 'icard',  dat07.end_ip, '0' as 'st', dat07.bio_tipo
					from dat07, dat08 
					where
						dat07.end_ip = @sp_end_ip and
						dat08.grupo in (
							select grupo from CONTROLE where ICARD = @c_icard AND (SITUA <> '1')		-- antes era ((SITUA = '1') or (SITUA = '7'))
							  union
							select grupo1 from CONTROLE where ICARD = @c_icard AND (SITUA <> '1')
							  union	
							select grupo2 from CONTROLE where ICARD = @c_icard AND (SITUA <> '1')
							  union
							select grupo3 from CONTROLE where ICARD = @c_icard AND (SITUA <> '1')
							  union
							select grupo_sab from CONTROLE where ICARD = @c_icard AND (SITUA <> '1')
							  union
							select grupo_dom from CONTROLE where ICARD = @c_icard AND (SITUA <> '1')
							  union
							select grupo_fer from CONTROLE where ICARD = @c_icard AND (SITUA <> '1')) and
						dat07.laces = dat08.laces and
						dat07.planta = dat08.planta and
						(dat07.bio_tipo = '6' or dat07.bio_tipo = '7')  
			UNION
				SELECT distinct @c_icard as 'icard',  dat07.end_ip, '0' as 'st', dat07.bio_tipo
					from dat07, MATCODIN 
					where
						matcodin.icard = @c_icard and
						matcodin.end_ip = @sp_end_ip and 
						matcodin.end_ip = dat07.end_ip and 
						(dat07.bio_tipo = '6' or dat07.bio_tipo = '7') ) as A


		FETCH NEXT FROM cur_stdigital INTO @c_icard, @c_status
	end
	CLOSE cur_stdigital
	deallocate cur_stdigital
	
	-- ******************************************************************
	-- PREPARA TABELA TEMPORARIA DE INCLUSAO COM OS ENDEREOS IP 
	SET @nCont = (SELECT COUNT(*) FROM TMP_DIG001)

	-- verifica se a matricula X codin j esta cadastrada em DIG001 
	if (@nCont != 0) begin
		-- insere icard-codin em tab. DIG001, se no existir em tab.
		DECLARE cur_tmpdigital CURSOR FOR (select ICARD, END_IP, STATUS, BIO_TIPO from TMP_DIG001)
		OPEN cur_tmpdigital
		FETCH NEXT FROM cur_tmpdigital into @xc_icard, @xc_endip, @xc_status, @xc_tipobio

		WHILE @@fetch_status != -1 BEGIN
			UPDATE DIG001 SET STATUS = '1' 
				WHERE  ICARD = @xc_icard AND
					   END_IP = @xc_endip
			if @@rowcount = 0
			begin		
				INSERT INTO DIG001 (ICARD, END_IP, STATUS, BIO_TIPO) 
					values (@xc_icard, @xc_endip, '1', @xc_tipobio);
			end

			FETCH NEXT FROM cur_tmpdigital into @xc_icard, @xc_endip, @xc_status, @xc_tipobio
		end
		
		CLOSE cur_tmpdigital
		DEALLOCATE cur_tmpdigital
	END			

GO
