DROP PROCEDURE sqlver_matplaca
GO

CREATE PROCEDURE sqlver_matplaca @cMatric VARCHAR(12) AS
DECLARE @Ret SMALLINT, @cDataRecAux AS VARCHAR(20), @cDataRec AS VARCHAR(10), @cPlaca AS VARCHAR(15)

	SET DATEFORMAT dmy
    SET @Ret = 1
    SET @cDataRec = '1111111111';	-- ddmmaahhmi
    SET @cPlaca = '000000000000000';

    SELECT @cPlaca = replace(upper(PLACA), ' ',''),
    	   @cDataRecAux = CONVERT(char(8), HORAREC, 3)+ CONVERT(char(8), HORAREC, 8)
	    FROM DAT10 (NOLOCK)
		WHERE ICARD = @cMatric;

	IF @@ROWCOUNT = 0
		SET @Ret = 0

	ELSE
		-- DDMMYYHHMI
		SET @cDataRec = substring (@cDataRecAux,1,2)+substring (@cDataRecAux, 4,2)+substring (@cDataRecAux, 7,2)+
								substring (@cDataRecAux,9,2)+substring (@cDataRecAux,12,2)

	SELECT @cDataRec, @cPlaca, @Ret
	GO


SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS ON 
GO
