if object_id('SQLMAT_GRUPO_tcp', 'p') is null
    exec ('create procedure SQLMAT_GRUPO_tcp as select 1')
go

ALTER PROCEDURE SQLMAT_GRUPO_tcp @cMatric char(12), @cData char(12), @cEndIp char(15)
AS

DECLARE @i int, @achou int, @k int, @ini int, @fim int
DECLARE @hora_ini varchar(4), @hora_fim varchar(4), @cGrupo char(3), @cFaixa char(56)
DECLARE @dDataOcor DATETIME

	
	SET DATEFORMAT DMY
	SET @achou = 0
	SET @dDataOcor = CAST((substring(@cData,1,2)+'-'+
							 substring(@cData,3,2)+'-'+
							 substring(@cData,5,2)+' '+
							 substring(@cData,7,2)+':'+
							 substring(@cData,9,2)+':'+
							 '00') AS datetime);

	-- cursor para matgrupo 
	DECLARE cur_MATGRUPO cursor FOR 
		SELECT a.GRUPO, a.FXPERM 
		FROM  TABGRPSETFX a, MATGRUPO b 
		WHERE a.END_IP = @cEndIp  AND 
			  b.ICARD = @cMatric AND 
			  convert(int, b.GRUPO) = convert(int, a.GRUPO) AND
			  @dDataOcor >= b.DATINI AND
			  @dDataOcor <= b.DATFIM 
			  
	OPEN cur_MATGRUPO
	FETCH NEXT FROM cur_MATGRUPO INTO @cGrupo, @cFaixa
	WHILE (@@fetch_status != -1) and (@achou != 1) 
	begin
		SET @achou = 2
		SET @i = 0
		WHILE (@i < 7)				-- verifica enquanto nao esgotar as 7 faixas horarias ou at encontrar a faixa
		begin
			SET @k = (8 * @i)		-- vai 'andar' de 8 em 8 porque a faixa  hhmmhhmm
			SET @ini = @k + 1;		-- posicao de inicio de faixa
			SET @fim = @k + 5;		-- posicao de fim  de faixa

			SET @hora_ini = substring(@cFaixa, @ini, 4);	-- string de hhmi inicial
			SET @hora_fim = substring(@cFaixa, @fim, 4);	-- string de hhmi final
			
			if @hora_ini = '2400' 
				SET @hora_ini = '2359'
			if @hora_fim = '2400' 
				SET @hora_fim = '2359'
			
			-- verifica se hora/minuto da ocorrencia est dentro da faixa de pesquisa
			IF ((substring(@cData,7,4) >= @hora_ini) and	
				(substring(@cData,7,4) <= @hora_fim) )
			begin				
				SET @i = 7			-- indica parada de busca
				SET @achou = 1		-- indica parada de busca do cursor
			end
			else
				SET @i = @i + 1;	-- vai para proxima faixa horaria
		end
		FETCH NEXT FROM cur_MATGRUPO INTO @cGrupo, @cFaixa
	end
	
	CLOSE cur_MATGRUPO
	DEALLOCATE cur_MATGRUPO


	SELECT @achou
	GO
			

SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS ON 
GO
