if object_id('G3G5_PREP4_SAGEM', 'p') is null
    exec ('create procedure G3G5_PREP4_SAGEM as select 1')
go

ALTER PROCEDURE G3G5_PREP4_SAGEM AS

DECLARE @c_status CHAR(1)
DECLARE @c_icard CHAR(12)

DECLARE @xc_status CHAR(1)
DECLARE @xc_icard CHAR(12)
DECLARE @xc_endip CHAR(15)
DECLARE @xc_tipobio CHAR(1)
DECLARE @ret CHAR(1)

DECLARE @z_endip CHAR(15)
DECLARE @nCont SMALLINT
DECLARE @nAchouGrupo SMALLINT

SET DATEFORMAT YMD


	set @ret = 0

	-- cursor para matriculas cujas digitais foram alteradas
	DECLARE cur_stdigital CURSOR FOR (select ICARD, STATUS from CONTDIG_SAGEM WHERE STATUS = '1' or STATUS = '3' or STATUS = '8')

	OPEN cur_stdigital
	FETCH NEXT FROM cur_stdigital INTO @c_icard, @c_status
	while @@fetch_status != -1
	begin
	
		SET @nAchouGrupo = 0		-- presupoe q nao tem icard x grupo correspondente em tab 
	
		-- *************************************************************************
		-- prepara os ids excluidos (controle.situa = invalido) ou grupos da controle alterados, retirando as digitais de todos os equipamentos 
		IF (@c_status = '3') or (@c_status = '8') BEGIN			-- alterados grupos (3) ou (situa invalidos ou  ver_digit nao confere)  (8)

			-- MONTA temporaria matricula x equipamentos cadastrados
			INSERT INTO TMP_DIG101 (ICARD, END_IP, STATUS, BIO_TIPO) 		
				SELECT distinct @c_icard, DAT07.END_IP, '0', DAT07.BIO_TIPO 
				FROM DAT07 
				WHERE BIO_TIPO = '6' or BIO_TIPO = '7';

	
			-- *****************************************************************
			-- COMO ESTA EXCLUINDO O FUNCIONARIO DA EMPRESA (CONTROLE.SITUA = '1' INVALIDO), TIRA DA LISTA DE INCLUSAO DE TODOS OS equipamentos PALMVEIN
			-- COMO ALTEROU O GRUPO, TIRA DA LISTA DE INCLUSAO DE TODOS OS equipamentos PALMVEIN

			--DELETE FROM DIG001 WHERE ICARD = @c_icard AND (STATUS = '0' OR STATUS = '1')

			-- VAI DELETAR A MATRICULA DE QUALQUER STATUS PORQUE PODE CAIR NA SITUACAO EM QUE HA INCLUSAO DA MATRICULA, MAS NAO VAI PORQUE O EQUIPAMENTO 'ESTA OCUPADO' (nova resposta do microdimarms).
			-- SE HOUVER POSTERIORMENTE EXCLUSAO DESSA MESMA MATRICULA, DEVE=-SE EXCLUIR A INCLUSAO DESSA MATRICULA DA TABELA
			DELETE FROM DIG001 WHERE ICARD = @c_icard
			
		
		END	

		IF (@c_status = '1') or (@c_status = '3') BEGIN		-- incluido/alterado BIOMETRIA (1)   ou   alterados grupos (3) 

			-- ******************************************************************
			-- para todos icards q alteraram digital, distribui nos equipamentos de acordo com o grupo cadastrado em 
			-- CONTROLE, DAT07,DAT08 
			-- MONTA temporaria matricula com codins com permissao acesso
			
			insert into TMP_DIG001 (ICARD, END_IP, STATUS, BIO_TIPO)
			SELECT distinct A.icard,  A.end_ip, A.st, A.bio_tipo
				FROM 
					-- seleciona os equipamentos que fazem parte dos grupos do usurio
					(SELECT distinct @c_icard as 'icard',  dat07.end_ip, '0' as 'st', dat07.bio_tipo
						from dat07, dat08 
						where
							dat07.end_ip <> '000.000.000.000' and
							CONVERT(int,dat08.grupo) in (
								--select CONVERT(int,grupo) from CONTROLE where ICARD = @c_icard AND (SITUA <> '1') AND (VER_DIGIT <> '1') 		-- equipamentos do grupo , situa diferente de invalido, e verifica digital
								select CONVERT(int,grupo) from CONTROLE where ICARD = @c_icard AND (SITUA <> '1') AND (VER_DIGIT = '2') 		-- equipamentos do grupo , situa diferente de invalido, e verifica digital 1:N
								  union
								--select CONVERT(int,grupo1) from CONTROLE where ICARD = @c_icard AND (SITUA <> '1') AND (VER_DIGIT <> '1')
								select CONVERT(int,grupo1) from CONTROLE where ICARD = @c_icard AND (SITUA <> '1') AND (VER_DIGIT = '2')
								  union	
								--select CONVERT(int,grupo2) from CONTROLE where ICARD = @c_icard AND (SITUA <> '1') AND (VER_DIGIT <> '1')
								select CONVERT(int,grupo2) from CONTROLE where ICARD = @c_icard AND (SITUA <> '1') AND (VER_DIGIT = '2')
								  union
								--select CONVERT(int,grupo3) from CONTROLE where ICARD = @c_icard AND (SITUA <> '1') AND (VER_DIGIT <> '1')
								select CONVERT(int,grupo3) from CONTROLE where ICARD = @c_icard AND (SITUA <> '1') AND (VER_DIGIT = '2')
								  union
								--select CONVERT(int,grupo_sab) from CONTROLE where ICARD = @c_icard AND (SITUA <> '1') AND (VER_DIGIT <> '1')
								select CONVERT(int,grupo_sab) from CONTROLE where ICARD = @c_icard AND (SITUA <> '1') AND (VER_DIGIT = '2')
								  union
								--select CONVERT(int,grupo_dom) from CONTROLE where ICARD = @c_icard AND (SITUA <> '1') AND (VER_DIGIT <> '1')
								select CONVERT(int,grupo_dom) from CONTROLE where ICARD = @c_icard AND (SITUA <> '1') AND (VER_DIGIT = '2')
								  union
								--select CONVERT(int,grupo_fer) from CONTROLE where ICARD = @c_icard AND (SITUA <> '1') AND (VER_DIGIT <> '1')
								select CONVERT(int,grupo_fer) from CONTROLE where ICARD = @c_icard AND (SITUA <> '1') AND (VER_DIGIT = '2')
								  union
								--select CONVERT(int,A.grupo) from MATNGRUPOS A, CONTROLE B where A.ICARD = @c_icard  AND B.ICARD = @c_icard AND (B.SITUA <> '1') and (B.VER_DIGIT <> '1')
								select CONVERT(int,A.grupo) from MATNGRUPOS A, CONTROLE B where A.ICARD = @c_icard  AND B.ICARD = @c_icard AND (B.SITUA <> '1') and (B.VER_DIGIT = '2')
								  union
								--select CONVERT(int,A.grupo) from MATGRUPO A, CONTROLE B where A.ICARD = @c_icard  AND B.ICARD = @c_icard AND (B.SITUA <> '1') and (B.VER_DIGIT <> '1')
								select CONVERT(int,A.grupo) from MATGRUPO A, CONTROLE B where A.ICARD = @c_icard  AND B.ICARD = @c_icard AND (B.SITUA <> '1') and (B.VER_DIGIT = '2')
								) and
							CONVERT(int,dat07.laces) = CONVERT(int,dat08.laces) and
							CONVERT(int,dat07.planta) = CONVERT(int,dat08.planta) and
							(dat07.bio_tipo = '6' or dat07.bio_tipo = '7')  
				UNION
					SELECT distinct @c_icard as 'icard',  dat07.end_ip, '0' as 'st', dat07.bio_tipo
						from dat07, MATCODIN 
						where
							matcodin.icard = @c_icard and
							matcodin.end_ip <> '000.000.000.000' and 
							matcodin.end_ip = dat07.end_ip and 
							(dat07.bio_tipo = '6' or dat07.bio_tipo = '7') ) as A

			-- para quem incluiu/alterou digital (status 1) ou mudou de grupo (status 3)
			--IF (@c_status = '3') BEGIN
			IF (@c_status = '1') OR (@c_status = '3') BEGIN
			
				-- ******************************************************************
				-- deve-se excluir da tabela de exclusao temporaria os equipamentos que fazem parte do novo grupo

				DELETE FROM TMP_DIG101
					WHERE EXISTS
						(SELECT TMP_DIG001.icard 
							FROM 
								TMP_DIG001
							WHERE 
								TMP_DIG001.icard = TMP_DIG101.icard and
								TMP_DIG001.END_IP = TMP_DIG101.END_IP and
							  	TMP_DIG001.icard = @c_icard
					);

				-- ******************************************************************
				-- deve-se excluir da tabela de exclusao final os equipamentos do ID em questo, para REFAZER a tabela
				--DELETE from DIG101 where ICARD = @c_icard AND (STATUS = '0' OR STATUS = '1')
				
				-- VAI DELETAR A MATRICULA DE QUALQUER STATUS PORQUE PODE CAIR NA SITUACAO EM QUE HA EXCLUSAO DA MATRICULA, MAS NAO VAI PORQUE O EQUIPAMENTO ESTA OCUPADO.
				-- SE HOUVER POSTERIORMENTE INCLUSAO DESSA MESMA MATRICULA, DEVE=-SE EXCLUIR A EXCLUSAO DESSA MATRICULA DA TABELA
				DELETE from DIG101 where ICARD = @c_icard 
			END

		END


		-- ******************************************************************
		-- PREPARA TABELA TEMPORARIA DE INCLUSAO COM OS ENDEREOS IP 
		SET @nCont = (SELECT COUNT(*) FROM TMP_DIG001)

		-- verifica se a matricula esta cadastrada em controle e se pertence a alguma codin. 
		-- Caso negativo, seu status ainda continua setado at que seja cadastrada e pertena a algum local de acesso
		if (@nCont != 0) begin

			-- insere icard-codin em tab. DIG001, se no existir em tab.
			DECLARE cur_tmpdigital CURSOR FOR (select ICARD, END_IP, STATUS, BIO_TIPO from TMP_DIG001)
			OPEN cur_tmpdigital
			FETCH NEXT FROM cur_tmpdigital into @xc_icard, @xc_endip, @xc_status, @xc_tipobio

			WHILE @@fetch_status != -1 BEGIN
				UPDATE DIG001 SET STATUS = '1' 
					WHERE  ICARD = @xc_icard AND
						   END_IP = @xc_endip
				if @@rowcount = 0
				begin		
					INSERT INTO DIG001 (ICARD, END_IP, STATUS, BIO_TIPO) 
						values (@xc_icard, @xc_endip, '1', @xc_tipobio);
				end

				FETCH NEXT FROM cur_tmpdigital into @xc_icard, @xc_endip, @xc_status, @xc_tipobio
			end
			
			
			SET @nAchouGrupo = 1;
			
			-- coloca o codin na tab. DIG002 (CARGA LISTA) o codin no existir
			insert into DIG002 (END_IP, DATA_LOAD, STATUS, BIO_TIPO)
				select distinct end_ip, getdate(), '0', bio_tipo  
				from
					-- tmp_dig001
					DIG001
				where
					end_ip not in ( select end_ip from DIG002 );
			
			
			CLOSE cur_tmpdigital
			DEALLOCATE cur_tmpdigital
		end

		-- ******************************************************************
		-- PREPARA TABELA TEMPORARIA DE EXCLUSAO COM OS ENDEREOS IP DOS EQUIPAMENTOS
		SET @nCont = (SELECT COUNT(*) FROM TMP_DIG101)
		IF (@nCont != 0) BEGIN

			-- insere na tabela final DIG101  os ID COM STATUS de carga (0 / 1= a excluir)
			DECLARE cur_tmpdigital CURSOR FOR (select ICARD, END_IP, STATUS, BIO_TIPO from TMP_DIG101)
			OPEN cur_tmpdigital
			FETCH NEXT FROM cur_tmpdigital into @xc_icard, @xc_endip, @xc_status, @xc_tipobio

			WHILE @@fetch_status != -1 BEGIN
				UPDATE DIG101 SET STATUS = '1' 
					WHERE  ICARD = @xc_icard AND
						   END_IP = @xc_endip
				if @@rowcount = 0
				begin		
					INSERT INTO DIG101 (ICARD, END_IP, STATUS, BIO_TIPO) 
						values (@xc_icard, @xc_endip, '1', @xc_tipobio);
				end

				FETCH NEXT FROM cur_tmpdigital into @xc_icard, @xc_endip, @xc_status, @xc_tipobio
			end
			
			SET @nAchouGrupo = 1;

			-- coloca o equipamento na tab. DIG102 (CARGA LISTA) o equipamento q no existir
			insert into DIG102 (END_IP, DATA_LOAD, STATUS, BIO_TIPO)
				select distinct END_IP, GETDATE(), '0', BIO_TIPO
				from
					DIG101
				where
					END_IP not in ( select END_IP from DIG102 );
							
			CLOSE cur_tmpdigital
			DEALLOCATE cur_tmpdigital
		END	

		-- atualiza status da matricula, como tratado
		IF (@nAchouGrupo = 1) 	
			update CONTDIG_SAGEM SET STATUS = '0' 
				where ICARD = @c_icard;
			
		DELETE TMP_DIG001
		DELETE TMP_DIG101

		
		FETCH NEXT FROM cur_stdigital INTO @c_icard, @c_status
	end
	CLOSE cur_stdigital
	deallocate cur_stdigital

GO
