PRINT ''
PRINT 'Criando table CONTROLE...'
go

DROP TABLE CONTROLE
GO
CREATE TABLE CONTROLE (
  ICARD        CHAR(12) NOT NULL,
  GRUPO        CHAR(5)  default '00000' 		NOT NULL, 
  CODIG        CHAR(6)  default '      ',
  TPFIS        CHAR(1)  default ' ',       
  SITUA        CHAR(1)  default '1' 		NOT NULL,
  SUBNV        CHAR(7)  default '00     ',    -- 99 niveis
  PLANTA       CHAR(5)  default '00000',
  DATAHORA     CHAR(10) default '3112492359',
  ULTRS        CHAR(25) default '0101102359               ',
  FX_FLG       CHAR(1)  default '0',
  FX_DTA       CHAR(11) default '           ',
  TEMPO_ALM    CHAR(3)  default '   ',
  DATINI       CHAR(6)  default '      ',
  DATFIM       CHAR(6)  default '      ',
  MENSAGEM     CHAR(32) default ' ',
  DTA_MENS     CHAR(6)  default '      ',
  QTD_MENS     CHAR(2)  default '  ',
  CRED_FX1     CHAR(2)  default '00',
  FX_1         CHAR(8)  default '24002400',
  CRED_FX2     CHAR(2)  default '00',
  FX_2         CHAR(8)  default '24002400',
  CRED_FX3     CHAR(2)  default '00',
  FX_3         CHAR(8)  default '24002400',
  CRED_FX4     CHAR(2)  default '00',
  FX_4         CHAR(8)  default '24002400',
  CRED_FX5     CHAR(2)  default '00',
  FX_5         CHAR(8)  default '24002400',
  CRED_FX6     CHAR(2)  default '00',
  FX_6         CHAR(8)  default '24002400',
  ULTPAS_REF   CHAR(10) default '          ',
  TITULAR      CHAR(12) default '            ',
  GRUPO1       CHAR(5)  default '00000',
  DATINIG1     CHAR(10) default '          ',
  DATFIMG1     CHAR(10) default '          ',
  GRUPO2       CHAR(5)  default '00000',
  DATINIG2     CHAR(10) default '          ',
  DATFIMG2     CHAR(10) default '          ',
  GRUPO3       CHAR(5)  default '00000',
  DATINIG3     CHAR(10) default '          ',
  DATFIMG3     CHAR(10) default '          ',
  GRUPO_SAB    CHAR(5)  default '00000',
  GRUPO_DOM    CHAR(5)  default '00000',
  GRUPO_FER    CHAR(5)  default '00000',
  ANTI_DUPLA   CHAR(1)  default '1' 		NOT NULL CONSTRAINT anti_d CHECK (ANTI_DUPLA IN ('0','1')),
  BLOQ_FALTA   CHAR(1)  default '0'		NOT NULL CONSTRAINT bloq_f CHECK (BLOQ_FALTA IN ('0','1')),
  VER_HORA     CHAR(1)  default '1'		NOT NULL CONSTRAINT v_hora CHECK (VER_HORA IN ('0','1', '2', '3')),
  VER_LOCAL    CHAR(1)  default '1'		NOT NULL CONSTRAINT v_local CHECK (VER_LOCAL IN ('0','1')),
  VER_VALID    CHAR(1)  default '1'		NOT NULL CONSTRAINT v_valid CHECK (VER_VALID IN ('0','1')),
  VER_AFAST    CHAR(1)  default '1'		NOT NULL CONSTRAINT v_afast CHECK (VER_AFAST IN ('0','1')),
  VER_CRED     CHAR(1)  default '1'		NOT NULL CONSTRAINT v_cred CHECK (VER_CRED IN ('0','1', '2', '3')),
  VIS_ESP      CHAR(1)  default '0',
  FLG_TEMPO_MIN	   CHAR(1)  default '0',
  ULT_MARC_PONTO   CHAR(10) default '          ',
  TEMPO_MINIMO	   CHAR(3)  default '000',
  TOL_ENTRADA	   CHAR(2)  default '00',
  TOL_SAIDA	   CHAR(2)  default '00',
  NUMSERIAL    CHAR(10) default '0000000000' NOT NULL CONSTRAINT numser CHECK ((datalength(NUMSERIAL) = 10) and (NUMSERIAL not like '%[^0-9]%')),
  VER_DIGIT    CHAR(1)	default '2'		NOT NULL CONSTRAINT v_digit CHECK (VER_DIGIT IN ('1', '2', '3')),
  TEMPO_RET    CHAR(3)  default '000'	NOT NULL CONSTRAINT tempo_ret CHECK (convert(int,TEMPO_RET) >= 0),
  TOLER_RET    CHAR(3)  default '000'	NOT NULL CONSTRAINT toler_ret CHECK (convert(int,TOLER_RET) >=0),
  VER_RET      CHAR(1)  default '0'		NOT NULL CONSTRAINT v_ret CHECK (VER_RET IN ('0','1', '2')),
  TEMPO_JORNADA CHAR(3) default '540' 	NOT NULL CONSTRAINT tpo_jornada CHECK (convert(int,TEMPO_JORNADA) >= 0),
  VER_SAIDAMAX 	CHAR(1)  default '0'		NOT NULL CONSTRAINT v_saidamax CHECK (VER_SAIDAMAX IN ('0','1')),
  ULTRSEG	 	CHAR(2)	DEFAULT '00',
  VER_NDIAS    	CHAR(2)  default '00'	NOT NULL CONSTRAINT v_ndias CHECK (convert(int, VER_NDIAS) < 10),
  PNE		   CHAR(1)	DEFAULT '0' NOT NULL  CONSTRAINT tp_pne CHECK (PNE IN ('0', '1')),
  BLOQREV	   CHAR(1)	DEFAULT '0' NOT NULL  CONSTRAINT tp_lbqrev CHECK (BLOQREV IN ('0', '1')),
  VER_VIAREP	CHAR(1) default '0'		NOT NULL CONSTRAINT v_viarep CHECK (VER_VIAREP IN ('0','1')),
  VER_ESTAT 	CHAR(1)	default '0'		NOT NULL CONSTRAINT v_estat CHECK (VER_ESTAT IN ('0','1', '2', '3'))
)

-- *******************************************************
PRINT ''
PRINT 'Criando table FXHORARIA...'
go

DROP TABLE FXHORARIA
GO
CREATE TABLE FXHORARIA (
ICARD CHAR(12) NOT NULL,
FX_DOM_A CHAR(56) DEFAULT '24002400240024002400240024002400240024002400240024002400' NOT NULL,
FX_SEG_A CHAR(56) DEFAULT '24002400240024002400240024002400240024002400240024002400' NOT NULL,
FX_TER_A CHAR(56) DEFAULT '24002400240024002400240024002400240024002400240024002400' NOT NULL,
FX_QUA_A CHAR(56) DEFAULT '24002400240024002400240024002400240024002400240024002400' NOT NULL,
FX_QUI_A CHAR(56) DEFAULT '24002400240024002400240024002400240024002400240024002400' NOT NULL,
FX_SEX_A CHAR(56) DEFAULT '24002400240024002400240024002400240024002400240024002400' NOT NULL,
FX_SAB_A CHAR(56) DEFAULT '24002400240024002400240024002400240024002400240024002400' NOT NULL,
FX_DOM_P CHAR(56) DEFAULT '24002400240024002400240024002400240024002400240024002400' NOT NULL,
FX_SEG_P CHAR(56) DEFAULT '24002400240024002400240024002400240024002400240024002400' NOT NULL,
FX_TER_P CHAR(56) DEFAULT '24002400240024002400240024002400240024002400240024002400' NOT NULL,
FX_QUA_P CHAR(56) DEFAULT '24002400240024002400240024002400240024002400240024002400' NOT NULL,
FX_QUI_P CHAR(56) DEFAULT '24002400240024002400240024002400240024002400240024002400' NOT NULL,
FX_SEX_P CHAR(56) DEFAULT '24002400240024002400240024002400240024002400240024002400' NOT NULL,
FX_SAB_P CHAR(56) DEFAULT '24002400240024002400240024002400240024002400240024002400' NOT NULL,
FX_REF   CHAR(56) default '24002400240024002400240024002400240024002400240024002400' NOT NULL)

-- *******************************************************
PRINT ''
PRINT 'Criando table FERIADO...'
go

DROP TABLE FERIADO
GO
CREATE TABLE FERIADO (
DATA_FER 	DATETIME 	NOT NULL,
DESC_FER	CHAR(30) null,
PLANTA_FER	CHAR(5) default '00000'
)

-- *******************************************************
PRINT ''
PRINT 'Criando table CP_BN...'
go

DROP TABLE CP_BN
GO

CREATE TABLE CP_BN (
  END_IP       CHAR(15)  DEFAULT '000.000.000.000' NOT NULL,
  BLUEB        CHAR(2)   DEFAULT '00' NOT NULL,
  AVISO	       CHAR(2)	 NOT NULL,
  ST           CHAR(1)   NOT NULL,
  TERM         CHAR(2)   DEFAULT '00' NOT NULL,
  EPN3         CHAR(30)  DEFAULT ' '
)

-- *******************************************************
PRINT ''
PRINT 'Criando table CP_NB...'
go

DROP TABLE CP_NB
GO
CREATE TABLE CP_NB (
  END_IP       VARCHAR(15)	DEFAULT '000.000.000.000' NOT NULL CONSTRAINT tp_endip2 CHECK ((datalength(END_IP) = 15) and (END_IP NOT IN ('               '))),
  BLUEB	       CHAR(2)  DEFAULT '00' NOT NULL CONSTRAINT tp_blueb2 CHECK (convert(int,BLUEB) >= 0),
  CODIN        CHAR(2)  DEFAULT '00' NOT NULL CONSTRAINT tp_codin2 CHECK ((convert(int,CODIN) >= 0) and (convert(int,CODIN) <= 11)),   
  ST	       CHAR(1)	NOT NULL,
  CC 	       CHAR(2)	NOT NULL,
  TIPO_CC      CHAR(1)	NOT NULL CONSTRAINT tp_cc CHECK (TIPO_CC IN ('0','1')),
  ACAO	       CHAR(15) DEFAULT ' '
)

-- *******************************************************
PRINT ''
PRINT 'Criando table DAM00...'
go

DROP TABLE DAM00
GO
CREATE TABLE DAM00 (
  ICARD          CHAR(12)	NOT NULL,
  DIAM           CHAR(2)	NOT NULL,
  MESM           CHAR(2)	NOT NULL,
  ANOM           CHAR(2)	NOT NULL,
  HORAM          CHAR(4)	NOT NULL,
  SEGUNDO        CHAR(2)	NOT NULL,
  CODAC          CHAR(2)	NOT NULL,
  POSIC          CHAR(1)	NOT NULL,
  BLUEB          CHAR(2)	DEFAULT '00' NOT NULL,
  CODTT          CHAR(2)	DEFAULT '00' NOT NULL,
  END_IP	 CHAR(15)	DEFAULT '000.000.000.000' NOT NULL,
  CODFNC         CHAR(2)	DEFAULT '  ' NULL,
  ONOFF		 CHAR(1)	NOT NULL,
  VEICULO	 VARCHAR(15)    NULL,
  TIPODOC 		 CHAR(2) 	DEFAULT '00' ,
  ICARD_NS		 CHAR(10),
  VEICULO_NS	 CHAR(10),
  BIO1N			 CHAR(1)   DEFAULT '0' 
)

-- *******************************************************
PRINT ''
PRINT 'Criando table DAM01...'
go

DROP TABLE DAM01
GO
CREATE TABLE DAM01 (
  ICARD          CHAR(12)	NOT NULL,
  DIAM           CHAR(2)	NOT NULL,
  MESM           CHAR(2)	NOT NULL,
  ANOM           CHAR(2)	NOT NULL,
  HORAM          CHAR(4)	NOT NULL,
  SEGUNDO        CHAR(2)	NOT NULL,
  CODAC          CHAR(2)	NOT NULL,
  POSIC          CHAR(1)	NOT NULL,
  BLUEB          CHAR(2)	DEFAULT '00' NOT NULL,
  CODTT          CHAR(2)	DEFAULT '00' NOT NULL,
  END_IP	 CHAR(15)	DEFAULT '000.000.000.000' NOT NULL,
  CODFNC         CHAR(2)	DEFAULT '  ' NULL,
  VEICULO	 VARCHAR(15)	NULL,
  NIVEL		 CHAR(2)	DEFAULT '  ' NULL,
  FX_REF	 CHAR(2)	DEFAULT '  ' NULL,
  CRED_FX	 CHAR(2)	DEFAULT '  ' NULL,
  SITUA		 CHAR(2)	DEFAULT '  ' NULL,
  QTD_MENS	 CHAR(2)	DEFAULT '  ' NULL,
  TIPODOC 		 CHAR(2) 	DEFAULT '00'  ,
  ICARD_NS		 CHAR(10),
  VEICULO_NS	 CHAR(10)
)

-- *******************************************************
PRINT ''
PRINT 'Criando table DAM02...'
go

DROP TABLE DAM02
GO
CREATE TABLE DAM02 (
  ICARD          CHAR(12)	NOT NULL,
  DIAM           CHAR(2)	NOT NULL,
  MESM           CHAR(2)	NOT NULL,
  ANOM           CHAR(2)	NOT NULL,
  HORAM          CHAR(4)	NOT NULL,
  SEGUNDO        CHAR(2)	NOT NULL,
  CODAC          CHAR(2)	NOT NULL,
  POSIC          CHAR(1)	NOT NULL,
  BLUEB          CHAR(2)	DEFAULT '00' NOT NULL,
  CODTT          CHAR(2)	DEFAULT '00' NOT NULL,
  END_IP	 CHAR(15)	DEFAULT '000.000.000.000' NOT NULL,
  CODFNC         CHAR(2)	DEFAULT '  ' NULL,
  VEICULO	 VARCHAR(15)	NULL,
  TIPODOC 		 CHAR(2) 	DEFAULT '00' ,
  ICARD_NS		 CHAR(10),
  VEICULO_NS	 CHAR(10) 
)

-- *******************************************************
PRINT ''
PRINT 'Criando table DAM03...'
go

DROP TABLE DAM03
GO
CREATE TABLE DAM03 (
  ICARD          CHAR(12)	NOT NULL,
  DIAM           CHAR(2)	NOT NULL,
  MESM           CHAR(2)	NOT NULL,
  ANOM           CHAR(2)	NOT NULL,
  HORAM          CHAR(4)	NOT NULL,
  SEGUNDO        CHAR(2)	NOT NULL,
  CODAC          CHAR(2)	NOT NULL,
  POSIC          CHAR(1)	NOT NULL,
  BLUEB          CHAR(2)	DEFAULT '00' NOT NULL,
  CODTT          CHAR(2)	DEFAULT '00' NOT NULL,
  END_IP	 CHAR(15)	DEFAULT '000.000.000.000' NOT NULL,
  CODFNC         CHAR(2)	DEFAULT '  ' NULL,
  VEICULO	 VARCHAR(15)	NULL,
  TIPODOC 		 CHAR(2) 	DEFAULT '00' ,
  ICARD_NS		 CHAR(10),
  VEICULO_NS	 CHAR(10) 
)

-- *******************************************************
PRINT ''
PRINT 'Criando table DAT07...'
go

DROP TABLE DAT07
GO
CREATE TABLE DAT07 (
  END_IP	 VARCHAR(15) 	DEFAULT '000.000.000.000' NOT NULL CONSTRAINT tp_endip1 CHECK ((datalength(END_IP) = 15) and (END_IP NOT IN ('               '))),
  BLUEB          CHAR(2)	DEFAULT '00' NOT NULL CONSTRAINT tp_blueb1 CHECK (convert(int,BLUEB) >= 0),
  CODIN          CHAR(2)	DEFAULT '00' NOT NULL CONSTRAINT tp_codin1 CHECK ((convert(int,CODIN) >= 0) and (convert(int,CODIN) <= 11)),
  DESC_END	 	 CHAR(30)	DEFAULT ' ' NULL,
  LACES          CHAR(5) 	NOT NULL CONSTRAINT tp_laces1 CHECK (convert(int,LACES) >= 0),       
  TIP_TERM       CHAR(1)	NOT NULL CONSTRAINT tp_term CHECK (TIP_TERM IN ('1','2','3','4', '5')),
  FUSO           CHAR(4)    DEFAULT '0000' NOT NULL,
  PLANTA         CHAR(5)	DEFAULT '00000' NOT NULL,
  BIO_TIPO       CHAR(1)    DEFAULT '0' NOT NULL CONSTRAINT bio_tipo1 CHECK (BIO_TIPO IN ('0','1','2','3','4','5', '6', '7','8', '9','A','C','D')),
  TIP_LEIT 		 CHAR(1) 	DEFAULT '0' NOT NULL ,
  ATUFORC  		 CHAR(1)    DEFAULT '0' ,
  DATFORC  		 DATETIME	NULL,
  RASTREADOR	 CHAR(1)	DEFAULT '0' NOT NULL,
  POS_INIHALM	 CHAR(1) 	DEFAULT '0' NOT NULL CONSTRAINT pos_ihalm CHECK (pos_inihalm IN ('0','1','2','3')),
  POS_FIMHALM	 CHAR(1) 	DEFAULT '0' NOT NULL CONSTRAINT pos_falm CHECK (pos_fimhalm IN ('0','1','2','3','4','5')),
  VALID_RET	 	 CHAR(1) 	DEFAULT '0' NOT NULL CONSTRAINT b_ret CHECK (valid_ret IN ('0','1', '2', '3')),
  VALID_SAIDAMAX CHAR(1) 	DEFAULT '0' NOT NULL CONSTRAINT s_max CHECK (valid_saidamax IN ('0','1')),
  POSVALPLACA	 CHAR(1)	DEFAULT '0'  NOT NULL CONSTRAINT pos_valplaca CHECK (POSVALPLACA in ('0', '1', '2', '3')),
  POSMENSBLOQ	 CHAR(1)	DEFAULT '0'  NOT NULL CONSTRAINT pos_mbloq CHECK (POSMENSBLOQ in ('0', '1', '2', '3')),
  VALID_NDIAS	 CHAR(1) 	DEFAULT '0'  NOT NULL CONSTRAINT val_ndias CHECK (VALID_NDIAS IN ('0','1')),
  BLOQ			 CHAR(1)	DEFAULT '0' NOT NULL  CONSTRAINT tp_blq1 CHECK (BLOQ IN ('0', '1')),
  PARIDREP		 CHAR(1) 	DEFAULT '0'  NOT NULL CONSTRAINT pos_parrep CHECK (PARIDREP in ('0', '1', '2', '3')),
  QTDMULT	CHAR(2) DEFAULT '00'  NOT NULL CONSTRAINT qtdmultddat07 CHECK (convert(int, QTDMULT) >= 0 AND converT(int,QTDMULT) <= 99),
  LMINIMO	NUMERIC(4,0) 	DEFAULT 0 	NOT NULL,
  LMAXIMO	NUMERIC(4,0) 	DEFAULT 0 	NOT NULL,
  QTDATUAL	NUMERIC(4,0) 	DEFAULT 0 	NOT NULL,
  ACOLETIVO     CHAR(17)  DEFAULT '99999999999999999'  NOT NULL,
  CNOCAEPF      CHAR(14)  DEFAULT '00000000000000' CONSTRAINT dat07_01 CHECK(CNOCAEPF not like '%[^0-9]%')
)

-- *******************************************************
PRINT ''
PRINT 'Criando table DAT08...'
go

DROP TABLE DAT08
GO
CREATE TABLE DAT08 (
  GRUPO          CHAR(5) NOT NULL,
  LACES          CHAR(5) NOT NULL CONSTRAINT tp_laces2 CHECK (convert(int,LACES) >= 0),
  FXPERM         CHAR(56) DEFAULT '00002400000024000000240000002400000024000000240000002400' NOT NULL,
  PLANTA	 CHAR(5) DEFAULT '00000' NOT NULL
)

-- *******************************************************
PRINT ''
PRINT 'Criando table DAT09...'
go

DROP TABLE DAT09
GO
CREATE TABLE DAT09 (
  ICARD          CHAR (12) NOT NULL)


-- *******************************************************
-- PRINT ''
-- PRINT 'Criando table TABALARME...'
-- go

-- DROP TABLE TABALARME
-- CREATE TABLE TABALARME (
--   END_IP       CHAR(15)   NOT NULL,
--   ALARME       CHAR(2)   NOT NULL,
--   STATUS       CHAR(1)   NOT NULL,
--   INFORM       CHAR(15)
-- )



-- *******************************************************
PRINT ''
PRINT 'Criando table TABDEV...'
go

DROP TABLE TABDEV
GO
CREATE TABLE TABDEV(
  ICARD          CHAR(12)	NOT NULL,
  DIAM           CHAR(2)	NOT NULL,
  MESM           CHAR(2)	NOT NULL,
  ANOM           CHAR(2)	NOT NULL,
  HORAM          CHAR(4)	NOT NULL,
  SEGUNDO        CHAR(2)	NOT NULL,
  BLUEB          CHAR(2)	DEFAULT '00' NOT NULL,
  CODTT          CHAR(2)	DEFAULT '00' NOT NULL,
  END_IP	 CHAR(15)	DEFAULT '000.000.000.000'  NOT NULL,
  LISTA  	 VARCHAR(15)	NULL,
  STATUS         CHAR(1)	NULL
)

-- *******************************************************
PRINT ''
PRINT 'Criando table TABLOCKS...'
go

DROP TABLE TABLOCKS
GO
CREATE TABLE TABLOCKS (
  ICARD		CHAR(12) NOT NULL,
  DATAHORA      DATETIME  DEFAULT GETDATE() NOT NULL,
  USUARIO       CHAR(15) NOT NULL)

-- *******************************************************
PRINT ''
PRINT 'Criando table CONTDIG...'
go

DROP TABLE CONTDIG
GO
CREATE TABLE CONTDIG (
  ICARD 	CHAR(12) NOT NULL,
  TEMPL_TIT1	CHAR(160) NULL,
  TEMPL_TIT2	CHAR(160) NULL,
  TEMPL_TIT3	CHAR(160) NULL,
  TEMPL_TIT4	CHAR(160) NULL,
  TEMPL_ALT1	CHAR(160) NULL,
  TEMPL_ALT2	CHAR(160) NULL,
  TEMPL_ALT3	CHAR(160) NULL,
  TEMPL_ALT4	CHAR(160) NULL,
  NIVEL		CHAR(1) NULL,
  NUM_DEDO_PAD  CHAR(2) NULL,
  NUM_DEDO_ALT  CHAR(2) NULL
)

-- *******************************************************
PRINT ''
PRINT 'Criando table MAPABIO...'
go

DROP TABLE MAPABIO
GO
CREATE TABLE MAPABIO (
  ICARD	       CHAR(12)  NOT NULL,
  END_IP       CHAR(15)  NOT NULL DEFAULT '000.000.000.000',
  TIPO_TEMPL   CHAR(1)   NOT NULL,
  NIVEL	       CHAR(1)   NOT NULL,
  BLUEB        CHAR(2)   NOT NULL DEFAULT '00',
  CODIN        CHAR(2)   NOT NULL DEFAULT '00'
)

-- *******************************************************
PRINT ''
PRINT 'Criando table SITENTRADA...'
go

DROP TABLE SITENTRADA
GO
CREATE TABLE SITENTRADA  (
  END_IP       CHAR(15)  DEFAULT '000.000.000.000'  NOT NULL,
  BLUEB        CHAR(2)   DEFAULT '00' NOT NULL,
  CODTT        CHAR(2)   DEFAULT '00' NOT NULL,
  DATA_ALARME  DATETIME		NOT NULL,
  ENTRADAS     CHAR(30)		NOT NULL,
  LOCAL_OCORR  CHAR(30)		NOT NULL)

-- *******************************************************
PRINT ''
PRINT 'Criando table CONTFUNC...'
go

DROP TABLE CONTFUNC
GO
CREATE TABLE CONTFUNC  (
  ICARD       CHAR(12)   NOT NULL,
  CODFUNC     CHAR(2)   DEFAULT '00' NOT NULL)

-- ********************** LISTAS DE BENEFICIOS *******************

PRINT ''
PRINT 'Criando table TERMBENEF...'
go

DROP TABLE TERMBENEF
GO
CREATE TABLE TERMBENEF (
  END_IP	VARCHAR(15)	DEFAULT '000.000.000.000'  NOT NULL CONSTRAINT tp_endip3 CHECK ((datalength(END_IP) = 15) and (END_IP NOT IN ('               '))),
  BLUEB		CHAR(2)	DEFAULT '00'  NOT NULL CONSTRAINT tp_blueb4 CHECK (convert(int,BLUEB) >= 0),
  TERM		CHAR(2)		DEFAULT '00'  NOT NULL CONSTRAINT tp_codin3 CHECK ((convert(int,TERM) >= 0) and (convert(int,TERM) <= 11)),  
  LBENEF 	CHAR(15)	NOT NULL CONSTRAINT nome_benef CHECK (LBENEF BETWEEN 'LBENEF00' AND 'LBENEF09' OR LBENEF BETWEEN 'LBENEF10' AND 'LBENEF19' OR LBENEF BETWEEN 'LBENEF20' AND 'LBENEF23'),
  IND_LIS 	CHAR(2)		NOT NULL CONSTRAINT nome_indlis CHECK ((CONVERT(char(2), IND_LIS) >= 0) AND (CONVERT(char(2), IND_LIS) <= 23))
)

-- *******************************************************
PRINT ''
PRINT 'Criando table BENEFICIO...'
go

DROP TABLE BENEFICIO
GO
CREATE TABLE BENEFICIO(
  ICARD       CHAR(12)			NOT NULL,
  CREDITOS    CHAR(2) DEFAULT '00'	NOT NULL
)

-- *******************************************************
PRINT ''
PRINT 'Criando table LBENEF00...'
go

DROP TABLE LBENEF00
GO
CREATE TABLE LBENEF00(
  ICARD       CHAR(12)			NOT NULL,
  CREDITOS    CHAR(2) DEFAULT '00'	NOT NULL
)

-- *******************************************************
PRINT ''
PRINT 'Criando table LBENEF01...'
go

DROP TABLE LBENEF01
GO
CREATE TABLE LBENEF01(
  ICARD       CHAR(12)			NOT NULL,
  CREDITOS    CHAR(2) DEFAULT '00'	NOT NULL
)

-- *******************************************************
PRINT ''
PRINT 'Criando table LBENEF02...'
go

DROP TABLE LBENEF02
GO
CREATE TABLE LBENEF02(
  ICARD       CHAR(12)			NOT NULL,
  CREDITOS    CHAR(2) DEFAULT '00'	NOT NULL
)

-- *******************************************************
PRINT ''
PRINT 'Criando table LBENEF03...'
go

DROP TABLE LBENEF03
GO
CREATE TABLE LBENEF03(
  ICARD       CHAR(12)			NOT NULL,
  CREDITOS    CHAR(2) DEFAULT '00'	NOT NULL
)

-- *******************************************************
PRINT ''
PRINT 'Criando table LBENEF04...'
go

DROP TABLE LBENEF04
GO
CREATE TABLE LBENEF04(
  ICARD       CHAR(12)			NOT NULL,
  CREDITOS    CHAR(2) DEFAULT '00'	NOT NULL
)

-- *******************************************************
PRINT ''
PRINT 'Criando table LBENEF05...'
go

DROP TABLE LBENEF05
GO
CREATE TABLE LBENEF05(
  ICARD       CHAR(12)			NOT NULL,
  CREDITOS    CHAR(2) DEFAULT '00'	NOT NULL
)

-- *******************************************************
PRINT ''
PRINT 'Criando table LBENEF06...'
go

DROP TABLE LBENEF06
GO
CREATE TABLE LBENEF06(
  ICARD       CHAR(12)			NOT NULL,
  CREDITOS    CHAR(2) DEFAULT '00'	NOT NULL
)

-- *******************************************************
PRINT ''
PRINT 'Criando table LBENEF07...'
go

DROP TABLE LBENEF07
GO
CREATE TABLE LBENEF07(
  ICARD       CHAR(12)			NOT NULL,
  CREDITOS    CHAR(2) DEFAULT '00'	NOT NULL
)

-- *******************************************************
PRINT ''
PRINT 'Criando table LBENEF08...'
go

DROP TABLE LBENEF08
GO
CREATE TABLE LBENEF08(
  ICARD       CHAR(12)			NOT NULL,
  CREDITOS    CHAR(2) DEFAULT '00'	NOT NULL
)

-- *******************************************************
PRINT ''
PRINT 'Criando table LBENEF09...'
go

DROP TABLE LBENEF09
GO
CREATE TABLE LBENEF09(
  ICARD       CHAR(12)			NOT NULL,
  CREDITOS    CHAR(2) DEFAULT '00'	NOT NULL
)

-- *******************************************************
PRINT ''
PRINT 'Criando table LBENEF10...'
go

DROP TABLE LBENEF10
GO
CREATE TABLE LBENEF10(
  ICARD       CHAR(12)			NOT NULL,
  CREDITOS    CHAR(2) DEFAULT '00'	NOT NULL
)

-- *******************************************************
PRINT ''
PRINT 'Criando table LBENEF11...'
go

DROP TABLE LBENEF11
GO
CREATE TABLE LBENEF11(
  ICARD       CHAR(12)			NOT NULL,
  CREDITOS    CHAR(2) DEFAULT '00'	NOT NULL
)

-- *******************************************************
PRINT ''
PRINT 'Criando table LBENEF12...'
go

DROP TABLE LBENEF12
GO
CREATE TABLE LBENEF12(
  ICARD       CHAR(12)			NOT NULL,
  CREDITOS    CHAR(2) DEFAULT '00'	NOT NULL
)

-- *******************************************************
PRINT ''
PRINT 'Criando table LBENEF13...'
go

DROP TABLE LBENEF13
GO
CREATE TABLE LBENEF13(
  ICARD       CHAR(12)			NOT NULL,
  CREDITOS    CHAR(2) DEFAULT '00'	NOT NULL
)

-- *******************************************************
PRINT ''
PRINT 'Criando table LBENEF14...'
go

DROP TABLE LBENEF14
GO
CREATE TABLE LBENEF14(
  ICARD       CHAR(12)			NOT NULL,
  CREDITOS    CHAR(2) DEFAULT '00'	NOT NULL
)

-- *******************************************************
PRINT ''
PRINT 'Criando table LBENEF15...'
go

DROP TABLE LBENEF15
GO
CREATE TABLE LBENEF15(
  ICARD       CHAR(12)			NOT NULL,
  CREDITOS    CHAR(2) DEFAULT '00'	NOT NULL
)

-- *******************************************************
PRINT ''
PRINT 'Criando table LBENEF16...'
go

DROP TABLE LBENEF16
GO
CREATE TABLE LBENEF16(
  ICARD       CHAR(12)			NOT NULL,
  CREDITOS    CHAR(2) DEFAULT '00'	NOT NULL
)

-- *******************************************************
PRINT ''
PRINT 'Criando table LBENEF17...'
go

DROP TABLE LBENEF17
GO
CREATE TABLE LBENEF17(
  ICARD       CHAR(12)			NOT NULL,
  CREDITOS    CHAR(2) DEFAULT '00'	NOT NULL
)

-- *******************************************************
PRINT ''
PRINT 'Criando table LBENEF18...'
go

DROP TABLE LBENEF18
GO
CREATE TABLE LBENEF18(
  ICARD       CHAR(12)			NOT NULL,
  CREDITOS    CHAR(2) DEFAULT '00'	NOT NULL
)

-- *******************************************************
PRINT ''
PRINT 'Criando table LBENEF19...'
go

DROP TABLE LBENEF19
GO
CREATE TABLE LBENEF19(
  ICARD       CHAR(12)			NOT NULL,
  CREDITOS    CHAR(2) DEFAULT '00'	NOT NULL
)

-- *******************************************************
PRINT ''
PRINT 'Criando table LBENEF20...'
go

DROP TABLE LBENEF20
GO
CREATE TABLE LBENEF20(
  ICARD       CHAR(12)			NOT NULL,
  CREDITOS    CHAR(2) DEFAULT '00'	NOT NULL
)

-- *******************************************************
PRINT ''
PRINT 'Criando table LBENEF21...'
go

DROP TABLE LBENEF21
GO
CREATE TABLE LBENEF21(
  ICARD       CHAR(12)			NOT NULL,
  CREDITOS    CHAR(2) DEFAULT '00'	NOT NULL
)

-- *******************************************************
PRINT ''
PRINT 'Criando table LBENEF22...'
go

DROP TABLE LBENEF22
GO
CREATE TABLE LBENEF22(
  ICARD       CHAR(12)			NOT NULL,
  CREDITOS    CHAR(2) DEFAULT '00'	NOT NULL
)

-- *******************************************************
PRINT ''
PRINT 'Criando table LBENEF23...'
go

DROP TABLE LBENEF23
GO
CREATE TABLE LBENEF23(
  ICARD       CHAR(12)			NOT NULL,
  CREDITOS    CHAR(2) DEFAULT '00'	NOT NULL
)

-- *******************************************************
PRINT ''
PRINT 'Criando table INFOMAT...'
go

DROP TABLE INFOMAT
GO
CREATE TABLE INFOMAT (
  CAMPO_BLOQ	CHAR(5) NOT NULL CONSTRAINT ck_cpo_bloq CHECK (CAMPO_BLOQ IN ('SAD','TIPO')),
  POS_INIC	CHAR(2) NOT NULL CONSTRAINT ck_pos_bloq CHECK (convert(int,POS_INIC) BETWEEN 1 AND 12),
  TAMANHO	CHAR(1) NOT NULL CONSTRAINT ck_tam_bloq CHECK (convert(int,TAMANHO) BETWEEN 1 AND 9)
)

-- *******************************************************
PRINT ''
PRINT 'Criando table BLOQSAD...'
go

DROP TABLE BLOQSAD
GO
CREATE TABLE BLOQSAD (
  SAD		CHAR(9)	NOT NULL,
  BLOQUEADO	CHAR(1) DEFAULT '0' NOT NULL
)

-- *******************************************************
PRINT ''
PRINT 'Criando table BLOQTIPO...'
go

DROP TABLE BLOQTIPO
GO
CREATE TABLE BLOQTIPO (
  TIPO		CHAR(9)	NOT NULL,
  BLOQUEADO	CHAR(1)	DEFAULT '0' NOT NULL
)

-- *******************************************************
PRINT ''
PRINT 'Criando table EXCESAD...'
go

DROP TABLE EXCESAD
GO
CREATE TABLE EXCESAD (
  ICARD        CHAR(12) NOT NULL
)

-- *******************************************************
PRINT ''
PRINT 'Criando table EXCETIPO...'
go

DROP TABLE EXCETIPO
GO
CREATE TABLE EXCETIPO (
  ICARD        CHAR(12) NOT NULL
)

-- *******************************************************
PRINT ''
PRINT 'Criando table CONTDIG_VERI...'
go

DROP TABLE CONTDIG_VERI
GO
CREATE TABLE CONTDIG_VERI (
  ICARD 	CHAR(12) NOT NULL,
  TEMPL_TIT1	CHAR(160) NULL,
  TEMPL_TIT2	CHAR(160) NULL,
  TEMPL_TIT3	CHAR(160) NULL,
  TEMPL_TIT4	CHAR(160) NULL,
  TEMPL_TIT5	CHAR(56) NULL,
  TEMPL_ALT1	CHAR(160) NULL,
  TEMPL_ALT2	CHAR(160) NULL,
  TEMPL_ALT3	CHAR(160) NULL,
  TEMPL_ALT4	CHAR(160) NULL,
  TEMPL_ALT5    CHAR(56) NULL,
  NIVEL		CHAR(1) NULL,
  NUM_DEDO_PAD  CHAR(2) NULL,
  NUM_DEDO_ALT  CHAR(2) NULL
)

-- *******************************************************
PRINT ''
PRINT 'Criando table CONTDIG_OMOK...'
go

DROP TABLE CONTDIG_OMOK
GO
CREATE TABLE CONTDIG_OMOK (
  ICARD 	CHAR(12) NOT NULL,
  TEMPL_TIT1	CHAR(160) NULL,
  TEMPL_TIT2	CHAR(160) NULL,
  TEMPL_TIT3	CHAR(160) NULL,
  TEMPL_TIT4	CHAR(160) NULL,
  TEMPL_TIT5	CHAR(160) NULL,
  TEMPL_TIT6    CHAR(26) NULL,
  TEMPL_ALT1	CHAR(160) NULL,
  TEMPL_ALT2	CHAR(160) NULL,
  TEMPL_ALT3	CHAR(160) NULL,
  TEMPL_ALT4	CHAR(160) NULL,
  TEMPL_ALT5    CHAR(160) NULL,
  TEMPL_ALT6    CHAR(26) NULL,
  TEMPL_COA1	CHAR(160) NULL,
  TEMPL_COA2	CHAR(160) NULL,
  TEMPL_COA3	CHAR(160) NULL,
  TEMPL_COA4	CHAR(160) NULL,
  TEMPL_COA5    CHAR(160) NULL,
  TEMPL_COA6    CHAR(26) NULL,
  NIVEL		CHAR(1) NULL,
  NUM_DEDO_PAD  CHAR(2) NULL,
  NUM_DEDO_ALT  CHAR(2) NULL,
  NUM_DEDO_COA  CHAR(2) NULL
)

-- *******************************************************
PRINT ''
PRINT 'Criando table CONTDIG_SAGEM...'
go
DROP TABLE CONTDIG_SAGEM;
GO

CREATE TABLE CONTDIG_SAGEM (
  ICARD 		CHAR(12) NOT NULL,
  TEMPL_TIT1	CHAR(160) NULL,
  TEMPL_TIT2	CHAR(160) NULL,
  TEMPL_TIT3	CHAR(160) NULL,
  TEMPL_TIT4	CHAR(32) NULL,
  TEMPL_ALT1	CHAR(160) NULL,
  TEMPL_ALT2	CHAR(160) NULL,
  TEMPL_ALT3	CHAR(160) NULL,
  TEMPL_ALT4	CHAR(32) NULL,
  TEMPL_COA1	CHAR(160) NULL,
  TEMPL_COA2	CHAR(160) NULL,
  TEMPL_COA3	CHAR(160) NULL,
  TEMPL_COA4	CHAR(32) NULL,
  NIVEL			CHAR(1) default '0' NULL,
  NUM_DEDO_PAD  CHAR(3) default '000' NULL,
  NUM_DEDO_ALT  CHAR(3) default '000' NULL,
  NUM_DEDO_COA  CHAR(3) default '000' NULL,
  STATUS 		CHAR(1)	DEFAULT '0' NULL,
  STATUS_REP 	CHAR(1)	DEFAULT '0' NULL
)


-- *******************************************************
PRINT ''
PRINT 'Criando table CONTDIG_TSI1...'
go

DROP TABLE CONTDIG_TSI1
GO
CREATE TABLE CONTDIG_TSI1 (
  ICARD 	CHAR(12) NOT NULL,
  TEMPL_TIT1	CHAR(160) NULL,
  TEMPL_TIT2	CHAR(160) NULL,
  TEMPL_TIT3	CHAR(160) NULL,
  TEMPL_TIT4	CHAR(160) NULL,
  TEMPL_TIT5	CHAR(128) NULL,
  TEMPL_ALT1	CHAR(160) NULL,
  TEMPL_ALT2	CHAR(160) NULL,
  TEMPL_ALT3	CHAR(160) NULL,
  TEMPL_ALT4	CHAR(160) NULL,
  TEMPL_ALT5    CHAR(128) NULL,
  TEMPL_COA1	CHAR(160) NULL,
  TEMPL_COA2	CHAR(160) NULL,
  TEMPL_COA3	CHAR(160) NULL,
  TEMPL_COA4	CHAR(160) NULL,
  TEMPL_COA5    CHAR(128) NULL,
  NIVEL			CHAR(1) NULL,
  NUM_DEDO_PAD  CHAR(3) NULL,
  NUM_DEDO_ALT  CHAR(3) NULL,
  NUM_DEDO_COA  CHAR(3) NULL,
  STATUS 		CHAR(1)	DEFAULT '0' NULL,
  STATUS_REP 	CHAR(1)	DEFAULT '0' NULL
)

-- *******************************************************
PRINT ''
PRINT 'Criando table CONTVEI...'
go

DROP TABLE CONTVEI
GO
CREATE TABLE CONTVEI (
  ICARD         CHAR(12) NOT NULL,
  ICARDV	CHAR(12) NOT NULL,
  DATAHORA	CHAR(10) DEFAULT '3112492359',
  SITUA 	CHAR(1)  DEFAULT '0')

-- 14/11/2003 HENDRIKA

-- *******************************************************
PRINT ''
PRINT 'Criando table ATUALI...'
go

DROP TABLE ATUALI
GO
CREATE TABLE ATUALI (
  IDENTIF	CHAR(14)	NOT NULL,
  NUMSERIAL	CHAR(10)	NOT NULL,
  ICARD		CHAR(12)	DEFAULT '000000000000' NULL,
  NUMCPO	CHAR(2)		NOT NULL,
  INFORM	VARCHAR(56)	NOT NULL)

-- *******************************************************
PRINT ''
PRINT 'Criando table LIMPATU...'
go

DROP TABLE LIMPATU
GO
CREATE TABLE LIMPATU (
  IDENTIF	CHAR(14)	NOT NULL,
  NUMSERIAL	CHAR(10)	NOT NULL,
  DATA_ATU	CHAR(10)	DEFAULT '0101010000' NULL,
  END_IP    CHAR(15)	DEFAULT '000.000.000.000' NOT NULL,
  BLUEB     CHAR(2)		DEFAULT '00' NOT NULL,
  CODTT     CHAR(2)		DEFAULT '00' NOT NULL)

-- *******************************************************
PRINT ''
PRINT 'Criando table PENDSMART...'
go

DROP TABLE PENDSMART
GO
CREATE TABLE PENDSMART (
  END_IP	CHAR(15) DEFAULT '000.000.000.000' NOT NULL,
  BLUEB		CHAR(2)	DEFAULT '00' NOT NULL CONSTRAINT tp_blueb5 CHECK (convert(int,BLUEB) >= 0),
  CODIN 	CHAR(2)	DEFAULT '00' NOT NULL CONSTRAINT tp_codin5 CHECK ((CONVERT(int,CODIN) >= 0) and (CONVERT(INT,CODIN) <= 11)),
  NUMSERIAL	CHAR(10) NOT NULL,
  IDENTIF	CHAR(14) NOT NULL,
  NUMCPO	CHAR(2)	DEFAULT '  ' NULL,
  INFORM	VARCHAR(56) DEFAULT '          ' NULL)

-- *******************************************************
PRINT ''
PRINT 'Criando table EXPIREATU...'
go

DROP TABLE EXPIREATU
GO
CREATE TABLE EXPIREATU (
  IDENTIF	CHAR(14) NOT NULL,
  NUMSERIAL	CHAR(10) NOT NULL,
  DATA_EXP	CHAR(10) DEFAULT '0101010000' NULL,
  END_IP	CHAR(15) DEFAULT '000.000.000.000' NOT NULL,
  BLUEB		CHAR(2)  DEFAULT '00' NOT NULL,
  CODTT     CHAR(2)  DEFAULT '00' NOT NULL)

-- *******************************************************
PRINT ''
PRINT 'Criando table CREDLOG...'
go

DROP TABLE CREDLOG
GO
CREATE TABLE CREDLOG (
  ICARD	CHAR(12) 	NOT NULL,
  ANO	CHAR(4) 	DEFAULT '0000' NOT NULL,
  MES	CHAR(2) 	DEFAULT '00' NOT NULL,
  DIA	CHAR(2) 	DEFAULT '00' NOT NULL,
  HORA	CHAR(4) 	DEFAULT '0000' NOT NULL,
  SEGUNDO CHAR(2) 	DEFAULT '00' NOT NULL,
  TIPO	CHAR(1) 	DEFAULT '0' NOT NULL)

-- *******************************************************
PRINT ''
PRINT 'Criando table VEICULO...'
go

DROP TABLE VEICULO
GO
CREATE TABLE VEICULO (
  ICARDV CHAR(12) NOT NULL,
  NUMSERIAL CHAR(10) default '0000000000' NOT NULL)

-- *******************************************************

PRINT ''
PRINT 'Criando table COUNT_BY_VEIC...'
go

DROP TABLE COUNT_BY_VEIC
GO
CREATE TABLE COUNT_BY_VEIC (
  ICARDV CHAR(12) NOT NULL PRIMARY KEY,
  CNT SMALLINT CONSTRAINT cnt_ate_60 CHECK ( CNT < 61 ) )
--ORGANIZATION INDEX AS 
--SELECT ICARDV, count(*) from CONTVEI GROUP BY ICARDV
GO

--@@TRIGVEIC;

-- *******************************************************
PRINT ''
PRINT 'Criando table SITCOLETOR...'
go

DROP TABLE SITCOLETOR
GO
CREATE TABLE SITCOLETOR (
  ENDIP 	CHAR(15) DEFAULT '000.000.000.000' NOT NULL,
  BLUEB 	CHAR(2)	 DEFAULT '00' NOT NULL,
  CODIN 	CHAR(2)  DEFAULT '00' NOT NULL,
  ID_CONEX 	CHAR(15) DEFAULT '000.000.000.000' NOT NULL,
  DISPOSITIVO 	CHAR(1)  DEFAULT '1' NOT NULL,
  STATUS	CHAR(1)	 DEFAULT '0' NOT NULL,
  LSTPEND	CHAR(5)	 DEFAULT '     ' NULL,
  LSTLOGS	CHAR(5)  DEFAULT '     ' NULL,
  DT_ATUALI	DATETIME NULL)  


-- *******************************************************
PRINT ''
PRINT 'Criando table MATCODIN...'
go

DROP TABLE MATCODIN
GO
CREATE TABLE MATCODIN (
  ICARD 	CHAR(12) NOT NULL,
  END_IP	CHAR(15) DEFAULT '000.000.000.000' NOT NULL,
  BLUEB		CHAR(2)	DEFAULT '00' NOT NULL CONSTRAINT tp_blueb6 CHECK (convert(int,BLUEB) >= 0),
  CODIN 	CHAR(2)	DEFAULT '00' NOT NULL CONSTRAINT tp_codin6 CHECK ((CONVERT(int,CODIN) >= 0) and (CONVERT(INT,CODIN) <= 11)),
  DIASEM	CHAR(1) DEFAULT '0' NOT NULL CONSTRAINT ck_diasem CHECK (convert(int,DIASEM) BETWEEN 0 AND 8),
  FXPERM        CHAR(56) DEFAULT '00002400000024000000240000002400000024000000240000002400' NOT NULL)


-- *******************************************************
PRINT ''
PRINT 'Criando table CONTPLANTA...'
go

DROP TABLE CONTPLANTA
GO
CREATE TABLE CONTPLANTA (
  ICARD 	CHAR(12) NOT NULL,
  PLANTACESSO   CHAR(5) DEFAULT '00000' NOT NULL,
  DATAHORA      CHAR(10) default '3112492359' NOT NULL)


-- *******************************************************
PRINT ''
PRINT 'Criando table GEOMOK001...'
go

DROP TABLE GEOMOK001
GO
CREATE TABLE GEOMOK001 (
  END_IP	CHAR(15) DEFAULT '000.000.000.000' NOT NULL,
  BLUEB		CHAR(2)	DEFAULT '00' NOT NULL CONSTRAINT tp_blueb7 CHECK (convert(int,BLUEB) >= 0),
  CODIN 	CHAR(2)	DEFAULT '00' NOT NULL CONSTRAINT tp_codin7 CHECK ((CONVERT(int,CODIN) >= 0) and (CONVERT(INT,CODIN) <= 11)),
  NIVEL		CHAR(1)	DEFAULT '2' NOT NULL CONSTRAINT niv_geomok CHECK ((CONVERT(int,nivel) BETWEEN 1 AND 9)),
  NIVELSAG 	CHAR(2) DEFAULT '05' CONSTRAINT niv_SAGEN CHECK (convert(int,NIVELSAG) BETWEEN 0 AND 10))

-- *******************************************************
PRINT ''
PRINT 'Criando table PEND_ON001...'
go

DROP TABLE PEND_ON001;
GO
CREATE TABLE PEND_ON001 (
   IDENTIF 		CHAR(14) NOT NULL,
   NUMSERIAL	CHAR(10) NOT NULL,
   ICARD		CHAR(12) DEFAULT '000000000000' NULL,
   TIPO         CHAR(1)  default ' ' NULL,       
   NUMCPO		CHAR(2)	NOT NULL,
   INFORM		VARCHAR(56) NOT NULL,
   END_IP       CHAR(15)  DEFAULT '000.000.000.000' NOT NULL,
   BLUEB        CHAR(2)   DEFAULT '00' NOT NULL,
   CODIN        CHAR(2)   DEFAULT '00' NOT NULL,
   DATA_EXP		DATETIME  NULL,
   STATUS   	CHAR(1)   DEFAULT '0',
   TIPO_ATU		CHAR(1)	  DEFAULT '1')

-- *******************************************************
--PRINT ''
--PRINT 'Criando table PEND_ON002...'
--go

--DROP TABLE PEND_ON002;
--GO
--CREATE TABLE PEND_ON002 (
--   END_IP       CHAR(15)  DEFAULT '000.000.000.000' NOT NULL,
--   BLUEB        CHAR(2)   DEFAULT '00' NOT NULL,
--   CODIN        CHAR(2)   DEFAULT '00' NOT NULL,
--   QTD_LIVRE    SMALLINT  DEFAULT 0,
--   STATUS   	CHAR(1)   DEFAULT '0' NULL,
--   QHOR_EXP		TINYINT	  DEFAULT 12,
--   DATA_INI		DATETIME  NULL,
--   QTD_LIVREOFF SMALLINT   DEFAULT 0,
--   STATUS_OFF   CHAR(1)	  DEFAULT '0' NULL,
--   QHOR_EXPOFF  TINYINT   DEFAULT 0,
--   DATA_INIOFF  DATETIME  NULL,
--   STATUS_LPZ   CHAR(1)	  DEFAULT '0',
--   DATA_INILPZ	DATETIME NULL) 	


-- *******************************************************
PRINT ''
PRINT 'Criando table PEND_ON003...'
go

DROP TABLE PEND_ON003;
GO
CREATE TABLE PEND_ON003 (
   END_IP       CHAR(15)  DEFAULT '000.000.000.000' NOT NULL,
   BLUEB        CHAR(2)   DEFAULT '00' NOT NULL,
   CODIN        CHAR(2)   DEFAULT '00' NOT NULL,
   NUMSERIAL	CHAR(10)	NOT NULL,
   IDENTIF	CHAR(14)	NOT NULL,
   QHOR_EXP	TINYINT	  DEFAULT 12) 	


-- *******************************************************
PRINT ''
PRINT 'Criando table PEND_ON004...'
go

DROP TABLE PEND_ON004;
GO
CREATE TABLE PEND_ON004 (
   END_IP       CHAR(15)  DEFAULT '000.000.000.000' NOT NULL,
   BLUEB        CHAR(2)   DEFAULT '00' NOT NULL,
   CODIN        CHAR(2)   DEFAULT '00' NOT NULL,
   NUMSERIAL	CHAR(10)  NOT NULL,
   IDENTIF	CHAR(14)  NOT NULL,
   NUMCPO	CHAR(2)	  NOT NULL,
   INFORM	CHAR(10)	  NOT NULL) 	


-- *******************************************************
PRINT ''
PRINT 'Criando table PEND_ON005...'
go

DROP TABLE PEND_ON005;
GO
CREATE TABLE PEND_ON005 (
   END_IP       CHAR(15)  DEFAULT '000.000.000.000' NOT NULL,
   BLUEB        CHAR(2)   DEFAULT '00' NOT NULL,
   CODIN        CHAR(2)   DEFAULT '00' NOT NULL,
   NUMSERIAL	CHAR(10)	NOT NULL,
   IDENTIF	CHAR(14)	NOT NULL,
   MODO_ATU	CHAR(1)		NOT NULL) 	


-- *******************************************************
PRINT ''
PRINT 'Criando table PEND_ON006...'
go

DROP TABLE PEND_ON006;
GO
CREATE TABLE PEND_ON006 ( 
  IDENTIF	CHAR(14) NOT NULL, 
  NUMSERIAL	CHAR(10) NOT NULL, 
  END_IP	CHAR(15) DEFAULT '000.000.000.000' NOT NULL, 
  BLUEB		CHAR(2) DEFAULT '00' NOT NULL, 
  CODIN		CHAR(2) DEFAULT '00' NOT NULL, 
  STATUS	CHAR(1) DEFAULT '0' NULL, 
  MODO_ATU	CHAR(1) DEFAULT '1' NULL)  


-- *******************************************************
PRINT ''
PRINT 'Criando table LOGPEND...'
go

DROP TABLE LOGPEND;
GO
CREATE TABLE LOGPEND (
  IDENTIF 	char(14) not null,
  INCLUSAO 	DATETIME default getdate() not null,
  EVENTO 	char(2) not null,
  NUMSERIAL 	char(10) not null,
  ICARD  	char(12) not null,
  NUMCPO 	char(2) not null,
  INFORM 	varchar(56) not null,
  END_IP 	char(15) default '000.000.000.000' not null,
  BLUEB  	char(2) DEFAULT '00' NULL,
  CODIN  	char(2) DEFAULT '00' NULL,
  IDENTIF_REF   char(14) null,
  TIPO_ATU	char(1) default '1' NULL) 


-- *******************************************************
PRINT ''
PRINT 'Criando table PEND_GRUPO...'
go
DROP TABLE PEND_GRUPO;
GO
CREATE TABLE PEND_GRUPO (
  ICARD		CHAR(12) NOT NULL,
  NUMSERIAL	CHAR(10) default '0000000000'	NOT NULL,
  GRUPO		CHAR(3)  default '000' NULL, 
  GRUPO_ANT	CHAR(3)  default '000' NULL, 
  GRUPO1	CHAR(3)  default '000' NULL,
  GRUPO1_ANT	CHAR(3)  default '000' NULL,
  GRUPO2	CHAR(3)  default '000' NULL,
  GRUPO2_ANT	CHAR(3)  default '000' NULL,
  GRUPO3	CHAR(3)  default '000' NULL,
  GRUPO3_ANT	CHAR(3)  default '000' NULL,
  GRUPO_SAB	CHAR(3)  default '000' NULL,
  GRUPO_SAB_ANT	CHAR(3)  default '000' NULL,
  GRUPO_DOM	CHAR(3)  default '000' NULL,
  GRUPO_DOM_ANT	CHAR(3)  default '000' NULL,
  GRUPO_FER	CHAR(3)  default '000' NULL,
  GRUPO_FER_ANT	CHAR(3)  default '000' NULL)


-- *******************************************************
PRINT ''
PRINT 'Criando temporary table TMP_LISTAPENDENCIA...'
go
DROP TABLE TMP_LISTAPENDENCIA;
GO
CREATE TABLE TMP_LISTAPENDENCIA (
	END_IP		char(15)  NOT NULL ,
	NUMSERIAL 	char(10)  NULL ,
	IDENTIF 	char(14)  NULL 
) 


-- *******************************************************
PRINT ''
PRINT 'Criando temporary table TMP_CODINS...'
go
DROP TABLE TMP_CODINS;
GO
CREATE TABLE TMP_CODINS (
	IDENTIF 	char(14) NULL ,
	NUMSERIAL 	char(10) NULL ,
	ICARD 		char(12) NULL ,
	NUMCPO 		char(2) NULL ,
	INFORM 		char(56) NULL ,
	END_IP 		char(15) NULL 
) 


-- *******************************************************
PRINT ''
PRINT 'Criando temporary table TMP_LISTALIMPAOFF...'
go
DROP TABLE TMP_LISTALIMPAOFF;
GO
CREATE TABLE TMP_LISTALIMPAOFF (
	END_IP 		char(15) NOT NULL ,
	NUMSERIAL 	char(10) NULL ,
	IDENTIF 	char(14) NULL ,
	MODO_ATU 	char(1) NULL,
	id_num 		int IDENTITY(1,1)
)


-- *******************************************************
PRINT ''
PRINT 'Criando temporary table TMP_LISTAPENDENCIA_OFF...'
go
DROP TABLE TMP_LISTAPENDENCIA_OFF;
GO
CREATE TABLE TMP_LISTAPENDENCIA_OFF (
	END_IP 		CHAR(15) NULL ,
	NUMSERIAL 	CHAR(10) NULL ,
	IDENTIF 	CHAR(14) NULL ,
	TIPO_ATU 	CHAR(1) NULL ,
	NUMCPO 		CHAR(2) NULL ,
	INFORM 		VARCHAR(10) NULL 
)

-- *******************************************************
PRINT ''
PRINT 'Criando table DATAHORA...'
go
DROP TABLE DATAHORA;
GO

CREATE TABLE DATAHORA (
  ICARD        CHAR(12) NOT NULL,
  INI_HALM     DATETIME default CAST('01-01-2006 00:00:00' AS datetime) NOT NULL,
  FIM_HALM     DATETIME default CAST('01-01-2006 00:00:00' AS datetime) NOT NULL,
  INI_INTJ     DATETIME default CAST('01-01-2006 00:00:00' AS datetime) NOT NULL,
  FIM_INTJ     DATETIME default CAST('01-01-2006 00:00:00' AS datetime) NOT NULL,
  FIM_ANTID	   DATETIME default CAST('01-01-2006 00:00:00' AS datetime) NOT NULL,
  DIAS_SUC	   CHAR(2)  default '00'	NOT NULL  ,
  INI_NR36     DATETIME default CAST('01-01-2020 00:00:00' AS datetime) NOT NULL,
  FIM_NR36     DATETIME default CAST('01-01-2020 00:00:00' AS datetime) NOT NULL
)


-- *******************************************************

PRINT ''
PRINT 'Criando table PEND_ON002ON...'
go

DROP TABLE PEND_ON002ON;
GO
CREATE TABLE PEND_ON002ON (
   END_IP       CHAR(15)  DEFAULT '000.000.000.000' NOT NULL,
   BLUEB        CHAR(2)   DEFAULT '00' NOT NULL,
   CODIN        CHAR(2)   DEFAULT '00' NOT NULL,
   QTD_LIVRE    SMALLINT  DEFAULT 0,
   STATUS   	CHAR(1)   DEFAULT '0' NULL,
   QHOR_EXP		TINYINT	  DEFAULT 12,
   QHOR_EXPOFF  TINYINT   DEFAULT 0,
   DATA_INI		DATETIME  NULL)
  
-- *******************************************************
PRINT ''
PRINT 'Criando table PEND_ON002OFF...'
go

DROP TABLE PEND_ON002OFF;
GO
CREATE TABLE PEND_ON002OFF (
   END_IP       CHAR(15)  DEFAULT '000.000.000.000' NOT NULL,
   BLUEB        CHAR(2)   DEFAULT '00' NOT NULL,
   CODIN        CHAR(2)   DEFAULT '00' NOT NULL,
   QHOR_EXP		TINYINT	  DEFAULT 12,
   QTD_LIVREOFF SMALLINT   DEFAULT 0,
   STATUS_OFF   CHAR(1)	  DEFAULT '0' NULL,
   QHOR_EXPOFF  TINYINT   DEFAULT 0,
   DATA_INIOFF  DATETIME  NULL)

-- *******************************************************
PRINT ''
PRINT 'Criando table PEND_ON002LPZ...'
go

DROP TABLE PEND_ON002LPZ;
GO
CREATE TABLE PEND_ON002LPZ (
   END_IP       CHAR(15)  DEFAULT '000.000.000.000' NOT NULL,
   BLUEB        CHAR(2)   DEFAULT '00' NOT NULL,
   CODIN        CHAR(2)   DEFAULT '00' NOT NULL,
   QHOR_EXP		TINYINT	  DEFAULT 12,
   QHOR_EXPOFF  TINYINT   DEFAULT 0,
   STATUS_LPZ   CHAR(1)	  DEFAULT '0',
   DATA_INILPZ	DATETIME NULL,
   HORA			CHAR(5)	  DEFAULT '99:99') 	



-- *******************************************************
PRINT ''
PRINT 'Criando table PEND_ON007...'
go

DROP TABLE PEND_ON007;
GO
CREATE TABLE PEND_ON007 (
  IDENTIF 	char(14) not null,
  INCLUSAO 	DATETIME default getdate() not null,
  EVENTO 	char(2) not null,
  NUMSERIAL 	char(10) not null,
  ICARD  	char(12) not null,
  NUMCPO 	char(2) not null,
  INFORM 	varchar(56) not null,
  END_IP 	char(15) default '000.000.000.000' not null,
  BLUEB  	char(2) DEFAULT '00' NULL,
  CODIN  	char(2) DEFAULT '00' NULL,
  IDENTIF_REF   char(14) null,
  TIPO_ATU	char(1) default '1' NULL) 


-- *******************************************************

PRINT ''
PRINT 'Criando table PEND_ON008ON...'
go

DROP TABLE PEND_ON008ON;
GO
CREATE TABLE PEND_ON008ON (
   END_IP       CHAR(15)  DEFAULT '000.000.000.000' NOT NULL,
   BLUEB        CHAR(2)   DEFAULT '00' NOT NULL,
   CODIN        CHAR(2)   DEFAULT '00' NOT NULL,
   STATUS   	CHAR(1)   DEFAULT '0' NULL,
   QHOR_EXP		TINYINT	  DEFAULT 12)
  
-- *******************************************************
PRINT ''
PRINT 'Criando table PEND_ON008OFF...'
go

DROP TABLE PEND_ON008OFF;
GO
CREATE TABLE PEND_ON008OFF (
   END_IP       CHAR(15)  DEFAULT '000.000.000.000' NOT NULL,
   BLUEB        CHAR(2)   DEFAULT '00' NOT NULL,
   CODIN        CHAR(2)   DEFAULT '00' NOT NULL,
   STATUS_OFF   CHAR(1)	  DEFAULT '0' NULL,
   QHOR_EXPOFF  TINYINT   DEFAULT 0)

-- *******************************************************
PRINT ''
PRINT 'Criando table PEND_ON008LPZ...'
go

DROP TABLE PEND_ON008LPZ;
GO
CREATE TABLE PEND_ON008LPZ (
   END_IP       CHAR(15)  DEFAULT '000.000.000.000' NOT NULL,
   BLUEB        CHAR(2)   DEFAULT '00' NOT NULL,
   CODIN        CHAR(2)   DEFAULT '00' NOT NULL,
   STATUS_LPZ   CHAR(1)	  DEFAULT '0') 	

-- *******************************************************
PRINT ''
PRINT 'Criando table TMP_DIG001...'
go

DROP TABLE TMP_DIG001
GO
CREATE TABLE TMP_DIG001 (
  ICARD        CHAR(12) NOT NULL,
  END_IP       VARCHAR(15)	DEFAULT '000.000.000.000' NOT NULL CONSTRAINT tp_endip6 CHECK ((datalength(END_IP) = 15) and (END_IP NOT IN ('               '))),
  STATUS	CHAR(1),
  BIO_TIPO	CHAR(1)
)
GO

-- *******************************************************
PRINT ''
PRINT 'Criando table TMP_DIG003...'
go

DROP TABLE TMP_DIG003
GO
CREATE TABLE TMP_DIG003 (
  ICARD        CHAR(12) NOT NULL,
  END_IP       VARCHAR(15)	DEFAULT '000.000.000.000' NOT NULL CONSTRAINT tp_endip7 CHECK ((datalength(END_IP) = 15) and (END_IP NOT IN ('               '))),
  STATUS	CHAR(1),
  BIO_TIPO	CHAR(1)
)
GO


-- *******************************************************
PRINT ''
PRINT 'Criando table DIG001...'
go

DROP TABLE DIG001
GO
CREATE TABLE DIG001 (
  ICARD        CHAR(12) NOT NULL,
  END_IP       VARCHAR(15)	DEFAULT '000.000.000.000' NOT NULL CONSTRAINT tp_endip4 CHECK ((datalength(END_IP) = 15) and (END_IP NOT IN ('               '))),
  STATUS	CHAR(1),
  BIO_TIPO	CHAR(1)
)
GO

-- *******************************************************
PRINT ''
PRINT 'Criando table DIG002...'
go

DROP TABLE DIG002
GO
CREATE TABLE DIG002 (
  END_IP       VARCHAR(15)	DEFAULT '000.000.000.000' NOT NULL CONSTRAINT tp_endip5 CHECK ((datalength(END_IP) = 15) and (END_IP NOT IN ('               '))),
  DATA_LOAD    DATETIME	DEFAULT GETDATE(),
  STATUS	CHAR(1),
  BIO_TIPO 	CHAR(1)
)
GO


-- *******************************************************
PRINT ''
PRINT 'Criando table DIG003...'
go

DROP TABLE DIG003
GO
CREATE TABLE DIG003 (
  ICARD        CHAR(12) NOT NULL,
  END_IP       VARCHAR(15)	DEFAULT '000.000.000.000' NOT NULL CONSTRAINT tp_endip8 CHECK ((datalength(END_IP) = 15) and (END_IP NOT IN ('               '))),
  STATUS	CHAR(1),
  BIO_TIPO	CHAR(1)
)
GO


-- *******************************************************
PRINT ''
PRINT 'Criando table DIG102...'
go

DROP TABLE DIG102
GO
CREATE TABLE DIG102 (
  END_IP       VARCHAR(15)	DEFAULT '000.000.000.000' NOT NULL CONSTRAINT tp_endip10 CHECK ((datalength(END_IP) = 15) and (END_IP NOT IN ('               '))),
  DATA_LOAD    DATETIME	DEFAULT GETDATE(),
  STATUS	CHAR(1),
  BIO_TIPO 	CHAR(1)
)
GO


-- *******************************************************
PRINT ''
PRINT 'Criando table DIG101...'
go

DROP TABLE DIG101
GO
CREATE TABLE DIG101 (
  ICARD        CHAR(12) NOT NULL,
  END_IP       VARCHAR(15)	DEFAULT '000.000.000.000' NOT NULL CONSTRAINT tp_endip11 CHECK ((datalength(END_IP) = 15) and (END_IP NOT IN ('               '))),
  STATUS	CHAR(1),
  BIO_TIPO	CHAR(1)
)
GO


-- *******************************************************
PRINT ''
PRINT 'Criando table DIG103...'
go

DROP TABLE DIG103
GO
CREATE TABLE DIG103 (
  ICARD        CHAR(12) NOT NULL,
  END_IP       VARCHAR(15)	DEFAULT '000.000.000.000' NOT NULL CONSTRAINT tp_endip12 CHECK ((datalength(END_IP) = 15) and (END_IP NOT IN ('               '))),
  STATUS	CHAR(1),
  BIO_TIPO	CHAR(1)
)
GO


-- *******************************************************
PRINT ''
PRINT 'Criando table TMP_DIG101...'
go

DROP TABLE TMP_DIG101
GO
CREATE TABLE TMP_DIG101 (
  ICARD        CHAR(12) NOT NULL,
  END_IP       VARCHAR(15)	DEFAULT '000.000.000.000' NOT NULL CONSTRAINT tp_endip13 CHECK ((datalength(END_IP) = 15) and (END_IP NOT IN ('               '))),
  STATUS	CHAR(1),
  BIO_TIPO	CHAR(1)
)
GO


-- *******************************************************
PRINT ''
PRINT 'Criando table TMP_DIG103...'
go

DROP TABLE TMP_DIG103
GO
CREATE TABLE TMP_DIG103 (
  ICARD        CHAR(12) NOT NULL,
  END_IP       VARCHAR(15)	DEFAULT '000.000.000.000' NOT NULL CONSTRAINT tp_endip14 CHECK ((datalength(END_IP) = 15) and (END_IP NOT IN ('               '))),
  STATUS	CHAR(1),
  BIO_TIPO	CHAR(1)
)
GO


-- ******************  TMP_DIG004

DROP TABLE TMP_DIG004
GO
CREATE TABLE TMP_DIG004 (
  ICARD        CHAR(12) NOT NULL,
  END_IP       VARCHAR(15)	DEFAULT '000.000.000.000' NOT NULL CONSTRAINT ctTmpDig004_01 CHECK ((datalength(END_IP) = 15) and (END_IP NOT IN ('               '))),
  STATUS	CHAR(1),
  BIO_TIPO	CHAR(1)
)
GO


-- ****************** DIG004
DROP TABLE DIG004
GO

CREATE TABLE DIG004 (
  ICARD        CHAR(12) NOT NULL,
  END_IP       VARCHAR(15)	DEFAULT '000.000.000.000' NOT NULL CONSTRAINT ctDIG004_01 CHECK ((datalength(END_IP) = 15) and (END_IP NOT IN ('               '))),
  STATUS	CHAR(1),
  BIO_TIPO	CHAR(1)
)
GO



-- ******************  TMP_DIG104

DROP TABLE TMP_DIG104
GO
CREATE TABLE TMP_DIG104 (
  ICARD        CHAR(12) NOT NULL,
  END_IP       VARCHAR(15)	DEFAULT '000.000.000.000' NOT NULL CONSTRAINT ctTmpDig104_01 CHECK ((datalength(END_IP) = 15) and (END_IP NOT IN ('               '))),
  STATUS	CHAR(1),
  BIO_TIPO	CHAR(1)
)
GO


-- ****************** DIG104
DROP TABLE DIG104
GO

CREATE TABLE DIG104 (
  ICARD        CHAR(12) NOT NULL,
  END_IP       VARCHAR(15)	DEFAULT '000.000.000.000' NOT NULL CONSTRAINT ctDIG104_01 CHECK ((datalength(END_IP) = 15) and (END_IP NOT IN ('               '))),
  STATUS	CHAR(1),
  BIO_TIPO	CHAR(1)
)
GO





-- *******************************************************
PRINT ''
PRINT 'Criando table PWDTELE...'
go

DROP TABLE PWDTELE
GO
CREATE TABLE PWDTELE (
  SEN_USR    VARCHAR(30)   NOT NULL,
  SEN_PWD    VARCHAR(60)   NOT NULL
)
GO


-- *******************************************************
PRINT ''
PRINT 'Criando table DAT05...'
go

DROP TABLE DAT05
GO
CREATE TABLE DAT05 (
  NUMSERIAL	CHAR(10)	NOT NULL
)
GO


-- *******************************************************
-- tabela SISINFO 
PRINT ''
PRINT 'Criando table SISINFO...'
go

DROP TABLE SISINFO;
GO
CREATE TABLE SISINFO (
  NSISTEMA	SMALLINT  NOT  NULL CONSTRAINT tp_nsistema1 CHECK (NSISTEMA > 0),
  NVERSAO	VARCHAR(100),
  BASE		VARCHAR(30),
  DATINS 	DATETIME default getdate() not null,
  SEQ 		INT IDENTITY(1,1),
  LOCAL		VARCHAR(30),
  INFO		VARCHAR(250)
)
GO


-- *******************************************************
-- tabela DSPMENS, que informa qual equipamento / aplicativo tera armazenamento de log de mensagens
PRINT ''
PRINT 'Criando table DSPMENS...'
go

DROP TABLE DSPMENS;
GO
CREATE TABLE DSPMENS (
  END_IP    VARCHAR(15)	DEFAULT '000.000.000.000' NOT NULL CONSTRAINT tp_endip9 CHECK ((datalength(END_IP) = 15) and (END_IP NOT IN ('               '))),
  NSIST	   	CHAR(1) NOT  NULL  CONSTRAINT tp_nsistema2  CHECK (NSIST IN ('1','2')),		-- 1= CONEX, 2= CONEXREP
  ST	    CHAR(1) DEFAULT '0'	NOT NULL
) 
go


-- *******************************************************
-- tabela CONTCPF
PRINT ''
PRINT 'Criando table CONTCPF...'
go

DROP TABLE CONTCPF;
GO

CREATE TABLE CONTCPF (
  ICARD 	CHAR(12) NOT NULL,
  CPF		CHAR(11)  NOT NULL,
  REAL 		CHAR(11), 
  TIPODOC 	CHAR(1) DEFAULT '2' CONSTRAINT tp_cpfpas  CHECK (TIPODOC IN ('2','3'))		-- 2= CPF, 3= PASSAPORTE
)
GO


-- *******************************************************
-- tabela DAM99
PRINT ''
PRINT 'Criando table DAM99...'
go

DROP TABLE DAM99
GO
CREATE TABLE DAM99 (
  ICARD          CHAR(12)	NOT NULL,
  NUMSERIAL		 CHAR(10)	NOT NULL,
  DOCUMENTO		 CHAR(14)	NOT NULL,
  DOC_TIPO		 CHAR(1)	NOT NULL,
  PLACA			 CHAR(10),
  DIAM           CHAR(2)	NOT NULL,
  MESM           CHAR(2)	NOT NULL,
  ANOM           CHAR(2)	NOT NULL,
  HORAM          CHAR(4)	NOT NULL,
  SEGUNDO        CHAR(2)	NOT NULL,
  CODAC          CHAR(2)	NOT NULL,
  POSIC          CHAR(1)	NOT NULL,
  BLUEB          CHAR(2)	DEFAULT '00' NOT NULL,
  CODTT          CHAR(2)	DEFAULT '00' NOT NULL,
  END_IP	 CHAR(15)	DEFAULT '000.000.000.000' NOT NULL,
  CODFNC         CHAR(2)	DEFAULT '  ' NULL,
  ONOFF		 CHAR(1)	NOT NULL,
  VEICULO	 VARCHAR(15)    NULL
)
GO


-- *******************************************************
PRINT ''
PRINT 'Criando table bdcc_cracha...'
go

DROP TABLE bdcc_cracha
GO


SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
CREATE TABLE bdcc_cracha(
      Cracha varchar(12) NOT NULL,
      Bloqueado bit NOT NULL,
PRIMARY KEY CLUSTERED 
(
      [Cracha] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]

GO

SET ANSI_PADDING OFF
GO


-- *******************************************************
-- tabela DAT10
PRINT ''
PRINT 'Criando table DAT10...'
go

DROP TABLE DAT10;
GO

CREATE TABLE DAT10 (
  ICARD 	CHAR(12) 	NOT NULL,
  PLACA 	CHAR(15) 	NOT NULL,
  HORAREC	DATETIME	NOT NULL
)
GO


-- *******************************************************
-- tabela DAT11
PRINT ''
PRINT 'Criando table DAT11...'
go

DROP TABLE DAT11;
GO

CREATE TABLE DAT11 (
  ICARD 	CHAR(12) 	NOT NULL,
  PLACA 	CHAR(15) 	NOT NULL
)
GO


-- *****************   TABELA  DAT12
DROP TABLE DAT12
GO

CREATE TABLE DAT12 (
	XDSC VARCHAR(200)
)
GO




-- *******************************************************
-- tabela MATBMENS
PRINT ''
PRINT 'Criando table MATBMENS...'
go

DROP TABLE MATBMENS;
GO

CREATE TABLE MATBMENS (
  ICARD 	CHAR(12) 	NOT NULL,
  FXMENS		CHAR(8) NOT NULL,
  MENSBLOQ	CHAR(32) NOT NULL
)
GO

-- *********************************** TABELA REPPONTO
-- tabela REPPONTO
PRINT ''
PRINT 'Criando table REPPONTO...'
go

-- OBS : ANTES DA CRIACAO, NAO FARA DROP, POIS ESTA TABELA  CRIADA EM SISTEMA CONEXREP

CREATE TABLE REPPONTO (
  IFUNC		CHAR(12)	NOT NULL CONSTRAINT acrep_ct01 CHECK (IFUNC not like '%[^0-9]%'),
  PIS		CHAR(12)	NOT NULL CONSTRAINT acrep_ct02 CHECK (PIS not like '%[^0-9]%'),
  CPF		CHAR(11)	DEFAULT '00000000000' NOT NULL  CONSTRAINT rep_pto_01 CHECK(CPF not like '%[^0-9]%'),
  DTAHORAREP	DATETIME  NOT NULL
)
GO

-- *********************************** TABELA ULTREPPONTO
PRINT ''
PRINT 'Criando table ULTREPPONTO...'
go

-- OBS : ANTES DA CRIACAO NAO FARA DROP, POIS ESTA TABELA  CRIADA EM SISTEMA CONEXREP

CREATE TABLE ULTREPPONTO (
  IFUNC		CHAR(12)	NOT NULL CONSTRAINT acrep_ct03 CHECK (IFUNC not like '%[^0-9]%'),
  DTAHORAREP	DATETIME  default CAST('01-01-2006 00:00:00' AS datetime) NOT NULL 
)
GO

-- *********************************** TABELA OFFREPPONTO
-- tabela OFFREPPONTO
PRINT ''
PRINT 'Criando table OFFREPPONTO...'
go

-- OBS : ANTES DA CRIACAO, NAO FARA DROP, POIS ESTA TABELA  CRIADA EM SISTEMA CONEXREP

CREATE TABLE OFFREPPONTO (
  IFUNC		CHAR(12)	NOT NULL CONSTRAINT acoffrep_ct01 CHECK (IFUNC not like '%[^0-9]%'),
  PIS		CHAR(12)	NOT NULL CONSTRAINT acoffrep_ct02 CHECK (PIS not like '%[^0-9]%'),
  CPF		CHAR(11)	DEFAULT '00000000000' NOT NULL  CONSTRAINT rep_offpto_01 CHECK(CPF not like '%[^0-9]%'),
  DTAHORAREP	DATETIME  NOT NULL
)
GO



-- *****************   TABELA PALMV001( ICARD  )

DROP TABLE PALMV001
GO
CREATE TABLE PALMV001 (
ICARD 	CHAR(12) NOT NULL,
TEMPL_PAD 	VARBINARY(MAX),
TEMPL_ALT 	VARBINARY(MAX),
ST 			CHAR(1) DEFAULT '0' NOT NULL
)
GO

--DROP TABLE PALMV001
--GO
--CREATE TABLE PALMV001 (
--ICARD 	CHAR(12) NOT NULL,
--TEMPL_PAD 	VARCHAR(MAX),
--TEMPL_ALT 	VARCHAR(MAX),
--ST 			CHAR(1) DEFAULT '0' NOT NULL
--)
--GO


-- *****************   TABELA PALMV003 ( CODIN / CODINSENSO BOX )

--DROP TABLE PALMV003
--GO
--CREATE TABLE PALMV003 (
--	END_IP       	VARCHAR(15)	NOT NULL CONSTRAINT sb_chk2 CHECK ((datalength(END_IP) = 15) and (END_IP NOT IN ('               '))),
--	END_CTRLPALMV	VARCHAR(15)	NOT NULL CONSTRAINT sb_chk3 CHECK ((datalength(END_CTRLPALMV) = 15) and (END_CTRLPALMV NOT IN ('               ')))
--)
--GO


-- *******************************************************************************************************
--PALMVEIN - CADASTRO DE FACES DO USUARIO ID
--PALMV003 - CADASTRO DE CODIN X SENSO BOX

--PALMV014 - ID X IP SENSO BOX (INCLUSAO DE ID)   
	--TMP1_PALMV014 - ID X IP CODIN (AUXILIAR INCLUSAO DE ID)   
	--TMP2_PALMV014 - ID X IP SENSO BOX  (AUXILIAR INCLUSAO DE ID)   
--PALMV004 - ID X IP SENSO BOX (SINALIZACAO COMANDO DE INCLUSAO DE ID)	

--PALMV015 - IP FACE (EXCLUSAO DE ID) 
	--TMP1_PALMV015 - ID X IP CODIN (AUXILIAR EXCLUSAO DE ID)   
	--TMP2_PALMV015 - ID X IP SENSO BOX  (AUXILIAR EXCLUSAO DE ID)   
--PALMV005 - IP FACE (SINALIZACAO COMANDO DE EXCLUSAO DE ID) 
-- *******************************************************************************************************



-- *****************   TABELA PALMV014 ( INCLUSAO  ICARD / IP SENSO BOX )
DROP TABLE PALMV014
GO
CREATE TABLE PALMV014 (
  ICARD        CHAR(12) NOT NULL,
  END_CTRLPALMV VARCHAR(15)	DEFAULT '000.000.000.000' NOT NULL CONSTRAINT sb_chk4 CHECK ((datalength(END_CTRLPALMV) = 15) and (END_CTRLPALMV NOT IN ('               '))),
  STATUS	CHAR(1)
)
GO

-- *****************   TABELA TMP1_PALMV014 ( ICARD / END_IP )
--DROP TABLE TMP1_PALMV014
--GO
--CREATE  TABLE TMP1_PALMV014 ( 
--  ICARD        CHAR(12) NOT NULL,
--  END_IP       VARCHAR(15)	DEFAULT '000.000.000.000' NOT NULL CONSTRAINT sb_chk5 CHECK ((datalength(END_IP) = 15) and (END_IP NOT IN ('               ')))
--) 
--GO

-- *****************   TABELA TMP2_PALMV014 ( INCLUSAO   ICARD / IP SENSO BOX )
DROP TABLE TMP2_PALMV014
GO
CREATE TABLE TMP2_PALMV014 ( 
  ICARD        CHAR(12) NOT NULL,
  END_CTRLPALMV VARCHAR(15)	DEFAULT '000.000.000.000' NOT NULL CONSTRAINT sb_chk6 CHECK ((datalength(END_CTRLPALMV) = 15) and (END_CTRLPALMV NOT IN ('               ')))
) 
GO


-- *****************   TABELA PALMV004 (COMANDO INCLUSAO   ICARD / IP SENSO BOX )
DROP TABLE PALMV004
GO
CREATE TABLE PALMV004 (
  END_CTRLPALMV VARCHAR(15)	DEFAULT '000.000.000.000' NOT NULL CONSTRAINT sb_chk7 CHECK ((datalength(END_CTRLPALMV) = 15) and (END_CTRLPALMV NOT IN ('               '))),
  DATA_LOAD    DATETIME default getdate() not null,
  STATUS	CHAR(1)
)
GO


-- *****************   TABELA PALMV015 ( EXCLUSAO  ICARD / IP SENSO BOX )
DROP TABLE PALMV015
GO

CREATE TABLE PALMV015 (
  ICARD        CHAR(12) NOT NULL,
  END_CTRLPALMV VARCHAR(15)	DEFAULT '000.000.000.000' NOT NULL CONSTRAINT sb_chk8 CHECK ((datalength(END_CTRLPALMV) = 15) and (END_CTRLPALMV NOT IN ('               '))),
  STATUS	CHAR(1)
)
GO


-- *****************   TABELA TMP1_PALMV015 (TEMPORARIA EXCLUSAO  ICARD / END_IP )
--DROP TABLE TMP1_PALMV015
--GO
--CREATE TABLE TMP1_PALMV015 ( 
--  ICARD        CHAR(12) NOT NULL,
--  END_IP       VARCHAR(15)	DEFAULT '000.000.000.000' NOT NULL CONSTRAINT sb_chk9 CHECK ((datalength(END_IP) = 15) and (END_IP NOT IN ('               ')))
--) 
--GO

-- *****************   TABELA TMP2_PALMV015 (TEMPORARIA  EXCLUSAO   ICARD / IP SENSO BOX )
DROP TABLE TMP2_PALMV015
GO

CREATE TABLE TMP2_PALMV015 ( 
  ICARD        CHAR(12) NOT NULL,
  END_CTRLPALMV VARCHAR(15)	DEFAULT '000.000.000.000' NOT NULL CONSTRAINT sb_chk10 CHECK ((datalength(END_CTRLPALMV) = 15) and (END_CTRLPALMV NOT IN ('               ')))
) 
GO


-- *****************   TABELA PALMV005 (COMANDO EXCLUSAO   ICARD / IP SENSO BOX )
DROP TABLE PALMV005
GO

CREATE TABLE PALMV005 (
  END_CTRLPALMV VARCHAR(15)	DEFAULT '000.000.000.000' NOT NULL CONSTRAINT sb_chk11 CHECK ((datalength(END_CTRLPALMV) = 15) and (END_CTRLPALMV NOT IN ('               '))),
  DATA_LOAD    DATETIME default getdate() not null,
  STATUS	CHAR(1)
)
GO


-- *****************   TABELA ICARDNSAUX (NUMSERIAL+ICARD)
DROP TABLE ICARDNSAUX
GO

CREATE TABLE ICARDNSAUX (
  END_IP    VARCHAR(15)	DEFAULT '000.000.000.000' NOT NULL CONSTRAINT tp_endip15 CHECK ((datalength(END_IP) = 15) and (END_IP NOT IN ('               '))),
  ICARDNS	CHAR(22))
go


-- ******************    TABELA MATGRUPO 

DROP TABLE MATGRUPO
GO
CREATE TABLE MATGRUPO (
  ICARD      CHAR(12) NOT NULL,
  GRUPO      CHAR(5)  default '00000',
  DATINI     DATETIME default GETDATE() NOT NULL,
  DATFIM     DATETIME default GETDATE() NOT NULL)
GO  


-- ******************    TABELA COUNT_BY_GRUPO 

DROP TABLE COUNT_BY_GRUPO
GO
CREATE TABLE COUNT_BY_GRUPO (
  ICARD CHAR(12) NOT NULL PRIMARY KEY,
  CNT SMALLINT CONSTRAINT cnt_limgrupo CHECK ( CNT < 100 ) )
GO


-- *******************************************************
-- ESTAC001 - CADASTRO DE EQUIPAMENTOS EM AREA DE CONTROLE DE VAGAS

DROP TABLE ESTAC001
GO
CREATE TABLE ESTAC001 (
  GREST      CHAR(6) NOT NULL  CONSTRAINT tp_estac6 CHECK (CONVERT(INT, GREST) > 0),							-- AREA DE CONTROLE VAGAS
  END_IP	 VARCHAR(15) 	DEFAULT '000.000.000.000' NOT NULL CONSTRAINT tp_estac1 CHECK ((datalength(end_ip) = 15) and (end_ip NOT IN ('               '))))		-- IP DO EQUIPAMENTO DA AREA DE VAGAS
GO


-- *******************************************************
-- ESTAC002 - QUANTIDADE DE VAGAS POR AREA DE CONTROLE DE VAGAS

DROP TABLE ESTAC002;
GO
CREATE TABLE ESTAC002 (
  GREST   		CHAR(6) NOT NULL  CONSTRAINT tp_estac7 CHECK (CONVERT(INT, GREST) > 0),				-- AREA DE CONTROLE VAGAS
  MAX_FIXO		NUMERIC(5,0) DEFAULT 0 NOT NULL CONSTRAINT tp_estac2 CHECK (MAX_FIXO >= 0),			-- MAXIMO DE VAGAS PARA FIXO(ESTACIONAMENTO)  OU qtde vagas VIP em refeitorio
  CONT_FIXO		NUMERIC(5,0) DEFAULT 0 NOT NULL ,			-- CONTADOR DE VAGAS OCUPADAS PARA FIXO   OU nao utilziado em vagas refeitorio
  MAX_ROT		NUMERIC(5,0) DEFAULT 0 NOT NULL CONSTRAINT tp_estac4 CHECK (MAX_ROT >= 0),			-- MAXIMO DE VAGAS PARA ROTATIVO			  OU qtde vagas Comum em refeitorio
  CONT_ROT		NUMERIC(5,0) DEFAULT 0 NOT NULL ,			-- CONTADOR DE VAGAS OCUPADAS PARA ROTATIVO	  OU qtde vagas Ocupadas (VIP + Comum)
  REGRA			CHAR(1)	DEFAULT '0' NOT NULL  CONSTRAINT tp_estac9 CHECK (REGRA >= '0' AND REGRA <= '9'),  	-- regra1 = estacionamento rotativo/privativo; regra 2= vagas refeitorio
  SOFIXO		CHAR(1) DEFAULT '0' NOT NULL),				-- '0' = PERMITE ENTRADA DE usuario FIXO MESMO NAO TENDO VAGAS EM FIXO, PARA PARAR EM ROTATIVO.;   '1' = NAO PERMITE ENTRADA DE usuario FIXO SE NAO HOUVER VAGAS DE FIXO
  DT_AJUSTE 	DATETIME 	DEFAULT GETDATE()		NOT NULL  
GO


-- *******************************************************
-- ESTAC003 - CADASTRO MATRICULAS EM VAGAS FIXAS/PRIVATIVAS

DROP TABLE ESTAC003;
GO
CREATE TABLE ESTAC003 (
  ICARD      CHAR(12)	NOT NULL,			-- MATRICULA QUE POSSUI VAGA FIXA  ou   VIP EM REFEITORIO
  GREST	     CHAR(6) 	NOT NULL     CONSTRAINT tp_estac8 CHECK (CONVERT(INT, GREST) > 0),			-- AREA DE CONTROLE VAGAS
  EMFIXA	 CHAR(1)	DEFAULT '0' NOT NULL)			-- '1' = ENTROU EM ESTACIONAMENTO COM VAGA FIXA LIVRE;  '0' = ENTROU EM ESTACIONAMENTO SEM VAGA FIXA LIVRE
GO



-- *****************************************************************

DROP TABLE ESCOLT001;
GO

CREATE TABLE ESCOLT001 (
  ICARD_ESCOLTADO 	CHAR(12) 	NOT NULL ,			-- ICARD DO ESCOLTADO
  ICARD_GUARDA  	CHAR(12)	NOT NULL, 			-- ICARD DE QUEM FAR A ESCOLTA	
  AREA			NUMERIC(9,0)	NOT NULL		-- AREA ONDE A ESCOLTA SER REALIZADA
)
GO


-- *****************************************************************

DROP TABLE ESCOLT002;
GO

CREATE TABLE ESCOLT002 (
  AREA	NUMERIC(9,0) 	NOT NULL,			-- AREA ONDE A ESCOLTA SER REALIZADA
  END_IP	CHAR(15) 	NOT NULL ,				-- ENDEREO IP DO EQUIPAMENTO PERTENCENTE  REA DE ESCOLTA
  SENTIDO  	CHAR(1)  DEFAULT '0' NOT NULL CONSTRAINT tp_escolt1 CHECK (SENTIDO IN ('0', '1', '2', '3')) 		-- 0=NO PEDE ESCOLTA, 1= ESCOLTA NA ENTRADA, 2 = ESCOLTA NA SAIDA, 3 = ESCOLTA EM E/S
)
GO


-- *****************************************************************

DROP TABLE ACEAUTOBIO
GO

CREATE TABLE ACEAUTOBIO	
(
	END_IP CHAR(15)	NOT NULL ,		-- endereco ip da maquina que esta o conex
	INICIO_GER	TIME default current_timestamp	,			-- horario(hora e minuto) INICIAL(inclusive) que o gerenciador ir escrever em BD
	FINAL_GER 	TIME default current_timestamp				-- horario(hora e minuto) FINAL(inclusive) que o gerenciador ir escrever em BD
)
GO


-- *****************   TABELA DIGLOAD001  ( DIGITAIS NO CARREGADAS DEVIDO A PROBLEMA DE CADASTRO )
DROP TABLE DIGLOAD001
GO

CREATE TABLE DIGLOAD001 (
  END_IP	VARCHAR(15) 	DEFAULT '000.000.000.000' NOT NULL,	
  ICARD		CHAR(12)	NOT NULL,
  BIO_TIPO	CHAR(1) NOT NULL,
  DATA_INS	DATETIME default GETDATE() not null ,
  NERRO		CHAR(2)	default '0'  
) 
GO


-- *****************   TABELA DIGLOAD002  (  DIGITAIS QUE FORAM REJEITADAS PELO EQUIPAMENTO  )
DROP TABLE DIGLOAD002
GO

CREATE TABLE DIGLOAD002 (
  END_IP	VARCHAR(15) 	DEFAULT '000.000.000.000' NOT NULL,	
  ICARD		CHAR(12)	NOT NULL,
  BIO_TIPO	CHAR(1) NOT NULL,
  DATA_INS	DATETIME default GETDATE() not null ,
  NERRO		CHAR(2)	default '0'  
) 
GO



-- *****************   TABELA CONTDIG_BIOMET  (CADASTRO BIOMETRIAS / USUARIO )
--DROP TABLE CONTDIG_BIOMET
--GO

--CREATE TABLE CONTDIG_BIOMET (
--	ICARD 		CHAR(12) 	NOT NULL,
--	BIO_TIPO	CHAR(1) 	NOT NULL CONSTRAINT bio_TPDIG CHECK (bio_tipo IN ('9')),
--	TPDIG 		INT  		NOT NULL,
--	DIGITAL 	VARCHAR(MAX)  NOT NULL,
--	STATUS_REP  CHAR(1)	DEFAULT '0',
--	STATUS 		CHAR(1)		DEFAULT '0'
--)
--GO


-- *****************   TABELA CONTDIG_OUTROS  (CADASTRO BIOMETRIAS / USUARIO )
-- NAO HA DROP TABLE CONTDIG_OUTROS

CREATE TABLE CONTDIG_OUTROS (
	ICARD 			CHAR(12) 	NOT NULL,
	BIO_TIPO		CHAR(1) 	NOT NULL CONSTRAINT digoutros_TPDIG CHECK (BIO_TIPO IN ('9','C','D')),	-- 9=VIRDI, C=tsi1 iso,D=face telpo
	DIGITAL_PAD 	VARCHAR(MAX),
	DIGITAL_ALT 	VARCHAR(MAX),
	DIGITAL_COA 	VARCHAR(MAX),
	DIGITALBIN_PAD  VARBINARY(MAX),
	DIGITALBIN_ALT  VARBINARY(MAX),
	STATUS 			CHAR(1)	DEFAULT '0',
	STATUS_REP   	CHAR(1)	DEFAULT '0'
)
GO


-- *****************   TABELA MATNGRUPOS  (NOVOS GRUPOS DE ACESSO PARA MATRICULA )
DROP TABLE MATNGRUPOS
GO

CREATE TABLE MATNGRUPOS (
	ICARD 		CHAR(12) NOT NULL,
	GRUPO		CHAR(5)  default '00000',
	DIA_TIPO	CHAR(1)	 NOT NULL CONSTRAINT CT1_MATNGRUPOS CHECK (DIA_TIPO IN ('0', '1', '7', '8'))		-- 0(2a a 6a) 1(dom) 7(sab) 8(fer)
)
GO


-- *****************   TABELA VERSOES
-- NAO HA DROP DESTA TABELA, POIS TAMBEM  UTILIZADA EM CONEXREP

CREATE TABLE VERSOES(
	NOME		VARCHAR(20),
    VERSAO 		VARCHAR(20),
    INCLUSAO 	datetime
)
GO

-- *****************   TABELA MATNREFEIT  (NOVAS FAIXAS/CREDITOS DE REFEITORIO PARA MATRICULA )
DROP TABLE MATNREFEIT
GO

CREATE TABLE MATNREFEIT (
	ICARD 		CHAR(12) 	NOT NULL,
	PLANTA   	CHAR(5) 	DEFAULT '00000' NOT NULL,	
	FX_REF      CHAR(8)  	DEFAULT'24002400'  NOT NULL,
	CRED_FXREF  CHAR(2)  	DEFAULT '00'  NOT NULL CONSTRAINT MATNREFEIT_ct1 CHECK (convert(int,CRED_FXREF) >= 0)
)
GO


-- *****************   TABELA AUXMATNREFEIT  (NOVAS FAIXAS/CREDITOS DE REFEITORIO PARA MATRICULA )
DROP TABLE AUXMATNREFEIT
GO

CREATE TABLE AUXMATNREFEIT (
	ICARD 		CHAR(12) 	NOT NULL,
	PLANTA   	CHAR(5) 	DEFAULT '00000' NOT NULL,	
	ULTPAS_REF  CHAR(10) 	default '          '						-- DDMMYYHHMI (DATA/HORA DA ULTIMA PASSAGEM NO REFEITORIO)
)
GO


-- *****************   TABELA HISTDIG  (HISTORICO INCLUSAO E EXCLUSAO DIGITAL X IP )
DROP TABLE HISTDIG
GO

CREATE TABLE HISTDIG (
  IFUNC		CHAR(12) NOT NULL,
  END_IP	VARCHAR(15)	DEFAULT '000.000.000.000' NOT NULL ,
  BIO_TIPO	CHAR(1) NOT NULL,
  INSEXC	CHAR(1) NOT NULL CONSTRAINT histdig_1 CHECK (INSEXC IN ('I','E')),					-- TIPO:'I'= INCLUSAO, 'E'=EXCLUSAO;
  MODO		CHAR(1) NOT NULL CONSTRAINT histdig_2 CHECK (MODO IN ('A','a','M','m','T','t')),			-- MODO:'A'=AUTOMATICO, 'M'=MANUAL, 'T'=TOTAL
  DATA_INS	DATETIME 	default getdate() NOT NULL 
)
GO

-- *****************   TABELA  DAT07REPP (EQUIPAMENTOS QUE SERAO CONSIDERADOS REP_P)
DROP TABLE DAT07REPP 
GO

CREATE TABLE DAT07REPP (
  REP_P		CHAR(15)	NOT NULL,				-- IDENTIFICADOR DO REPP
  END_IP	CHAR(15)	NOT NULL				-- ENDERECO IP DO EQUIPAMENTO QUE FAZ PARTE DO REPP
)
GO

-- *****************   TABELA  DAM00REPP
DROP TABLE DAM00REPP 
GO

CREATE TABLE DAM00REPP (
  ICARD		CHAR(12)	NOT NULL,
  DIAM		CHAR(2)	NOT NULL,
  MESM		CHAR(2)	NOT NULL,
  ANOM		CHAR(2)	NOT NULL,
  HORAM		CHAR(4)	NOT NULL,
  SEGUNDO	CHAR(2)	NOT NULL,
  CODAC		CHAR(2)	NOT NULL,
  POSIC		CHAR(1)	NOT NULL,
  END_IP	CHAR(15)	DEFAULT '000.000.000.000' NOT NULL,
  CODFNC	CHAR(2)	NOT NULL,
  ONOFF		CHAR(1) NOT NULL,
  STATUS	CHAR(1) DEFAULT '1' NOT NULL,  
  ID_NUM	INT 	IDENTITY(1,1),
  DATA_INS	DATETIME	DEFAULT GETDATE()			-- data/hora da inclusao
)		
GO


-- *****************   TABELA  CONT512_AUX (tabela auxiliar qtde max.entradas nao bdcc)
DROP TABLE CONT512_AUX 
GO

CREATE TABLE CONT512_AUX (
  ICARD			CHAR(12) 		NOT NULL,						-- matricula
  CONT_MES		NUMERIC(2,0)	DEFAULT 1 NOT NULL,				-- contador do mes
  DATA_MES		DATETIME 		DEFAULT GETDATE() NOT NULL,		-- data do mes
  CONT_ANO		NUMERIC(2,0)	DEFAULT 1 NOT NULL,				-- contador do ano
  DATA_ANO		DATETIME 		DEFAULT GETDATE() NOT NULL		-- data do ano
)
GO

-- *****************   TABELA  DATNR36FRIG
DROP TABLE DATNR36FRIG 
GO

CREATE TABLE DATNR36FRIG (
   END_IP       CHAR(15)  NOT NULL,
   TEMPO_TRABALHO	NUMERIC(4,0)	  DEFAULT 0	NOT NULL CONSTRAINT datnr36_ct1 CHECK (TEMPO_TRABALHO >= 0),	-- TEMPO DE TRABALHO CONTINUO EM MINUTOS, PARA GARANTIR TEMPO DE REPOUSO
   TEMPO_REPOUSO 	NUMERIC(4,0)	  DEFAULT 1 NOT NULL CONSTRAINT datnr36_ct2 CHECK (TEMPO_REPOUSO >  0)		-- TEMPO DE REPOUSO EM MINUTOS
) 	
GO

-- *****************   TABELA  DIGCOR
DROP TABLE DIGCOR 
GO

CREATE TABLE DIGCOR (
  END_IP  VARCHAR(15)   DEFAULT '000.000.000.000' NOT NULL,  
  ICARD   CHAR(12)  NOT NULL,
  BIO_TIPO  CHAR(1) NOT NULL,
  DATA_COLETA  DATETIME default getdate() NOT NULL 
)
GO

-- ************************  fim  *****************************
