if object_id('sqlcon_vrd_digital', 'p') is null
    exec ('create procedure sqlcon_vrd_digital as select 1')
go

ALTER PROCEDURE sqlcon_vrd_digital @cMatric char(12), 
@cTempl_tit1tot VARCHAR(160) OUTPUT, @cTempl_tit2tot VARCHAR(160) OUTPUT, 
@cTempl_tit3tot VARCHAR(160) OUTPUT, @cTempl_tit4tot VARCHAR(160) OUTPUT, 
@cTempl_Alt1tot VARCHAR(160) OUTPUT, @cTempl_Alt2tot VARCHAR(160) OUTPUT, 
@cTempl_Alt3tot VARCHAR(160) OUTPUT, @cTempl_Alt4tot VARCHAR(160) OUTPUT,
@cNivel CHAR(1) OUTPUT, @cTempl_tit5tot VARCHAR(160) OUTPUT, @cTempl_Alt5tot VARCHAR(160) OUTPUT,
@cTempl_tit6tot VARCHAR(160) OUTPUT, @cTempl_Alt6tot VARCHAR(160) OUTPUT,
@cTempl_tit7tot VARCHAR(160) OUTPUT, @cTempl_Alt7tot VARCHAR(160) OUTPUT,
@nQtdBytes INT, @cBioTipo CHAR(1)


AS
DECLARE @Retfun int, @Pad int, @Alt int, @nTotal int, @i int, @tam int, @pos int, @cVDigit char(1), @cDigital VARCHAR(900)


BEGIN
	SET @Retfun = 3
	SET @Pad = 0
	SET @Alt = 0
	SET @cTempl_tit1tot = ''
	SET @cTempl_tit2tot = ''
	SET @cTempl_tit3tot = ''
	SET @cTempl_tit4tot = ''
	SET @cTempl_tit5tot = ''
	SET @cTempl_tit6tot = ''
	SET @cTempl_tit7tot = ''
	SET @cTempl_Alt1tot = ''
	SET @cTempl_Alt2tot = ''
	SET @cTempl_Alt3tot = ''
	SET @cTempl_Alt4tot = ''
	SET @cTempl_Alt5tot = ''
	SET @cTempl_Alt6tot = ''
	SET @cTempl_Alt7tot = ''
	SET @cNivel = ''


	-- PROCURA PELO PADRAO
	IF EXISTS (SELECT * FROM CONTDIG_BIOMET  WHERE ICARD = @cMatric AND BIO_TIPO = @cBioTipo  AND TPDIG = 0)		-- digital Padrao (0)
	begin
		SELECT @cDigital = DIGITAL FROM CONTDIG_BIOMET  WHERE ICARD = @cMatric AND BIO_TIPO = @cBioTipo  AND TPDIG = 0

		SET @Pad = 1
		SET @nTotal = len (@cDigital)	
		IF (@nTotal = (@nQtdBytes * 2)) 
		begin
			SET @i = 1
			SET @tam = 0
			SET @pos = @tam + 1

			WHILE (@nTotal >= 160) begin
				IF (@i = 1)  SET @cTempl_tit1tot = substring (@cDigital, @pos, 160)
				ELSE IF (@i = 2) SET @cTempl_tit2tot = substring (@cDigital, @pos, 160);
				ELSE IF (@i = 3) SET @cTempl_tit3tot = substring (@cDigital, @pos, 160);
				ELSE IF (@i = 4) SET @cTempl_tit4tot = substring (@cDigital, @pos, 160);
				ELSE IF (@i = 5) SET @cTempl_tit5tot = substring (@cDigital, @pos, 160);
				ELSE IF (@i = 6) SET @cTempl_tit6tot = substring (@cDigital, @pos, 160);
				ELSE IF (@i = 7) SET @cTempl_tit7tot = substring (@cDigital, @pos, 160);
				

				SET @tam = @tam+160;
				SET @i = @i+1;
				SET @nTotal = @nTotal-160;
				SET @pos = 1 + @tam;
			END 

			IF (@nTotal > 0) begin
				IF (@i = 1)  SET @cTempl_tit1tot = substring (@cDigital, @pos, @nTotal);
				ELSE IF (@i = 2) SET @cTempl_tit2tot = substring (@cDigital, @pos, @nTotal);
				ELSE IF (@i = 3) SET @cTempl_tit3tot = substring (@cDigital, @pos, @nTotal);
				ELSE IF (@i = 4) SET @cTempl_tit4tot = substring (@cDigital, @pos, @nTotal);
				ELSE IF (@i = 5) SET @cTempl_tit5tot = substring (@cDigital, @pos, @nTotal);
				ELSE IF (@i = 6) SET @cTempl_tit6tot = substring (@cDigital, @pos, @nTotal);
				ELSE IF (@i = 7) SET @cTempl_tit7tot = substring (@cDigital, @pos, @nTotal);
			END
		end
		else
			SET @Pad = 0
	end
		
	-- PROCURA PELO ALTERNATIVO
	IF EXISTS (SELECT * FROM CONTDIG_BIOMET  WHERE ICARD = @cMatric AND BIO_TIPO = @cBioTipo  AND TPDIG = 1)		-- digital Alternativo (1)
	begin
		SELECT @cDigital = DIGITAL FROM CONTDIG_BIOMET  WHERE ICARD = @cMatric AND BIO_TIPO = @cBioTipo  AND TPDIG = 1

		SET @Alt = 1
		SET @nTotal = len (@cDigital)	
		IF (@nTotal = (@nQtdBytes * 2)) 
		begin
			SET @i = 1
			SET @tam = 0
			SET @pos = @tam + 1

			WHILE (@nTotal >= 160) begin
				IF (@i = 1)  SET @cTempl_Alt1tot = substring (@cDigital, @pos, 160)
				ELSE IF (@i = 2) SET @cTempl_Alt2tot = substring (@cDigital, @pos, 160);
				ELSE IF (@i = 3) SET @cTempl_Alt3tot = substring (@cDigital, @pos, 160);
				ELSE IF (@i = 4) SET @cTempl_Alt4tot = substring (@cDigital, @pos, 160);
				ELSE IF (@i = 5) SET @cTempl_Alt5tot = substring (@cDigital, @pos, 160);
				ELSE IF (@i = 6) SET @cTempl_Alt6tot = substring (@cDigital, @pos, 160);
				ELSE IF (@i = 7) SET @cTempl_Alt7tot = substring (@cDigital, @pos, 160);
				

				SET @tam = @tam+160;
				SET @i = @i+1;
				SET @nTotal = @nTotal-160;
				SET @pos = 1 + @tam;
			END ;

			IF (@nTotal > 0) begin
				IF (@i = 1)  SET @cTempl_Alt1tot = substring (@cDigital, @pos, @nTotal);
				ELSE IF (@i = 2) SET @cTempl_Alt2tot = substring (@cDigital, @pos, @nTotal);
				ELSE IF (@i = 3) SET @cTempl_Alt3tot = substring (@cDigital, @pos, @nTotal);
				ELSE IF (@i = 4) SET @cTempl_Alt4tot = substring (@cDigital, @pos, @nTotal);
				ELSE IF (@i = 5) SET @cTempl_Alt5tot = substring (@cDigital, @pos, @nTotal);
				ELSE IF (@i = 6) SET @cTempl_Alt6tot = substring (@cDigital, @pos, @nTotal);
				ELSE IF (@i = 7) SET @cTempl_Alt7tot = substring (@cDigital, @pos, @nTotal);
			END
		end
		else
			SET @Alt = 0
	end

	-- PREPARA RESULTADO	
	if (@Pad = 1) begin
	    if (@Alt = 1) 
			SET @Retfun = 0;   -- tem padrao e tem alternativo
		else 
			SET @Retfun = 1;   -- tem padrao e nao tem alternativo
	end 
	if (@Pad = 0) begin
	    if (@Alt = 1) 
			SET @Retfun = 2;   -- nao tem padrao e tem alternativo
		else 
			SET @Retfun = 3;   -- nao tem padrao e nao tem alternativo
	end
	
	    
	return (@Retfun)
END
GO


