if object_id('sqlcon_coacao_sagemx2', 'p') is null
    exec ('create procedure sqlcon_coacao_sagemx2 as select 1')
go

ALTER PROCEDURE sqlcon_coacao_sagemx2 @cMatric char(12),
@cTempl_Coa1tot CHAR(160) OUTPUT, @cTempl_Coa2tot CHAR(160) OUTPUT, 
@cTempl_Coa3tot CHAR(160) OUTPUT, @cTempl_Coa4tot CHAR(160) OUTPUT, 
@cTempl_Coa5tot CHAR(160) OUTPUT, @cTempl_Coa6tot CHAR(160) OUTPUT 

AS
DECLARE @RetFun int, @Coa int, @cTempl_Coa4aux AS CHAR(32)
BEGIN
	set @RetFun = 1
	set @Coa = 1
	select @cTempl_Coa1tot = NULL
	select @cTempl_Coa2tot = NULL
	select @cTempl_Coa3tot = NULL
	select @cTempl_Coa4tot = NULL
	select @cTempl_Coa4aux = NULL
	select @cTempl_Coa5tot = NULL
	select @cTempl_Coa6tot = NULL
	
	-- procura por Templates da matricula
	IF EXISTS (SELECT * FROM CONTDIG_SAGEM WITH (Index = CONTDIG_SAGEM_IND1) WHERE ICARD = @cMatric)
	begin
	    SELECT @cTempl_Coa1tot = TEMPL_COA1,
		   @cTempl_Coa2tot = TEMPL_COA2,
		   @cTempl_Coa3tot = TEMPL_COA3,
		   @cTempl_Coa4aux = TEMPL_COA4
		FROM CONTDIG_SAGEM
		WHERE ICARD = @cMatric

	    IF ((@cTempl_Coa1tot is Null) or (@cTempl_Coa2tot is Null) or 
			(@cTempl_Coa3tot is Null) or (@cTempl_Coa4tot is Null) or
			--(datalength(@cTempl_Coa1tot) < 160) or (datalength(@cTempl_Coa2tot) < 160) or
			--(datalength(@cTempl_Coa3tot) < 160) or (datalength(@cTempl_Coa4aux) < 32))
			(len(@cTempl_Coa1tot) < 160) or (len(@cTempl_Coa2tot) < 160) or
			(len(@cTempl_Coa3tot) < 160) or (len(@cTempl_Coa4aux) < 32))
			
			SET @Coa = 0
	    ELSE 
	    begin
			SET @cTempl_Coa4tot = @cTempl_Coa4aux + REPLICATE('0',160-LEN(@cTempl_Coa4aux) )
			SET @cTempl_Coa5tot = REPLICATE('0', 160)
			SET @cTempl_Coa6tot = REPLICATE('0', 26)
	    end
	END

	IF (@Coa = 0) 
	begin
		Set @RetFun = 0
	end
	return (@RetFun)
END
GO

