if object_id('sqlBusca_Tsi1_biomet3', 'p') is null
    exec ('create procedure sqlBusca_Tsi1_biomet3 as select 1')
go

ALTER PROCEDURE sqlBusca_Tsi1_biomet3  @cMatric char(12), @cTipBio char(1), @cEndIp char(15), @cTipoCons char(1),
@cTempl_tit1tot CHAR(160) OUTPUT, @cTempl_tit2tot CHAR(160) OUTPUT, 
@cTempl_tit3tot CHAR(160) OUTPUT, @cTempl_tit4tot CHAR(160) OUTPUT, 
@cTempl_Alt1tot CHAR(160) OUTPUT, @cTempl_Alt2tot CHAR(160) OUTPUT, 
@cTempl_Alt3tot CHAR(160) OUTPUT, @cTempl_Alt4tot CHAR(160) OUTPUT,
@cNivel CHAR(1) OUTPUT,
@cTempl_tit5tot CHAR(160) OUTPUT, @cTempl_Alt5tot CHAR(160) OUTPUT,
@cTempl_tit6tot CHAR(26) OUTPUT, @cTempl_Alt6tot CHAR(26) OUTPUT
AS

DECLARE @cTempl_tit5aux AS CHAR(128), @cTempl_Alt5aux AS CHAR(128), @cVDigit char(1)
DECLARE @RetFun int, @Pad int, @Alt int, @nAchou int

BEGIN
	select @RetFun = 3
	select @cTempl_tit1tot = NULL
	select @cTempl_tit2tot = NULL
	select @cTempl_tit3tot = NULL
	select @cTempl_tit4tot = NULL
	select @cTempl_tit5aux = NULL
	select @cTempl_Alt5tot = NULL
	select @cTempl_Alt6tot = NULL
	select @cTempl_Alt1tot = NULL
	select @cTempl_Alt2tot = NULL
	select @cTempl_Alt3tot = NULL
	select @cTempl_Alt4tot = NULL
	select @cTempl_Alt5aux = NULL
	select @cTempl_Alt5tot = NULL
	select @cTempl_Alt6tot = NULL
	
	set @cNivel = NULL
	set @cVDigit = '2'
	set @nAchou = 0;
	set @Pad = 0;
	set @Alt = 0;
	
	-- PARA VALIDAO ONLINE 
	IF (@cTipoCons = '1') 
	begin
		IF EXISTS (SELECT Ver_Digit FROM CONTROLE WHERE ICARD = @cMatric) 
		begin
			SELECT @cVDigit = Ver_Digit FROM CONTROLE WHERE ICARD = @cMatric
			-- procura por Templates da matricula
			IF EXISTS (SELECT * FROM CONTDIG_TSI1  WHERE ICARD = @cMatric)
			begin
				SELECT @cTempl_tit1tot = TEMPL_TIT1,
				   @cTempl_tit2tot = TEMPL_TIT2,
				   @cTempl_tit3tot = TEMPL_TIT3,
				   @cTempl_tit4tot = TEMPL_TIT4,
		   		   @cTempl_tit5aux = TEMPL_TIT5,
				   @cTempl_Alt1tot = TEMPL_ALT1,
				   @cTempl_Alt2tot = TEMPL_ALT2,
				   @cTempl_Alt3tot = TEMPL_ALT3,
		   		   @cTempl_Alt4tot = TEMPL_ALT4,
		   		   @cTempl_Alt5aux = TEMPL_ALT5,
				   @cNivel = NIVEL
				FROM CONTDIG_TSI1
				WHERE ICARD = @cMatric
					
				set @nAchou = 1;
			end
			ELSE begin
				--IF (CONVERT(INT,@cVDigit) = 2) 
				IF ((CONVERT(INT,@cVDigit) = 2) OR (CONVERT(INT,@cVDigit) = 3) )
					set @RetFun = -2;
				ELSE begin
					set @Pad = 0;
					set @Alt = 0;
				end
			end
		end
		ELSE
			set @RetFun = -2;
	end
	
	-- PARA COMANDO CARGA DIGITAIS 
	ELSE begin
		-- procura por Templates da matricula
		IF EXISTS (SELECT * FROM CONTDIG_TSI1  WHERE ICARD = @cMatric)
		begin
			SELECT @cTempl_tit1tot = TEMPL_TIT1,
				   @cTempl_tit2tot = TEMPL_TIT2,
				   @cTempl_tit3tot = TEMPL_TIT3,
				   @cTempl_tit4tot = TEMPL_TIT4,
		   		   @cTempl_tit5aux = TEMPL_TIT5,
				   @cTempl_Alt1tot = TEMPL_ALT1,
				   @cTempl_Alt2tot = TEMPL_ALT2,
				   @cTempl_Alt3tot = TEMPL_ALT3,
		   		   @cTempl_Alt4tot = TEMPL_ALT4,
		   		   @cTempl_Alt5aux = TEMPL_ALT5
			FROM CONTDIG_TSI1
			WHERE ICARD = @cMatric

			set @nAchou = 1;
		end

		ELSE begin
			set @Pad = 0;
			set @Alt = 0;
		end
	end	
	
	-- verifica o conteudo das digitais
	IF (@nAchou = 1) begin
		select @Pad = 1    -- assume que tem template padrao
		select @Alt = 1    -- assume que tem template alternativo
		if ((@cTempl_tit1tot is Null) or (@cTempl_tit2tot is Null) or 
			(@cTempl_tit3tot is Null) or (@cTempl_tit4tot is Null) or 
			(@cTempl_tit5aux is Null) or
			--(datalength(@cTempl_tit1tot) < 160) or (datalength(@cTempl_tit2tot) < 160) or
			--(datalength(@cTempl_tit3tot) < 160) or (datalength(@cTempl_tit4tot) < 160) or 
			--(datalength(@cTempl_tit5aux) < 128)) 
			(len(@cTempl_tit1tot) < 160) or (len(@cTempl_tit2tot) < 160) or
			(len(@cTempl_tit3tot) < 160) or (len(@cTempl_tit4tot) < 160) or 
			(len(@cTempl_tit5aux) < 128)) 
			
		begin
			SELECT @Pad = 0
		end 
	
		IF (datalength(@cTempl_tit5aux) = 128) BEGIN
			SET @cTempl_tit5tot = @cTempl_tit5aux + REPLICATE('0',160-LEN(@cTempl_tit5aux) )
			SET @cTempl_tit6tot = REPLICATE('0', 26)
		END
	
		if ((@cTempl_Alt1tot is Null) or (@cTempl_Alt2tot is Null) or
			(@cTempl_Alt3tot is Null) or (@cTempl_Alt4tot is Null) or 
			(@cTempl_Alt5aux is Null) or
			--(datalength(@cTempl_Alt1tot) < 160) or (datalength(@cTempl_Alt2tot) < 160) or
			--(datalength(@cTempl_Alt3tot) < 160) or (datalength(@cTempl_Alt4tot) < 160) or 
			--(datalength(@cTempl_Alt5aux) < 128)) 
			(len(@cTempl_Alt1tot) < 160) or (len(@cTempl_Alt2tot) < 160) or
			(len(@cTempl_Alt3tot) < 160) or (len(@cTempl_Alt4tot) < 160) or 
			(len(@cTempl_Alt5aux) < 128)) 
			
		begin 
			SELECT @Alt = 0
		end
	
		--IF (datalength(@cTempl_Alt5aux) = 128) BEGIN
		IF (len(@cTempl_Alt5aux) = 128) BEGIN
			SET @cTempl_Alt5tot = @cTempl_Alt5aux + REPLICATE('0',160-LEN(@cTempl_Alt5aux) )
			SET @cTempl_Alt6tot = REPLICATE('0', 26)
		END
	end
	
	IF (@RetFun != -2) begin
		if (@Pad = 1) 
			if (@Alt = 1) 
				SET @RetFun = 0   -- tem padrao e tem alternativo
			else 
				SET @RetFun = 1   -- tem padrao e nao tem alternativo
		
		if (@Pad = 0) 
			if (@Alt = 1) 
				SET @RetFun = 2   -- nao tem padrao e tem alternativo
			else 
				SET @RetFun = 3   -- nao tem padrao e nao tem alternativo	
	end

	-- VERIFICA SE NAO ACHOU NENHUMA BIOMETRIA E  COMANDO DE ENVIO DE DIGITAIS, DEVERA GUARDAR INFORMACAO EM DIGLOAD001	
	IF ((@RetFun = 3) and (@cTipoCons != '1' )) 
		INSERT into DIGLOAD001 (END_IP, ICARD, BIO_TIPO) 		-- insere em tabela DIGLOAD001
						VALUES (@cEndIp, @cMatric, @cTipBio);
		
	return (@RetFun)

END
GO


