if object_id('sqlAtuVagas_Estac3', 'p') is null
    exec ('create procedure sqlAtuVagas_Estac3 as select 1')
go

ALTER PROCEDURE sqlAtuVagas_Estac3 @cMatric char(12), @cGrEstac char(6), @cTipoVaga char(1), @nModoAlt INT, @cRegra char(1)
AS
DECLARE @Ret int, @nMaxFix int, @nMaxRot int, @nOcupFix int, @nOcupRot int, @nOcupados int, @nMaxVagas int
DECLARE @grAux VARCHAR(8), @cFlag char(1);
DECLARE @cNewTipoVaga CHAR(1);

	SET @Ret = 1;
	
    -- REGRA 1 : ESTACIONAMENTO ROTATIVO / FIXO
	-- USUARIO se cadastrado com vaga fixa: 
	--	 se houver vaga em area fixa, entra e estaciona em vaga fixa. Incrementa contador de vaga fixa. atualiza que entrou em estacionamento via area fixa
	--   se no houver vaga em area fixa e se houver vaga em rotativo, entra e estaciona em vaga rotativa. Incrementa contador de vaga rotativa. atualiza que entrou em estacionamento usando vaga rotativa
	-- USUARIO NAO cadastrado com vaga fixa:
	--	 s pode entrar em estacionamento se houver vaga rotativa disponivel

	IF (@cRegra = '1')	begin
	
		SELECT @grAux = GREST 
			FROM ESTAC003 
			WHERE ICARD = @cMatric and 
				  convert(INT, GREST) = convert(INT, @cGrEstac);
			
		IF (@@ROWCOUNT <> 0) begin 

			-- verifica se tipo de vaga  Fixa e  Entrada		
			IF (@cTipoVaga = 'F') and (@nModoAlt > 0) 
				SET @cFlag = '1';								-- para informar que houve ocupacao da vaga fixa
			ELSE
				SET @cFlag = '0';								-- para informar que no houve ocupao da vaga fixa

			UPDATE ESTAC003 SET EMFIXA = @cFlag 
				WHERE ICARD = @cMatric and 
				  	  convert(INT, GREST) = convert(INT, @cGrEstac);
		END

		SET @cNewTipoVaga = @cTipoVaga;

		-- Procura pelo Grupo de Estacionamento para atualizar quantidade de vagas
		SELECT @nMaxFix = MAX_FIXO, 
			   @nOcupFix = CONT_FIXO, 
			   @nMaxRot =  MAX_ROT, 
			   @nOcupRot = CONT_ROT 
			FROM ESTAC002 WHERE convert(INT, GREST) = convert(INT, @cGrEstac);

		IF (@@ROWCOUNT <> 0) begin 
			IF (@cTipoVaga = 'F') begin
				SET @nOcupados = @nOcupFix;					
				SET @nMaxVagas = @nMaxFix;
			end
			ELSE begin
				SET @nOcupados = @nOcupRot;
				SET @nMaxVagas = @nMaxRot;
			end

			-- nOcupados ser incrementado ou decrementado dependendo do valor de nModoAlt (que pode ser:-1, 0, 1)	
			SET @nOcupados = @nOcupados + @nModoAlt;


			-- verifica vagas ocupadas com valor negativo
			IF (@nOcupados < 0) begin
				IF (@cTipoVaga = 'F') begin		-- vaga fixa nao fica negativa, troca para rotativa  
					SET @nOcupados = @nOcupRot;
					SET @nMaxVagas = @nMaxRot;
					SET @nOcupados = @nOcupados + @nModoAlt;
					SET @cNewTipoVaga = 'R';
				end;
			end
			ELSE begin
				IF (@nOcupados > @nMaxVagas) begin
					if (@cTipoVaga = 'F') begin	-- vaga fixa nao fica negativa, troca para rotativa
						SET @nOcupados = @nOcupRot;
						SET @nMaxVagas = @nMaxRot;
						SET @nOcupados = @nOcupados + @nModoAlt;
						SET @cNewTipoVaga = 'R';
					end
				end
			end 
			
			
			-- atualiza contador
			IF (@nModoAlt != 0) begin
				IF (@cNewTipoVaga = 'F') 
					UPDATE ESTAC002 SET CONT_FIXO = @nOcupados WHERE convert(INT, GREST) = convert(INT, @cGrEstac);
				ELSE
					UPDATE ESTAC002 SET CONT_ROT = @nOcupados WHERE convert(INT, GREST) = convert(INT, @cGrEstac);
			end
		end
		ELSE
			SET @Ret = 0;
	end
	
    -- REGRA 2 : VAGAS REFEITORIO COMUM/VIP
	-- USUARIO se cadastrado com vaga Vip: 
	--	 se houver vaga em area Comum, entra . Incrementa contador de vagas Ocupadas. 
	--	 se nao houver vaga em area Comum mas tem vaga em rea Vip, entra . Incrementa contador de vagas Ocupadas. 
	--	 se nao houver vaga em area Comum e no tem vaga em rea Vip,  bloqueado. 
	-- USUARIO NO cadastrado com vaga Vip: 
	--	 se houver vaga em area Comum, entra . Incrementa contador de vagas Ocupadas. 
	--	 se nao houver vaga em area Comum mas tem vaga em rea Vip,  bloqueado. 
	--	 se nao houver vaga em area Comum e no tem vaga em rea Vip,  bloqueado. 
	
	ELSE begin 
		IF (@cRegra = '2')	begin
			SET @nOcupados = 0;
			IF (@nModoAlt != 0) begin
				-- Procura pelo Grupo de Estacionamento para atualizar quantidade de vagas
				SELECT @nMaxFix = MAX_FIXO, 
					   @nMaxRot = MAX_ROT, 
					   @nOcupados = CONT_ROT 
				FROM ESTAC002 
				WHERE convert(INT, GREST) = convert(INT, @cGrEstac);

				IF (@@ROWCOUNT <> 0) begin 
				
					-- nOcupados ser incrementado ou decrementado dependendo do valor de nModoAlt (que pode ser:-1, 0, 1)	
					SET @nOcupados = @nOcupados + @nModoAlt;

					-- nao deixa qtde vagas ocupadas ficar negativo
					if (@nOcupados < 0) 
						SET @nOcupados = 0;

					-- nao deixa qtde vagas ocupadas ficar maior que o permitido
					-- TIREI. ACHO Q DEVE SER COLOCADO A QTDE Q TEM NA AREA, MESMO QUE TENHA ULTRAPASSADO DO MXIMO PERMITIDO
	--				IF (@nOcupados > (@nMaxFix + @nMaxRot)) 
	--					SET @nOcupados = (@nMaxFix + @nMaxRot);

					UPDATE ESTAC002 SET CONT_ROT = @nOcupados 
						WHERE convert(INT, GREST) = convert(INT, @cGrEstac)
				end
				ELSE
					SET @Ret = 0;			
			END
		END;
	END 

	select @Ret ;
	
	GO

SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS ON 
GO

