if object_id('sqlat_tab_refplanta', 'p') is null
    exec ('create procedure sqlat_tab_refplanta as select 1')
go

ALTER PROCEDURE sqlat_tab_refplanta @cRegistro1 char(50) 
AS

DECLARE @cMatric char(12), @cPlanta char(5), @cFaixa char(8), @cCred char(2), @cDatHorRef char(10), @cAux char(12)
DECLARE @Retorno int


BEGIN

	SET @cMatric  = substring(@cRegistro1,  1, 12)
	SET @cPlanta  = substring(@cRegistro1, 13,  5)
	SET @cFaixa   = substring(@cRegistro1, 18,  8)
	SET @cCred    = substring(@cRegistro1, 26,  2)
	SET @cDatHorRef = substring(@cRegistro1, 28,  10)
	SET @Retorno = 0

	
	SET LOCK_TIMEOUT 1000	
	
	-- atualiza tabela MATNREFEIT, na faixa especifica
	UPDATE MATNREFEIT set CRED_FXREF = @cCred
		WHERE ICARD =  @cMatric and 
			  CONVERT(INT,PLANTA) = CONVERT(INT,@cPlanta) and
			  FX_REF = @cFaixa


	-- insere ou atualiza tabela AUXMATNREFEIT, a data/faixa da ltima passagem no refeitorio de acordo com a planta
	IF EXISTS (select * from AUXMATNREFEIT WHERE ICARD =  @cMatric and PLANTA = @cPlanta )
		UPDATE AUXMATNREFEIT set ULTPAS_REF = @cDatHorRef 
			WHERE ICARD =  @cMatric and 
				  CONVERT(INT,PLANTA) = CONVERT(INT,@cPlanta) 
	ELSE
		INSERT INTO AUXMATNREFEIT (ICARD, PLANTA, ULTPAS_REF) 
						   VALUES (@cMatric, @cPlanta, @cDatHorRef);


	SET LOCK_TIMEOUT -1		

	return @Retorno
END
GO
