if object_id('sqlatu_vrdclob_cnx', 'p') is null
    exec ('create procedure sqlatu_vrdclob_cnx as select 1')
go

ALTER PROCEDURE sqlatu_vrdclob_cnx @matric char(12), @TipoChave char(1), @templ1 char(160), @templ2 char(160), 
@templ3 char(160), @templ4 char(160), @nTipo char(1), @cNumDedo char(2), @cNivel char(1), @templ5 char(160), @templ6 char(48), @cBioTipo char(1)
AS
DECLARE @cAuxMat char(15), @nRetorno int

BEGIN

    SET @nRetorno = 1
    SET @cAuxMat = @matric
    
	IF (@TipoChave = '1')	-- pesquisa por Numero Serial, para coletar valor de Icard
		begin
			IF EXISTS (SELECT icard FROM CONTROLE  WHERE NUMSERIAL = substring(@matric, 3, 10))
			begin
				SELECT @cAuxMat = ICARD 
					FROM CONTROLE
					WHERE NUMSERIAL = substring(@matric, 3, 10)
			END

		end
	ELSE IF (@TipoChave = '2')	-- pesquisa por CPF, para coletar valor de Icard
		begin
			IF EXISTS (SELECT icard FROM ContCPF  WHERE CPF = substring(@matric, 2, 11))
			begin
				SELECT @cAuxMat = ICARD 
					FROM ContCPF
					WHERE CPF = substring(@matric, 2, 11)
			END
		end
	
	
    IF NOT EXISTS 
    	(SELECT ICARD FROM CONTDIG_BIOMET WITH (Index = CONTDIG_BIOMET_IND1) 
    		WHERE ICARD = @cAuxMat and
    			  BIO_TIPO = @cBioTipo AND			-- identificador  do biometrico 
				  TPDIG = @nTipo) begin						-- identificador do dedo (0 = padro, 1=alternativo, 2 = coacao)
		INSERT INTO CONTDIG_BIOMET (ICARD, BIO_TIPO, TPDIG, STATUS, STATUS_REP, DIGITAL)  
			VALUES (@cAuxMat, @cBioTipo, @nTipo, '1', '1', @templ1+@templ2+@templ3+@templ4+@templ5+substring(@templ6,1,48))
			
		IF (@@ROWCOUNT = 0)
			set @nRetorno = 0
	end

	else begin
		UPDATE CONTDIG_BIOMET
			SET DIGITAL = @templ1+@templ2+@templ3+@templ4+@templ5+substring(@templ6,1,48), 
				Status = '1',
				Status_Rep = '1' 
			WHERE Icard = @cAuxMat AND 				-- matricula
			  BIO_TIPO = @cBioTipo AND			-- identificador  do biometrico 
			  TPDIG = @nTipo					-- identificador do dedo (0 = padro, 1=alternativo, 2 = coacao)
    
		IF (@@ROWCOUNT = 0)
			set @nRetorno = 0
	end
    
    return @nRetorno
END
GO

