if object_id('sqlatu_sagem_cnx3', 'p') is null
    exec ('create procedure sqlatu_sagem_cnx3 as select 1')
go

ALTER PROCEDURE sqlatu_sagem_cnx3 @matric char(12), @TipoChave char(1), @templ1 char(160), @templ2 char(160), 
@templ3 char(160), @templ4 char(160), @nTipo char(1), @cNumDedo char(3), @cNivel char(1)
AS

DECLARE @cAuxMat char(15), @nRetorno int, @cAux char(1)
BEGIN

    select @nRetorno = 1
    SET @cAuxMat = @matric
    
	IF (@TipoChave = '1')	-- pesquisa por Numero Serial, para coletar valor de Icard
		begin
			IF EXISTS (SELECT icard FROM CONTROLE  WHERE NUMSERIAL = substring(@matric, 3, 10))
			begin
				SELECT @cAuxMat = ICARD 
					FROM CONTROLE
					WHERE NUMSERIAL = substring(@matric, 3, 10)
			END

		end
	ELSE IF (@TipoChave = '2') 	-- pesquisa por CPF, para coletar valor de Icard
		begin
			IF EXISTS (SELECT icard FROM ContCPF  WHERE CPF = substring(@matric, 2, 11))
			begin
				SELECT @cAuxMat = ICARD 
					FROM ContCPF
					WHERE CPF = substring(@matric, 2, 11)
			END
		end
	
	
    
    IF NOT EXISTS (SELECT ICARD FROM CONTDIG_SAGEM WITH (Index = CONTDIG_SAGEM_IND1) WHERE ICARD = @cAuxMat)
    begin
		select @nRetorno = 0
    end
    IF (@nRetorno = 1)
    BEGIN
		IF (@nTipo = '0')	-- template padrao
		BEGIN
		    UPDATE CONTDIG_SAGEM SET 
		    	TEMPL_TIT1 = @templ1,
				TEMPL_TIT2 = @templ2,
				TEMPL_TIT3 = @templ3,
				TEMPL_TIT4 = substring (@templ4,1,32),
				NIVEL = @cNivel,
				NUM_DEDO_PAD = @cNumDedo,
				STATUS = '1',
				STATUS_REP = '1'
		    WHERE ICARD = @cAuxMat
		END
		ELSE IF (@nTipo = '1')	-- template alternativo
		BEGIN
		    UPDATE CONTDIG_SAGEM SET 
		    	TEMPL_ALT1 = @templ1,
				TEMPL_ALT2 = @templ2,
				TEMPL_ALT3 = @templ3,
				TEMPL_ALT4 = substring (@templ4,1,32),
				NIVEL = @cNivel,
				NUM_DEDO_ALT = @cNumDedo,
				STATUS = '1',
				STATUS_REP = '1'
			WHERE ICARD = @cAuxMat
		END
		ELSE IF (@nTipo = '2')	-- template coacao
		BEGIN
		    UPDATE CONTDIG_SAGEM SET 
		    	TEMPL_COA1 = @templ1,
				TEMPL_COA2 = @templ2,
				TEMPL_COA3 = @templ3,
				TEMPL_COA4 = substring (@templ4,1,32),
				NIVEL = @cNivel,
				NUM_DEDO_COA = @cNumDedo,
				STATUS = '1'
			WHERE ICARD = @cAuxMat
		END
    END
    ELSE
    BEGIN
		IF (@nRetorno = 0)   -- matricula nao existe, sera inserido novo
		BEGIN
		    IF (@nTipo= '0')	-- template padrao
		    BEGIN
				INSERT INTO CONTDIG_SAGEM (ICARD, TEMPL_TIT1, TEMPL_TIT2, TEMPL_TIT3, TEMPL_TIT4,
			      NIVEL, NUM_DEDO_PAD, STATUS, STATUS_REP) 
				VALUES (@cAuxMat, @templ1, @templ2, @templ3, substring (@templ4,1,32), @cNivel, @cNumDedo,'1', '1')
		    END
		    ELSE IF (@nTipo = '1')	-- template alternativo
		    BEGIN
				INSERT INTO CONTDIG_SAGEM (ICARD, TEMPL_ALT1, TEMPL_ALT2, TEMPL_ALT3, TEMPL_ALT4,
			      NIVEL, NUM_DEDO_ALT, STATUS, STATUS_REP) 
				VALUES (@cAuxMat, @templ1, @templ2, @templ3, substring (@templ4,1,32), @cNivel, @cNumDedo,'1', '1')
		    END
		    ELSE IF (@nTipo = '2') 
		    BEGIN
				INSERT INTO CONTDIG_SAGEM (ICARD, TEMPL_COA1, TEMPL_COA2, TEMPL_COA3, TEMPL_COA4,
					Nivel, NUM_DEDO_COA, STATUS)  
				VALUES (@cAuxMat, @templ1, @templ2, @templ3, substring (@templ4,1,32), @cNivel, @cNumDedo, '1');
			END;
		END
    END
    return @nRetorno
END
GO

