DROP PROCEDURE sqlatu_geomok_cnx   
GO
CREATE PROCEDURE sqlatu_geomok_cnx @matric char(12), @TipoChave char(1), @templ1 char(160), @templ2 char(160), 
@templ3 char(160), @templ4 char(160), @nTipo char(1), @cNumDedo char(2), @cNivel char(1), @templ5 char(160),
@templ6 char(26)
AS

DECLARE @cAuxMat char(15), @nRetorno int, @cAux char(1)
BEGIN
    select @nRetorno = 1
    SET @cAuxMat = @matric
    
	IF (@TipoChave = '1')	-- pesquisa por Numero Serial, para coletar valor de Icard
		begin
			IF EXISTS (SELECT icard FROM CONTROLE  WHERE NUMSERIAL = substring(@matric, 3, 10))
			begin
				SELECT @cAuxMat = ICARD 
					FROM CONTROLE
					WHERE NUMSERIAL = substring(@matric, 3, 10)
			END

		end
	ELSE IF (@TipoChave = '2')  -- pesquisa por CPF, para coletar valor de Icard
		begin
			IF EXISTS (SELECT icard FROM ContCPF  WHERE CPF = substring(@matric, 2, 11))
			begin
				SELECT @cAuxMat = ICARD 
					FROM ContCPF
					WHERE CPF = substring(@matric, 2, 11)
			END
		end
	
   
    IF NOT EXISTS (SELECT ICARD FROM CONTDIG_OMOK WITH (Index = CONTDIG_OMOK_IND1) WHERE ICARD = @cAuxMat)
    begin
		select @nRetorno = 0
    end
    IF (@nRetorno = 1)
    BEGIN
		IF (@nTipo = '0')	-- template padrao
		BEGIN
		    UPDATE CONTDIG_OMOK SET 
		    	TEMPL_TIT1 = @templ1,
				TEMPL_TIT2 = @templ2,
				TEMPL_TIT3 = @templ3,
				TEMPL_TIT4 = @templ4,
				NIVEL = @cNivel,
				NUM_DEDO_PAD = @cNumDedo,
				TEMPL_TIT5 = @templ5,
				TEMPL_TIT6 = @templ6
		    WHERE ICARD = @cAuxMat
		END
		ELSE IF (@nTipo = '1')	-- template alternativo
		BEGIN
		    UPDATE CONTDIG_OMOK SET 
		    	TEMPL_ALT1 = @templ1,
				TEMPL_ALT2 = @templ2,
				TEMPL_ALT3 = @templ3,
				TEMPL_ALT4 = @templ4,
				NIVEL = @cNivel,
				NUM_DEDO_ALT = @cNumDedo,
				TEMPL_ALT5 = @templ5,
				TEMPL_ALT6 = @templ6
			WHERE ICARD = @cAuxMat
		END
		ELSE IF (@nTipo = '2')	-- template coacao
		BEGIN
		    UPDATE CONTDIG_OMOK SET 
		    	TEMPL_COA1 = @templ1,
				TEMPL_COA2 = @templ2,
				TEMPL_COA3 = @templ3,
				TEMPL_COA4 = @templ4,
				NIVEL = @cNivel,
				NUM_DEDO_COA = @cNumDedo,
				TEMPL_COA5 = @templ5,
				TEMPL_COA6 = @templ6
			WHERE ICARD = @cAuxMat
		END
    END
    ELSE
    BEGIN
		IF (@nRetorno = 0)   -- matricula nao existe, sera inserido novo
		BEGIN
		    IF (@nTipo= '0')	-- template padrao
		    BEGIN
				INSERT INTO CONTDIG_OMOK (ICARD, TEMPL_TIT1, TEMPL_TIT2, TEMPL_TIT3, TEMPL_TIT4,
			      NIVEL, NUM_DEDO_PAD,TEMPL_TIT5,TEMPL_TIT6) 
				VALUES (@cAuxMat, @templ1, @templ2, @templ3, @templ4, @cNivel, @cNumDedo,@templ5,@templ6)
		    END
		    ELSE IF (@nTipo = '1')	-- template alternativo
		    BEGIN
				INSERT INTO CONTDIG_OMOK (ICARD, TEMPL_ALT1, TEMPL_ALT2, TEMPL_ALT3, TEMPL_ALT4,
			      NIVEL, NUM_DEDO_ALT,TEMPL_ALT5,TEMPL_ALT6) 
				VALUES (@cAuxMat, @templ1, @templ2, @templ3, @templ4, @cNivel, @cNumDedo,@templ5,@templ6)
		    END
		    ELSE IF (@nTipo = '2') 
		    BEGIN
				INSERT INTO CONTDIG_OMOK (ICARD, TEMPL_COA1, TEMPL_COA2, TEMPL_COA3, TEMPL_COA4,
					TEMPL_COA5, TEMPL_COA6, Nivel, NUM_DEDO_COA)  
				VALUES (@cAuxMat, @templ1, @templ2, @templ3, @templ4, @templ5, @templ6, @cNivel, @cNumDedo);
			END;
		END
    END
    return @nRetorno
END
GO

