CREATE OR REPLACE FUNCTION sagem_ins_controle (matric in VARCHAR2)
   RETURN NUMBER IS
   cAuxMat VARCHAR2(15);
   nRetorno NUMBER;
   cAux   VARCHAR2(1);
   reco_lock EXCEPTION;
   PRAGMA EXCEPTION_INIT (reco_lock,-54);  -- erro quando registro lockado 

BEGIN
	nRetorno := 0;
	BEGIN 
		SELECT Icard INTO cAuxMat FROM CONTROLE
			WHERE Icard = matric ;
	EXCEPTION
		WHEN NO_DATA_FOUND THEN 
			nRetorno := 1;
		WHEN OTHERS THEN 
			nRetorno := -1;
	END;

	IF (nRetorno = 1) THEN          
		-- matrcula nao existe, sera' inserido novo 
		INSERT INTO CONTROLE (Icard, Situa, Grupo) 
			VALUES (matric, '0', '001');
		COMMIT;
	END IF;
	return (nRetorno);
END sagem_ins_controle;
/

