CREATE or REPLACE FUNCTION sqlatu2_pendon002(cTpCarga in VARCHAR2, nLivre in NUMBER,cEndIp in VARCHAR2) RETURN NUMBER IS
cStatus char(1);
reco_lock EXCEPTION;
PRAGMA EXCEPTION_INIT (reco_lock, -54);
nRet number;
x number;

begin
	nRet := 0;
	--dbms_output.put_line ('ctpcarga = ' || cTpCarga);

	if ((cTpCarga = '0') or (cTpCarga = '1') or (cTpCarga = '2') or	(cTpCarga = '3')) then
		BEGIN
			select /*+ INDEX (INDEX2_PEND_ON002ON) */
				STATUS into cStatus from PEND_ON002ON
				where END_IP = cEndIp and STATUS = '2' for update nowait;
				
			BEGIN
				select 
					STATUS into cStatus from PEND_ON008ON
					where END_IP = cEndIp for update nowait;


				-- 0 = Lista pendncia online foi carregada
				if (cTpCarga = '0') then
					update /*+ INDEX (INDEX1_PEND_ON002ON) */
						PEND_ON002ON 
						set STATUS = '3', 
							QTD_LIVRE = nLivre
					where END_IP = cEndIp;

				-- 1 = Lista pendencia online nao foi carregada devido a falta de espao
				elsif (cTpCarga = '1') then
					update /*+ INDEX (INDEX1_PEND_ON002ON) */
						PEND_ON002ON 
						set STATUS = '5', 
							QTD_LIVRE = nLivre
					where END_IP = cEndIp;

				-- 2 = Lista pendencia online nao foi carregada devido a outros erros
				elsif (cTpCarga = '2') then
					update /*+ INDEX (INDEX1_PEND_ON002ON) */
						PEND_ON002ON 
						set STATUS = '4', 
							QTD_LIVRE = nLivre
					where END_IP = cEndIp;

				-- 3 = Lista pendencia online nao foi carregada pois codin no respondeu
				else  --(cTpCarga = '3') 
					update /*+ INDEX (INDEX1_PEND_ON002ON) */
						PEND_ON002ON 
						set STATUS = '4'
						where END_IP = cEndIp;
				end if;
				COMMIT;
				
			EXCEPTION
				when reco_lock then 
					ROLLBACK;
					nRet := -1;
				when NO_DATA_FOUND then x := 0;
			END;
			
		EXCEPTION
			when reco_lock then nRet := -1;
			when NO_DATA_FOUND then x := 0;
		END;
		
	elsif (cTpCarga = '4') then -- cTpCarga = '4' = Houve comando de Apagar Pendencias do Codin = as pendencias deverao ser reenviadas 
 		begin
 			select /*+ INDEX (INDEX1_PEND_ON002ON) */
				STATUS into cStatus from PEND_ON002ON
				where END_IP = cEndIp and
					  STATUS <> '7'
				for update nowait;

			begin
				select STATUS into cStatus from PEND_ON008ON
					where END_IP = cEndIp for update nowait;
					
				update PEND_ON002ON  /*+ INDEX (INDEX1_PEND_ON002ON) */
					set STATUS = '7', 
						QTD_LIVRE = 1
					where END_IP = cEndIp;
				
				COMMIT;

			exception
				when reco_lock then 
					rollback;
					nRet := -1;
				when NO_DATA_FOUND then x := 0;
			END;
			
		EXCEPTION
			when reco_lock then nRet := -1;
			when NO_DATA_FOUND then x := 0;
		END;
			

		begin
			select /*+ INDEX (INDEX1_PEND_ON002OFF) */
				STATUS_OFF into cStatus from PEND_ON002OFF
				where END_IP = cEndIp and 
					STATUS_OFF <> '7' 
				for update nowait;

			begin
				select STATUS_OFF into cStatus from PEND_ON008OFF
				where END_IP = cEndIp for update nowait;

				update PEND_ON002OFF   /*+ INDEX (INDEX1_PEND_ON002OFF) */
					set	STATUS_OFF = '7',
						QTD_LIVREOFF = 1
					where END_IP = cEndIp;

				COMMIT;

			exception
				when reco_lock then 
					rollback;
					nRet := -1;
				when NO_DATA_FOUND then x := 0;
			end;

		exception
			when reco_lock then nRet := -1;
			when NO_DATA_FOUND then x := 0;
		end;


	elsif (cTpCarga = '5') then 		 -- 5 = somente indicacao de qtde.livre no codin
 		begin
 			select /*+ INDEX (INDEX1_PEND_ON002ON) */
				STATUS into cStatus from PEND_ON002ON
			where END_IP = cEndIp for update nowait;

			update PEND_ON002ON  /*+ INDEX (INDEX1_PEND_ON002ON) */
				set	QTD_LIVRE = nLivre 
				where END_IP = cEndIp;
			COMMIT;

		exception
			when reco_lock then nRet := -1;
			when NO_DATA_FOUND then x := 0;
		end;

	else		-- 6 COMANDO CARGA APLICATIVO
 		begin
 			select /*+ INDEX (INDEX1_PEND_ON002ON) */
				STATUS into cStatus from PEND_ON002ON
				where END_IP = cEndIp and 
					STATUS <> '6' 	
				for update nowait;

			begin
				select 
					STATUS into cStatus from PEND_ON008ON
					where END_IP = cEndIp for update nowait;

				update PEND_ON002ON  /*+ INDEX (INDEX1_PEND_ON002ON) */
					set STATUS = '6', 	
						QTD_LIVRE = 0
					where END_IP = cEndIp;
					
				COMMIT;

			exception
				when reco_lock then 
					rollback;
					nRet := -1;
				when NO_DATA_FOUND then x := 0;
			end;

		exception
			when reco_lock then nRet := -1;
			when NO_DATA_FOUND then x := 0;
		end;


 		begin
 			select /*+ INDEX (INDEX1_PEND_ON002OFF) */
				STATUS_OFF into cStatus from PEND_ON002OFF
				where END_IP = cEndIp and 
					STATUS_OFF <> '6' 
				for update nowait;
				
			begin
				select 
					STATUS_OFF into cStatus from PEND_ON008OFF
					where END_IP = cEndIp 
					for update nowait;
				
				update PEND_ON002OFF   /*+ INDEX (INDEX1_PEND_ON002OFF) */
					set	STATUS_OFF = '6',
						QTD_LIVREOFF = 0
					where END_IP = cEndIp;
					
				COMMIT;

			exception
				when reco_lock then 
					rollback;
					nRet := -1;
				when NO_DATA_FOUND then x := 0;
			end;

		exception
			when reco_lock then nRet := -1;
			when NO_DATA_FOUND then x := 0;
		end;
		
	end if;
	return (nRet);

END sqlatu2_pendon002;
/
