CREATE OR REPLACE FUNCTION sqlver_RepPonto (cMatric in VARCHAR2, cDataHora in out VARCHAR2) RETURN NUMBER IS
	
dDtaHoraTab	DATE;
dDtaHorUlt DATE;

BEGIN

	-- CONEXREP
		-- coletara do REPEMPR002 todos os IFUNCS q foram cadastrados com o mesmo PIS
		-- guardar em REPPONTO, todos esses IFUNCS+ PIS com a DATA e HORA da marcacao de Ponto. Exemplo: titular e varios provisrios com o mesmo valor de PIS
	-- FIM CONEXREP
	
	
	-- CONEX ACESSO:
		-- situacao 1: o Conex Acesso ao passar o crach Titular, procurara pelo Icard  em REPPONTO e far a validacao de datahora para interjornada
		-- situacao 2: o Conex Acesso ao passar o crach Provisrio, procurara pelo Icard (agora do Titular)  em REPPONTO e far a validacao de datahora para interjornada
		-- ou seja, apesar de ter sido armazenado em REPPONTO vrios Icards com mesmo PIs, o Conex s procurar pelo Icard (q  do Titular), e caso encontre mais de uma linha
		-- com o mesmo Icard, s ser considerado o de datahora mais recente
	-- FIM CONEX ACESSO
	
	
	dDtaHorUlt := to_date ('010101000000', 'ddmmyyhh24miss');	-- data/hora inicial 01/01/2001 00:00:00

	SELECT MAX (DTAHORAREP) into dDtaHoraTab 
		FROM REPPONTO WHERE IFUNC = cMatric ;

	IF (dDtaHoraTab > dDtaHorUlt) THEN
		dDtaHorUlt := dDtaHoraTab;
	END IF;
	
	
	cDataHora := to_char(dDtaHorUlt, 'ddmmyyhh24miss');
	return (1);	
	
END sqlver_RepPonto;
/
