CREATE OR REPLACE FUNCTION sqllst_exc_sad (cMatric IN VARCHAR2, mensagem OUT VARCHAR2) 
   RETURN NUMBER IS
      RetFun NUMBER;
      VarAux   VARCHAR2(12);
      reco_lock EXCEPTION;
      PRAGMA EXCEPTION_INIT (reco_lock, -54);  -- erro quando registro lockado 
BEGIN
   RetFun := 0;       -- assume matricula encontrada
   mensagem := 'OK';

   BEGIN
   SELECT ICard into VarAux FROM EXCESAD
      WHERE ICard = cMatric;

   EXCEPTION
      WHEN NO_DATA_FOUND THEN       -- reg. nao encontrado
         RetFun := -2;
         mensagem := 'Matricula ' || cMatric || ' nao encontrado !! Retorno = '|| TO_CHAR(RetFun);
      WHEN OTHERS THEN              -- outros erros
         RetFun := -1;
         mensagem := 'Outros erros encontrados!! Retorno = '|| TO_CHAR(RetFun);
   END;
   return (RetFun);
END sqllst_exc_SAD;
/

