CREATE OR REPLACE FUNCTION sqlcon_sad_bloq (cSad IN VARCHAR2, cTamSad IN varchar2, mensagem OUT VARCHAR2) 
   RETURN NUMBER IS
      RetFun NUMBER;
      SadAux   VARCHAR2(10);
      BloqAux  VARCHAR2(3);
      reco_lock EXCEPTION;
      PRAGMA EXCEPTION_INIT (reco_lock, -54);  -- erro quando registro lockado 
BEGIN
   RetFun := 0;       -- assume matricula encontrada
   BEGIN
--   SELECT Sad, Bloqueado into SadAux, BloqAux FROM BLOQSAD 
--       WHERE Sad = cSad;


   SELECT Sad, Bloqueado into SadAux, BloqAux FROM BLOQSAD 
       WHERE substr(Sad, 1, to_number(cTamSad)) = cSad;

   IF (BloqAux = '1') THEN
	RetFun := 1;
        mensagem := 'Sad '|| cSad || ' bloqueado';
   ELSIF (BloqAux = '0') THEN
	RetFun := 0;
	mensagem := 'Sad '|| cSad || ' nao bloqueado';
   ELSE
	RetFun := -1;
	mensagem := 'Lista SAD com valor bloqueado diferente de 0/1';
   END IF;
   return (Retfun);

   EXCEPTION
      WHEN reco_lock THEN
         RetFun := -1;              -- reg. lockado
         mensagem := 'Sad '|| cSad ||' lockado!! Retorno = '|| TO_CHAR (RetFun);
      WHEN NO_DATA_FOUND THEN       -- reg. nao encontrado
         RetFun := -2;
         mensagem := 'Sad ' || cSad || ' nao encontrado !! Retorno = '|| TO_CHAR(RetFun);
      WHEN OTHERS THEN              -- outros erros
         RetFun := -1;
         mensagem := 'Outros erros encontrados!! Retorno = '|| TO_CHAR(RetFun);
   END;
   return (RetFun);
END sqlcon_sad_bloq;
/

