
--  ****************************************************************************
--
-- Copyright (c) 2005, Telemtica Sistemas Inteligentes.
--
--    NAME
--      sp_criarpendencias_off - Criar Pendncias On line e OFF line
--
--    VERSION <<< ORACLE >>>
--      1.0.0.0 - RN
--
--    USE CASE
--      CRIAR PENDNCIA OFF LINE
--
--    AUTHOR
--      Raphael Loureno de jesus (TSI)
--
--    DESCRIPTION
--      Criar pendncias On line e Off Line ao inserir na tabela ATUALI
-- ****************************************************************************
CREATE OR REPLACE  PROCEDURE SP_CRIARPENDENCIAS (
sp_identif in char,
sp_numserial in char,
sp_icard in char,
sp_numcpo in char,
sp_inform in char ) is

c controle%rowtype ;
QTDE_LIVRE number := 1 ;
tipo_atu char := '1' ;
QTDE_HORA_EXPIRAR number := 12 ;
VISITANTE char := ' ' ;
x number ;
VSTATUS number := 0 ;
QTDE number := 0 ;
x_grupo char(3) := '000';
x_status char;  
x_count number;
reco_lock EXCEPTION;
PRAGMA EXCEPTION_INIT (reco_lock, -54);  
p_rec pend_on001%rowtype;
  
BEGIN

	--------------------------------------------------------------------------------
	-- VERIFICAR SE O TIPO DE CARTO  VISITANTE OU PROVISRIO
	--------------------------------------------------------------------------------
	select * into c from controle where numserial = sp_numserial and icard = sp_icard ;

	VISITANTE := '0' ;

	if c.tpfis = '4' or c.situa = '4' then
		VISITANTE := '4' ;
		GOTO Final_Pend ;
	end if ;

	------------------------------------------------------------------------------------
	-- VERIFICA SE ESTA ALTERANDO VALORES DE GRUPO, PARA ENVIAR TAMBEM AO GRUPO ANTERIOR 
	------------------------------------------------------------------------------------
	if sp_numcpo = '25' then 
		BEGIN select grupo_ant into x_grupo from pend_grupo where numserial = sp_numserial;
		EXCEPTION WHEN NO_DATA_FOUND THEN x_grupo := '000';
		END;
	elsif sp_numcpo = '26' then 
		BEGIN select grupo1_ant into x_grupo from pend_grupo where numserial = sp_numserial;
		EXCEPTION WHEN NO_DATA_FOUND THEN x_grupo := '000';
		END;
	elsif sp_numcpo = '29' then 
		BEGIN select grupo2_ant into x_grupo from pend_grupo where numserial = sp_numserial;
		EXCEPTION WHEN NO_DATA_FOUND THEN x_grupo := '000';
		END;
	elsif sp_numcpo = '32' then 
		BEGIN select grupo3_ant into x_grupo from pend_grupo where numserial = sp_numserial;
		EXCEPTION WHEN NO_DATA_FOUND THEN x_grupo := '000';
		END;
	elsif sp_numcpo = '35' then 
		BEGIN select grupo_sab_ant into x_grupo from pend_grupo where numserial = sp_numserial;
		EXCEPTION WHEN NO_DATA_FOUND THEN x_grupo := '000';
		END;
	elsif sp_numcpo = '36' then 
		BEGIN select grupo_dom_ant into x_grupo from pend_grupo where numserial = sp_numserial;
		EXCEPTION WHEN NO_DATA_FOUND THEN x_grupo := '000';
		END;
	elsif sp_numcpo = '37' then 
		BEGIN select grupo_fer_ant into x_grupo from pend_grupo where numserial = sp_numserial;
		EXCEPTION WHEN NO_DATA_FOUND THEN x_grupo := '000';
		END;
	end if;


	--------------------------------------------------------------------------------
	-- INSERIR NA TABELA TEMPORRIA O RELACIONAMENTO ENTRE CONTROLE x DAT07 x DAT08
	--------------------------------------------------------------------------------
	insert into tmp_codins
    select distinct sp_identif, sp_numserial, sp_icard, sp_numcpo, sp_inform, dat07.end_ip
	    from dat07, dat08
    	where
			dat07.laces = dat08.laces and
			dat07.planta = dat08.planta and
			dat07.end_ip <> '000.000.000.000' and
			dat07.tip_leit = '1' and
			dat08.grupo in (
				select grupo from pend_grupo where numserial = sp_numserial
				  union
				select grupo1 from pend_grupo where numserial = sp_numserial
				  union
				select grupo2 from pend_grupo where numserial = sp_numserial
				  union
				select grupo3 from pend_grupo where numserial = sp_numserial
				  union
				select grupo_sab from pend_grupo where numserial = sp_numserial
				  union
				select grupo_dom from pend_grupo where numserial = sp_numserial
				  union
				select grupo_fer from pend_grupo where numserial = sp_numserial
				  union
				select  x_grupo from pend_grupo where numserial = sp_numserial
      		) ;

	---------------------------------------
	-- TIPO DE PENDENCIA
	---------------------------------------
	if to_number(sp_numcpo) in (2,14,15,19,25,26,27,28,29,30,31,32,33,34,35,36,37,59,61,62,63,64,65,66) then
		tipo_atu := '0';
	else
		tipo_atu := '1';
	end if;

	-----------------------------------
	-- OVER DUPLICIDADE DE PENDNCIA
	-----------------------------------

	for r in ( select * from tmp_codins ) 
	loop
--		if (tipo_atu = '1') then
--			for z in (
--				select rowid from pend_on001 p1 
--				where
--					p1.numserial = r.numserial and
--					p1.end_ip = r.end_ip and
--					p1.numcpo = r.numcpo and
--					p1.tipo_atu = '1' and
--					p1.status = '0'
--				) loop
--	    		BEGIN
--					select * into p_rec from pend_on001 
--						where rowid = z.rowid for update nowait;
--
--					delete pend_on001 p1 
--						where rowid = z.rowid;				
--				EXCEPTION
--					when reco_lock then
--						null;
--					when NO_DATA_FOUND then 
--						null;
--					when OTHERS then 
--						null;
--				END;
--			end loop;	
--		end if;
		insert into pend_on001 ( identif, numserial, icard, tipo, numcpo, inform, end_ip, status, tipo_atu )
			values (r.identif, r.numserial, r.icard, VISITANTE, r.numcpo, r.inform, r.end_ip, '0', tipo_atu);
	end loop ;


--	for r in ( select * from tmp_codins ) loop
--	    if  tipo_atu = '1' then
--			select count(*) into x_count from pend_on003 where numserial = r.numserial and end_ip = r.end_ip;
--			if x_count = 0 then 
--				x_status := '0';
--			else 
--				x_status := '1'; 	
--   		end if;
--		else
--			x_status := '0';
--		end if;
--		insert into pend_on001 ( identif, numserial, icard, tipo, numcpo, inform, end_ip, status,TIPO_ATU )
--			values (r.identif, r.numserial, r.icard, VISITANTE, r.numcpo, r.inform, r.end_ip, x_status, TIPO_ATU);
--	end loop ;

	-----------------
	-- INSERIR CODINS em PEND_ON002
	-----------------
	insert into pend_on002on (end_ip, qtd_livre, qhor_exp, STATUS)
		select distinct end_ip, 1, 12, '0'  
		from
			tmp_codins
		where
			end_ip not in ( select end_ip from pend_on002on );

	insert into pend_on002off (end_ip, qhor_exp,QTD_LIVREOFF,STATUS_OFF)
		select distinct end_ip, 12 ,1,'0' 
		from
			tmp_codins
		where
			end_ip not in ( select end_ip from pend_on002off );

	insert into pend_on002lpz (end_ip, qhor_exp,STATUS_LPZ)
		select distinct end_ip, 12,'0' 
		from
			tmp_codins
		where
			end_ip not in ( select end_ip from pend_on002lpz );

	-----------------
	-- INSERIR CODINS em PEND_ON008
	-----------------
	insert into pend_on008on (end_ip, qhor_exp, STATUS)
		select distinct end_ip, 12, '0'  
		from
			tmp_codins
		where
			end_ip not in ( select end_ip from pend_on008on );

	insert into pend_on008off (end_ip, STATUS_OFF)
		select distinct end_ip,'0' 
		from
			tmp_codins
		where
			end_ip not in ( select end_ip from pend_on008off );

	insert into pend_on008lpz (end_ip,STATUS_LPZ)
		select distinct end_ip, '0' 
		from
			tmp_codins
		where
			end_ip not in ( select end_ip from pend_on008lpz );

	--------------------------------------
	-- OVER REGISTROS TABELA TEMPORRIA
	--------------------------------------
	delete from tmp_codins ;
	<<Final_Pend>>
	NULL ;


EXCEPTION
	when NO_DATA_FOUND then
		x := 0 ;
end sp_criarpendencias ;
/


-- ****************************************************************************;