--**********************************************************************************************
--		I N I C I O   D A   P R O C E D U R E    SP_EXPIROUPENDENCIA
--**********************************************************************************************

CREATE OR REPLACE  PROCEDURE SP2_EXPIROUPENDENCIA  ( 
    sp_expiredtime in number, sp_limitexpiredtime in number ) is 

reco_lock EXCEPTION;
tem_deadlock EXCEPTION; 
PRAGMA EXCEPTION_INIT (reco_lock, -54);  
PRAGMA EXCEPTION_INIT (tem_deadlock, -60); 

dtlimite varchar(12) ;
rstatus pend_on001.status%type ;
p_rec pend_on001%rowtype;
a_rec atuali%rowtype;
l_rowid rowid;
d1 date;
cont_a number;
cont_b number;
cont number;
  
BEGIN
	
	-- CALCULA DATA LIMITE PARA EXPIRACAO 60 (sp_limitexpiredtime) DIAS
	select to_char( SYSDATE - sp_limitexpiredtime , 'YYMMDDHH24MISS' ) into dtlimite from dual ;  
	
	-- CALCULA HORA LIMITE PARA RECARGA DAS PENDENCIAS (12 - sp_expiredtime HORAS)
	d1 := trunc( SYSDATE + ( 1 / 24 * sp_expiredtime ), 'HH24' );

	for c in (select end_ip from PEND_ON002ON order by end_ip desc)
	loop
		-- VERIFICA AS ATUALIZACOES QUE DEVERAO EXCLUIDAS APOS 60 (sp_limitexpiredtime) DIAS 
		cont_a := 0;
		for c1 in (select rowid from PEND_ON001 
					where end_ip = c.end_ip and
					identif < dtlimite)
		loop
			BEGIN
				select * into p_rec from PEND_ON001 
						where rowid = c1.rowid for update nowait;

				delete from PEND_ON001 where rowid = c1.rowid;
				
				cont_a := 1;

			EXCEPTION
				when reco_lock then rstatus := '0';
				when tem_deadlock then rstatus := '0';
				when NO_DATA_FOUND then rstatus := '0';
				when OTHERS then rstatus := '0';
			END;
		end loop;


		-- foi retirado
		-- VERIFICA AS ATUALIZACOES QUE DEVERAO SER REENVIADAS (12 HORAS) AOS CODINS
--		cont_b := 0;
--		for c3 in (select rowid from PEND_ON001 
--					where end_ip = c.end_ip and
--				  		tipo_atu = '1' and
--						trunc (data_exp, 'HH24') <= d1 and
--						status = '5') 
--		loop
--			BEGIN
--				select * into p_rec from PEND_ON001 
--					where rowid = c3.rowid 
--					for update nowait;
--
--				update pend_on001 
--					set data_exp = null, 
--						status = '0'
--					where rowid = c3.rowid ;
--					
--				cont_b := 1;
--	
--			EXCEPTION
--				when reco_lock then rstatus := '0';
--				when NO_DATA_FOUND then rstatus := '0';	
--
--			END;
--		end loop;

--		if (cont_a = 1) or (cont_b = 1) then
		if (cont_a = 1) then
			COMMIT;
		end if;
	end loop;
	

	-- LIMPEZA DA ATUALI DAS PENDENCIAS SUPERIOR A 60 (sp_limitexpiredtime) DIAS
	cont := 0;
	for c2 in (select rowid from ATUALI where identif < dtlimite)
	loop
		BEGIN
			select * into a_rec from ATUALI 
				where rowid = c2.rowid for update nowait;
			
			delete from atuali where rowid = c2.rowid;
			
			cont := 1;
	
		EXCEPTION
			when reco_lock then rstatus := '0';
			when tem_deadlock then rstatus := '0';
			when NO_DATA_FOUND then rstatus := '0';
			when OTHERS then rstatus := '0';
		END;
	end loop;

	if (cont = 1) then
		COMMIT;
	end if;

end sp2_expiroupendencia ;
/
