
--**********************************************************************************************
--		I N I C I O   D A   P R O C E D U R E   SP2A_STATUSOFF   
--**********************************************************************************************

CREATE OR REPLACE  PROCEDURE SP2A_STATUSOFF  is 

reco_lock EXCEPTION;
tem_deadlock EXCEPTION; 
PRAGMA EXCEPTION_INIT (reco_lock, -54);  
PRAGMA EXCEPTION_INIT (tem_deadlock, -60); 
rstatus varchar(1);
AUX varchar(1);
AUXID VARCHAR(20);
XIDENTIF VARCHAR(20);
contador number;

p_rec pend_on001%rowtype;


TYPE endip_type IS TABLE OF pend_on008off.end_ip%TYPE 
	INDEX BY binary_integer;
TYPE status_type IS TABLE OF pend_on008off.status_off%TYPE 
	INDEX BY binary_integer;
TYPE qhorexp_type IS TABLE OF pend_on008off.qhor_expoff%TYPE 
	INDEX BY binary_integer;

l_endip endip_type;
l_statusoff status_type;
l_qhorexpoff qhorexp_type;


BEGIN

	--------------------------------------------------
	-- I N I C I O   D A   P A R T E   O F F   L I N E
	--------------------------------------------------
	SELECT END_IP, STATUS_OFF, QHOR_EXPOFF 
	BULK COLLECT INTO l_endip, l_statusoff, l_qhorexpoff 
		FROM PEND_ON008OFF 
		--where status_off in ('3','4','5','6','7','8');
		where status_off in ('3','4','5','7','8');
		
	FOR indx in 1 .. l_endip.count 
	LOOP	

		------------------------------------------------------
		-- S U C E S S O   N O   E N V I O    O F F    L I N E   
		------------------------------------------------------
		IF l_statusoff(indx) = '3' then 
			contador := 0;
			
			for r in ( select * from pend_on004 where end_ip = l_endip(indx) ) 
			LOOP
				for c_foff in (select rowid, identif from pend_on001 p1
					where 
						p1.numserial = r.numserial and  
						p1.end_ip = r.end_ip and 
						p1.identif <= r.identif and
						p1.numcpo = r.numcpo )
						
				loop
					BEGIN
						select * INTO p_rec from pend_on001  
							where rowid = c_foff.rowid 
						for update nowait;

						IF c_foff.identif = r.identif then
							update pend_on001 set status = '5' where rowid = c_foff.rowid ;
						ELSE						
							delete pend_on001 where rowid = c_foff.rowid;
						END IF;
				
					EXCEPTION
						when reco_lock then NULL;
						when tem_deadlock then NULL; 
						when NO_DATA_FOUND then NULL;
						when OTHERS then NULL;
					END;
				end loop;
				
			END LOOP;							
			

			BEGIN
				select status_off into AUX from PEND_ON008OFF where end_ip = l_endip(indx) for update nowait;

				update pend_on008OFF set status_off = '0' where end_ip = l_endip(indx);

				update pend_on002OFF set status_off = '0' where end_ip = l_endip(indx);

				delete from pend_on004 where end_ip = l_endip(indx);


			EXCEPTION
				when reco_lock then NULL;
				when tem_deadlock then NULL;
			END;
			
			COMMIT;

		-------------------------------------------------------------
		-- F A L H A   N A   T R A N S M I S S  O    O F F   L I N E
		-------------------------------------------------------------
		ELSIF l_statusoff(indx) = '4' then

			update pend_on008OFF set status_off = '0' where end_ip = l_endip(indx);

			update pend_on002OFF set status_off = '1' where end_ip = l_endip(indx);

			COMMIT;

		-------------------------------------------------------------------
		-- E X C E D E U   L I M I T E   D E   L I S T A   O F F    L I N E   
		-------------------------------------------------------------------
		ELSIF l_statusoff(indx) = '5' then
			contador := 0;
			for r in ( select * from pend_on004 where pend_on004.end_ip = l_endip(indx)) 
			LOOP
				for c_foff in (select rowid from pend_on001 p1 
					where 
						p1.numserial = r.numserial and  
						p1.end_ip = r.end_ip and 
						p1.identif <= r.identif and
						p1.tipo_atu = '0' and        
						p1.status = '1' )
				LOOP
					BEGIN
						select * INTO p_rec from pend_on001 p1
							where rowid = c_foff.rowid 
						for update nowait;

						update pend_on001 p1 set status = '0' 
							where rowid = c_foff.rowid ;
							
					EXCEPTION
						when reco_lock then contador := 1;
						when tem_deadlock then contador := 1;
						when NO_DATA_FOUND then NULL;
						when OTHERS then NULL;
					END;
				END LOOP;							
			END LOOP;							
			
			
			IF (contador = 0) then
				begin
					select status_off into aux from pend_on008off where end_ip = l_endip(indx) for update nowait;

					update pend_on008OFF set status_off = '0' where end_ip = l_endip(indx) ;

					update pend_on002OFF set status_off = '0' where end_ip = l_endip(indx)  ;

					delete from pend_on004 where end_ip = l_endip(indx)  ;

				exception
					when reco_lock then NULL;
					when tem_deadlock then NULL;
				end;
			end if;

			COMMIT;

		---------------------------------------------------------------------------------------
		-- 6 = A P A G O U    A P L I C A T I V O (	nao sera tratado )  
		-- 7 = L I M P O U   M E M O R I A   D O   C O D I N   V I A   C O M A N D O   ou
		--     atraves comando datahora apos apagar memoria e carga de aplicativo
		-- 8 = L I M P E Z A   M E M O R I A   D O   C O D I N   V I A   A G E N D A M E N T O (PEND_ON002LPZ)
		---------------------------------------------------------------------------------------
		--ELSIF l_statusoff(indx)  = '6' or l_statusoff(indx)  = '7' or l_statusoff(indx)  = '8' then
		ELSIF l_statusoff(indx)  = '7' or l_statusoff(indx)  = '8' then

			for c_off in (select rowid from pend_on001
				where 
					end_ip = l_endip(indx) and 
					tipo_atu = '0' and
					status in ( '1', '5' ) )
			loop
				BEGIN
					select * into p_rec from pend_on001
						where rowid = c_off.rowid
					for update nowait;
					
					update pend_on001 set status = '0' 
						where rowid = c_off.rowid;
						
				EXCEPTION
					when reco_lock then NULL;
					when tem_deadlock then NULL;
					when NO_DATA_FOUND then NULL;
					when OTHERS then NULL;
				END;
			end loop;


			BEGIN
				select status_off into aux from pend_on008OFF where end_ip = l_endip(indx) for update nowait;
				update pend_on008OFF set status_off = '0' where end_ip = l_endip(indx);
				update pend_on002OFF set status_off = '0' where end_ip = l_endip(indx);
				delete from pend_on004 p4 where p4.end_ip = l_endip(indx) ;
				
				
			EXCEPTION
				when reco_lock then NULL;
				when tem_deadlock then NULL;
			END;

			COMMIT;
				
		END IF ;

	END LOOP;

	--------------------------------------------
	-- F I M   D A   P A R T E   O F F   L I N E 
	--------------------------------------------


	-------------------------------------------
	-- O F F   L I N E   E M   P E N D E N C I A
	-------------------------------------------

	update pend_on002OFF set status_OFF = '4' 
		where (STATUS_OFF  = '2' or STATUS_OFF  = '4') and DATA_INIOFF + ( 1 / 24 / 60 ) < sysdate;
	commit;		




end SP2A_STATUSOFF;
/


