--**********************************************************************************************
--		I N I C I O   D A   P R O C E D U R E    SP_CRIARLISTAPENDENCIA_OFF
--**********************************************************************************************

CREATE OR REPLACE  PROCEDURE  SP2_CRIARLISTAPENDENCIA_OFF  is 

--MAXLIST number := 60 ;  
MAXLIST number := 40 ;  
QTDELIST number ;
QTDE_IN_LISTA integer ;

reco_lock EXCEPTION;
tem_deadlock EXCEPTION; 

PRAGMA EXCEPTION_INIT (reco_lock, -54);  
PRAGMA EXCEPTION_INIT (tem_deadlock, -60); 

TYPE endip_type IS TABLE OF PEND_ON002OFF.end_ip%TYPE 
	INDEX BY binary_integer;
TYPE qtdlivre_type IS TABLE OF PEND_ON002OFF.qtd_livreoff%TYPE 
	INDEX BY binary_integer;
TYPE rowid_type IS TABLE OF ROWID  
	INDEX BY binary_integer;
TYPE atuforc_type IS TABLE OF DAT07.atuforc%TYPE 
	INDEX BY binary_integer;
TYPE datforc_type IS TABLE OF DAT07.datforc%TYPE 
	INDEX BY binary_integer;
	
l_endip endip_type;
l_qtdlivre qtdlivre_type;
l_rowid rowid_type;
l_atuforc atuforc_type;
l_datforc datforc_type;

rstatus pend_on002off.status_off%type ;
p_rec pend_on001%rowtype;

BEGIN

	SP2A_STATUSOFF;
	
	SELECT p.end_ip, p.qtd_livreOFF, p.rowid, d.atuforc, d.datforc
		BULK COLLECT INTO l_endip, l_qtdlivre, l_rowid, l_atuforc, l_datforc 
	from 
		PEND_ON002OFF p, dat07 d 
	where 
		p.end_ip = d.end_ip and 
		p.status_off = '0' and 
		p.qtd_livreoff > 0 and
		p.blueb = '00' and
		p.codin = '00' and 
		( exists ( select 1 from pend_on001 where end_ip = p.end_ip and tipo_atu = '0' and status = '0' and rownum <= 1 ) or
		  exists ( select 1 from pend_on004 where end_ip = p.end_ip and rownum <= 1 )
		) ;
	
	FOR indx IN 1 .. l_endip.count     
	LOOP
		-- verifica se ja halista pronta a ser carregada em pend_on004
		select count(*) into QTDE_IN_LISTA from pend_on004 where end_ip = l_endip(indx);
  
		if QTDE_IN_LISTA > 0 then
			begin
				select status_off into rstatus from pend_on002off
					where rowid = l_rowid(indx) for update nowait;
		
				update pend_on002off set status_off = '1' where rowid = l_rowid(indx);
				COMMIT;
				GOTO Main_Loop ;
				
			EXCEPTION
				when reco_lock then GOTO Main_Loop;
				when NO_DATA_FOUND then GOTO Main_Loop;
				when OTHERS then GOTO Main_Loop;
			END;
			
		end if ;  
  
		-- atribui qtde maxima de registro a serem carregados no codin
		select least( l_qtdlivre(indx), MAXLIST ) into QTDELIST from dual ;

		insert into tmp_listapendencia_off ( end_ip, numserial, identif , tipo_atu, NUMCPO , INFORM )
			select
				l_endip(indx),
				subqry.numserial,
				subqry.identif,
		        0,
		        subqry.numcpo,
		        inform
			from
			(
				select 
					numserial,
					max_identif as identif,
					numcpo
				from
				(    
					select
						numserial, 
						max( identif ) as max_identif,
						min( identif ) as min_identif,
						NUMCPO
					from 
						pend_on001
					where 
						end_ip = l_endip(indx) and
						tipo_atu = '0' and
						status = '0' and 
						tipo <> '4' and
						( ( l_atuforc(indx) = '0' ) or 
						  ( l_atuforc(indx)= '1' and l_datforc(indx) is null ) or 
						  ( l_atuforc(indx) = '1' and identif > to_char(l_datforc(indx),'YYMMDDHH24MISS') ) 
						) 
					group by 
						numserial,
						numcpo
					order by 3 
				)
				where rownum <= QTDELIST
			) subqry,
				pend_on001 p
			where 
				p.numserial = subqry.numserial and 
				p.end_ip = l_endip(indx) and  
				p.identif = subqry.identif and 
				p.numcpo = subqry.numcpo; 

		if not SQL%FOUND then
			GOTO Main_Loop ;
		end if ;  

            
		rstatus := 0;
		insert into pend_on004 ( end_ip, numserial, identif ,NUMCPO , INFORM ) 
			select  end_ip, numserial, identif  , NUMCPO , INFORM from tmp_listapendencia_off;


		for rec in ( select * from tmp_listapendencia_off) 
		LOOP
			for c_cpoff in (
				select rowid from pend_on001 p1
				where 
					p1.numserial = rec.numserial and 
					p1.end_ip = rec.end_ip and 
					p1.identif <= rec.identif and
					p1.tipo_atu = '0' and
					p1.numcpo = rec.numcpo and
					p1.status = '0' )

			loop
				BEGIN
					select * INTO p_rec from pend_on001  
					where 
						rowid = c_cpoff.rowid 
					for update nowait;
					
					update pend_on001 set status = '1' where rowid = c_cpoff.rowid;
			
				EXCEPTION
					when reco_lock then NULL;
					when NO_DATA_FOUND then NULL;
					when OTHERS then NULL;
				END;
			end loop;

		END LOOP ;
    
		BEGIN
			select status_off into rstatus 
				from pend_on002off 
				where rowid = l_rowid(indx) for update nowait;

			update pend_on002off set STATUS_OFF = '1' where rowid = l_rowid(indx);

		EXCEPTION
			when reco_lock then NULL;
	    	when NO_DATA_FOUND then NULL;
	    	when OTHERS then NULL;
		END;

		COMMIT ;    
    
		<<Main_Loop>>
		NULL ;
	END LOOP ; 
  
end sp2_criarlistapendencia_off ;
/
