--**********************************************************************************************
--		I N I C I O   D A   P R O C E D U R E    SP_CRIARLISTAPENDENCIA
--**********************************************************************************************

CREATE OR REPLACE  PROCEDURE SP2_CRIARLISTAPENDENCIA  
is 
  
MAXLIST number := 85 ;  
QTDELIST number ;
QTDE_IN_LISTA integer ;

reco_lock EXCEPTION;
tem_deadlock EXCEPTION; 

PRAGMA EXCEPTION_INIT (reco_lock, -54);  
PRAGMA EXCEPTION_INIT (tem_deadlock, -60); 

TYPE endip_type IS TABLE OF PEND_ON002ON.end_ip%TYPE 
	INDEX BY binary_integer;
TYPE qtdlivre_type IS TABLE OF PEND_ON002ON.qtd_livre%TYPE 
	INDEX BY binary_integer;
TYPE rowid_type IS TABLE OF ROWID  
	INDEX BY binary_integer;
TYPE atuforc_type IS TABLE OF DAT07.atuforc%TYPE 
	INDEX BY binary_integer;
TYPE datforc_type IS TABLE OF DAT07.datforc%TYPE 
	INDEX BY binary_integer;
	
l_endip endip_type;
l_qtdlivre qtdlivre_type;
l_rowid rowid_type;
l_atuforc atuforc_type;
l_datforc datforc_type;

rstatus PEND_ON002ON.status%type ;
p_rec pend_on001%rowtype;

begin


	SP2A_STATUSON;
	
	SELECT p.end_ip, p.qtd_livre, p.rowid, d.atuforc, d.datforc
		BULK COLLECT INTO l_endip, l_qtdlivre, l_rowid, l_atuforc, l_datforc 
	from 
		PEND_ON002ON p, dat07 d 
	where 
		p.end_ip = d.end_ip and 
		p.status = '0' and 
		p.qtd_livre > 0 and
		p.blueb = '00' and
		p.codin = '00' and 
		( exists ( select 1 from pend_on001 where end_ip = p.end_ip  and tipo_atu = '1'and status = '0' and rownum <= 1 ) or
		  exists ( select 1 from pend_on003 where end_ip = p.end_ip and rownum <= 1 )
		) ;

	FOR indx IN 1 .. l_endip.count     
	LOOP
		select count(*) into QTDE_IN_LISTA from pend_on003 where end_ip = l_endip(indx) ;
  
		if QTDE_IN_LISTA > 0 then
			BEGIN
				select status into rstatus from PEND_ON002ON
					where rowid = l_rowid(indx) for update nowait;
			
				update PEND_ON002ON set status = '1' where rowid = l_rowid(indx);
				COMMIT;
				GOTO Main_Loop ;
				
			EXCEPTION
				when reco_lock then GOTO Main_Loop;
				when NO_DATA_FOUND then GOTO Main_Loop;
				when OTHERS then GOTO Main_Loop;
			END;
			
		end if ;  

		select least( l_qtdlivre(indx), MAXLIST ) into QTDELIST from dual ;
  
		insert into tmp_listapendencia ( end_ip, numserial, identif )
			select 
		        l_endip(indx)  as end_ip,         
		        numserial, 
				identif
			from
		        (
		         select
		             numserial, max (identif) as identif, min (identif) as minidentif
				from 
					pend_on001 
				where 
					end_ip = l_endip(indx) and
					tipo_atu = '1' and 
					status = '0' and 
					tipo <> '4' and
					(   ( l_atuforc(indx) = '0' ) or 
						( l_atuforc(indx) = '1' and l_datforc(indx) is null ) or 
						( l_atuforc(indx) = '1' and identif > to_char(l_datforc(indx),'YYMMDDHH24MISS') 
						) 
					)  
       			group by numserial 
				order by 3      
				) 
			where rownum <= QTDELIST	;			

		if not SQL%FOUND then
			GOTO Main_Loop ;
		end if ;  

		insert into pend_on003 ( end_ip, numserial, identif ) 
			select distinct end_ip, numserial, identif from tmp_listapendencia ;

	    for rec in ( select * from tmp_listapendencia ) 
		LOOP
			for c_cpon in (
				select rowid from pend_on001 
				where 
					numserial = rec.numserial and 
					end_ip = rec.end_ip and 
					identif <= rec.identif and
					tipo_atu = '1' and
					status = '0' )

			loop
				BEGIN
					select * INTO p_rec from pend_on001  
					where 
						rowid = c_cpon.rowid 
					for update nowait;
					
					update pend_on001 set status = '1' where rowid = c_cpon.rowid;
			
				EXCEPTION
					when reco_lock then NULL;
					when NO_DATA_FOUND then NULL;
					when OTHERS then NULL;
				END;
			end loop;

		END LOOP ;

		begin
			select status into rstatus 
				from PEND_ON002ON 
			where rowid = l_rowid(indx) for update nowait;
			
			update PEND_ON002ON set status = '1' 
				where rowid = l_rowid(indx);

		exception
			when reco_lock then NULL;
		    when NO_DATA_FOUND then NULL;
    		when OTHERS then NULL;
		end;
    
    	COMMIT;

    	<<Main_Loop>>
    	NULL;
     end loop ;  

end sp2_criarlistapendencia ;
/
