CREATE OR REPLACE FUNCTION SQLOLHA_OVERWRITE_APPL (nome in varchar2, masc in varchar2, com_dig in int, mensalert out varchar2) 
    RETURN NUMBER IS
	Retorno NUMBER;
	status VARCHAR2(1);
	comando VARCHAR2(2);
	acaox VARCHAR2(15);
	tipo VARCHAR2(1);
	endereco VARCHAR2(15);
	stm VARCHAR2(400);

	reco_lock EXCEPTION;
	PRAGMA EXCEPTION_INIT (reco_lock, -54);  

BEGIN
    endereco := nome;
    Retorno := 0;
    
    IF (com_dig = 1) then
   		BEGIN
   		
   			-- monta o comando de SELECT em stm
   			stm := 'SELECT st, cc, tipo_cc, acao FROM '|| masc ||    
				   ' WHERE end_ip = :1 and st = :2 and cc = :3 and tipo_cc = :4 for update nowait' ;
 
 			-- executa o comando
			EXECUTE IMMEDIATE stm 
				into status, comando, tipo, acaox   
				using endereco, '1', '38' , '1';
			
			-- compoe o retorno
   			mensalert := endereco||status||comando||tipo||acaox;


			-- monta o comando de UPDATE em stm
			stm := 'UPDATE '|| masc || ' set st = :1 ' ||
				   'WHERE end_ip = :2 and st = :3 and cc = :4 and tipo_cc = :5 ';

 			-- executa o comando
			EXECUTE IMMEDIATE stm 
				using '4', endereco, '1' , '38', '1';

			Retorno := 1;
			COMMIT;
						  
		EXCEPTION
			WHEN reco_lock THEN           -- reg. ja'lockado
			    Retorno := -2;
			WHEN NO_DATA_FOUND THEN
				Retorno := 0;
			WHEN OTHERS THEN
				Retorno := -1;
		END;

	ELSE
		BEGIN
   			-- monta o comando de SELECT em stm
   			stm := 'SELECT st, cc, tipo_cc, acao FROM '|| masc ||    
				   ' WHERE end_ip = :1 and st = :2 and tipo_cc = :3 and cc = :4 for update nowait' ;
 
 			-- executa o comando
			EXECUTE IMMEDIATE stm 
				into status, comando, tipo, acaox   
				using endereco, '1', '0' , '24';
		
			mensalert := endereco||status||comando||tipo||acaox;
			Retorno := 2;
			COMMIT;
		
		EXCEPTION
			WHEN NO_DATA_FOUND THEN
				Retorno := 0;
			WHEN OTHERS THEN
				Retorno := -1;
		END;
	END IF;

    return (Retorno);

END SQLOLHA_OVERWRITE_APPL;
/