CREATE OR REPLACE FUNCTION SQLOLHA_ALARME_APPL (nome in varchar2, masc in varchar2, mensalert out varchar2) 
    RETURN NUMBER IS
	Retorno NUMBER;
	status VARCHAR2(1);
	comando VARCHAR2(2);
	acaox VARCHAR2(15);
	tipo VARCHAR2(1);
	c1 VARCHAR2(1);
	c2 VARCHAR2(1);
	endereco VARCHAR2(15);
	
	cmd VARCHAR2(400);
	reco_lock EXCEPTION;
	PRAGMA EXCEPTION_INIT (reco_lock, -54);  

BEGIN
    endereco := nome;
    Retorno := 0;
    BEGIN
	
	cmd := 'SELECT st, cc, tipo_cc, acao  FROM ' || masc ||
        ' WHERE end_ip = :1 and st = :2 and  tipo_cc = :3 	for update nowait ' ;
        
    execute immediate cmd 
	into status, comando, tipo, acaox   
	using endereco, '1', '0' ;

	mensalert := endereco||status||comando||tipo||acaox;


	cmd := 'UPDATE ' || masc || ' set st = :1 WHERE end_ip = :2 and
	      st = :3 and  tipo_cc = :4';
	
	execute immediate cmd using '4', endereco, '1', '0' ;

	COMMIT;

    EXCEPTION
        WHEN reco_lock THEN           -- reg. ja'lockado
	    Retorno := 1;
	WHEN NO_DATA_FOUND THEN
	    Retorno := 1;
	WHEN OTHERS THEN
      	    Retorno := -1;
    END;
    return (Retorno);

END SQLOLHA_ALARME_APPL;
/