CREATE OR REPLACE FUNCTION sqlver_matbmens (cMatric varchar2, cHorario in varchar2, cMensBloq in out varchar2)
   RETURN NUMBER IS
   Ret    NUMBER;

BEGIN
	Ret := 1;
	cMensBloq := '';
   
    -- procura pela Matricula / faixa horaria / mensagem bloqueio em MATBMENS
    BEGIN
		SELECT MENSBLOQ into cMensBloq FROM (
			SELECT * FROM MATBMENS 
				WHERE ICARD = cMatric ORDER BY FXMENS)
		WHERE
			cHorario >= SUBSTR(FXMENS, 1,4) AND 
			cHorario <= SUBSTR(FXMENS, 5,4) AND 
			ROWNUM = 1;
    
    EXCEPTION
		WHEN NO_DATA_FOUND then 
			Ret := 0;
		WHEN OTHERS then
		    Ret := -1;
    END;
    
	return (Ret);
	
END sqlver_matbmens;
/

