CREATE or REPLACE FUNCTION sqlload_listadig2 (cMatric in VARCHAR2, cEndIp in VARCHAR2, cStatus in VARCHAR2) 
RETURN NUMBER IS

Ret NUMBER;
cAux VARCHAR2(12);
cAuxIp VARCHAR2(15);
cBioTipo VARCHAR2(5);
reco_lock EXCEPTION;
PRAGMA EXCEPTION_INIT (reco_lock, -54);

BEGIN

	Ret := 0;
	BEGIN
		SELECT BIO_TIPO into cBioTipo FROM DIG002
			WHERE END_IP = cEndIp FOR update nowait;
				  
		IF (cBioTipo = '6' or cBioTipo = '7') then		-- (SAGEM)
			BEGIN
				SELECT Icard into cAux FROM DIG001 
					where ICARD = cMatric and
						  END_IP = cEndIp FOR update nowait;
	
				UPDATE DIG001 SET STATUS = cStatus 
					where ICARD = cMatric and
						  END_IP = cEndIp;

			EXCEPTION
				WHEN NO_DATA_FOUND then 
					Ret := 0;
				WHEN reco_lock then
					Ret := -1;
				WHEN OTHERS then
					Ret := -1;
			END;
		ELSE 
			IF (cBioTipo = '8') then		-- BIOTIPO = '8' (TSI1)
				BEGIN
					SELECT Icard into cAux FROM DIG003 
						where ICARD = cMatric and
							  END_IP = cEndIp FOR update nowait;

					UPDATE DIG003 SET STATUS = cStatus 
						where ICARD = cMatric and
							  END_IP = cEndIp;

				EXCEPTION
					WHEN NO_DATA_FOUND then 
						Ret := 0;
					WHEN reco_lock then
						Ret := -1;
					WHEN OTHERS then
						Ret := -1;
				END;
			end if;
		END IF;		

		UPDATE DIG002 SET DATA_LOAD = sysdate 
			WHERE END_IP = cEndIp;
		
		COMMIT;
		
	EXCEPTION
		WHEN NO_DATA_FOUND then 
			Return (0);
		WHEN reco_lock then
			Return (-1);
		WHEN OTHERS then
			return (-1);
	END;
		
	RETURN (Ret);
END sqlload_listadig2;
/
