CREATE or REPLACE FUNCTION sqller_atupendon2(cDataCod in VARCHAR2,cNSerial in VARCHAR2,cEndIp in VARCHAR2,
cDataMor in out VARCHAR2,cRegCampo in out VARCHAR2,cRegValor in out VARCHAR2, cRegIdent in out VARCHAR2) 
RETURN NUMBER IS

XCONT NUMBER;
XNUMCPO CHAR(2);
XINFORM VARCHAR2(56);
XIDENTIF CHAR(14);
XIDMAIOR CHAR(14);

cursor cursor_matleatu is
	SELECT /*+ INDEX (INDEX2_ATUALI) */
	distinct identif, numcpo, inform 
	FROM ATUALI 
	WHERE NUMSERIAL = cNSerial  and 
--	      to_identif(identif) > to_identif (cDatacod) and
--	      to_identif(identif) in (SELECT MAX(TO_IDENTIF(IDENTIF)) 
	      IDENTIF > to_identif (cDatacod) and
	      IDENTIF in (SELECT MAX(IDENTIF) 
					FROM ATUALI WHERE NUMSERIAL = cNSerial 
					GROUP BY to_number(NUMCPO))
	order by to_number(NUMCPO);

begin
	XCONT := 0;
	-- inicializa identificador de comparacao com data antiga
	XIDMAIOR := '01010100000000';
	open cursor_matleatu;
	LOOP
		fetch cursor_matleatu INTO XIDENTIF, XNUMCPO, XINFORM;
		EXIT when cursor_matleatu%NOTFOUND;

		cRegCampo := cRegCampo || XNUMCPO || '[';
		cRegValor := cRegValor || XINFORM || '[';
		--cRegIdent := cRegIdent || XIDENTIF || '[';
		cRegIdent := cRegIdent || ret_identif(XIDENTIF) || '[';
		XCONT := XCONT+1;

		-- verifica qual o identificador mais recente
		
		--if (to_identif(XIDENTIF) > to_identif(XIDMAIOR)) THEN
		if (XIDENTIF > XIDMAIOR) THEN
			XIDMAIOR := XIDENTIF;
		end if;
	END LOOP;
	--COMMIT;
	cRegCampo := cRegCampo || ';';
	cRegValor := cRegValor || ';';
	cRegIdent := cRegIdent || ';';
	CLOSE cursor_matleatu;

	--cDataMor := XIDMAIOR;
	cDataMor := ret_identif(XIDMAIOR); 	-- cDataMor := ddmmyyhhmissxx 
	IF (XCONT = 0) THEN
		RETURN (0);
	ELSE
		RETURN (1);
	END IF;
END sqller_atupendon2;
/

