CREATE OR REPLACE FUNCTION sqllocs_lesbbe 
   RETURN NUMBER IS
      r        NUMBER;
      RetSemaf NUMBER;
      Seq      NUMBER;
      reco_lock EXCEPTION;
      PRAGMA EXCEPTION_INIT (reco_lock, -54);  -- erro quando registro lockado 

BEGIN
   RetSemaf := 0;   

   SELECT Sequencia INTO Seq from SBBE;

   -- tenta lockar a matricula 
   r := sys.dbms_lock.request (Seq, 6, 0, FALSE);
   IF (r = 0) THEN            -- OK 
      BEGIN
         SELECT TO_NUMBER(sinal) INTO RetSemaf FROM sbbe
            FOR UPDATE NOWAIT;
      EXCEPTION
	 WHEN reco_lock THEN
	    RetSemaf := -1;
         WHEN OTHERS THEN
	    RetSemaf := -1;
      END;
   ELSE
      RetSemaf := -1;
   END IF;
   return (RetSemaf);
END sqllocs_lesbbe;
/

