CREATE OR REPLACE FUNCTION sqllocs_lesn (cBlueB in VARCHAR2)
   RETURN NUMBER IS
      RetFun NUMBER;
      valor VARCHAR2(5);
      Seq NUMBER;
      r NUMBER;
      reco_lock EXCEPTION;
      PRAGMA EXCEPTION_INIT (reco_lock, -54);  -- erro quando registro lockado 
BEGIN

   RetFun := 0;
   BEGIN
      SELECT Sequencia into Seq from SNBE WHERE BlueB = cBlueB;

   EXCEPTION
      WHEN NO_DATA_FOUND THEN  
	 RetFun := -2;
         return (RetFun);
      WHEN OTHERS THEN
	 RetFun := -1;
         return (RetFun);
   END;

   r := dbms_lock.request (Seq, 6, 0, FALSE);
   IF (r = 0) then
      BEGIN
         -- Retorna "erro" se semaforo estiver lockado. 
--         SELECT TO_NUMBER(sinal) INTO RetFun FROM snbe 
--	    WHERE BlueB = cBlueB for update nowait;

         SELECT TO_NUMBER(sinal) INTO RetFun FROM snbe 
	    WHERE BlueB = cBlueB;

      EXCEPTION
	 WHEN reco_lock THEN
	    RetFun := -1;
	 WHEN NO_DATA_FOUND THEN  
	    RetFun := -2;
	 WHEN OTHERS THEN
	    RetFun := -1;
      END;      
   ELSE
      RetFun := -1;
   END IF;
   Return (RetFun);

END sqllocs_lesn;
/

