CREATE OR REPLACE FUNCTION sqlle_info_bloq (NomeBloq VARCHAR2, Registro OUT VARCHAR2) 
   RETURN NUMBER AS
      Retorno NUMBER;                
      cCampo   VARCHAR2(5);
      cPosic   VARCHAR2(2);
      cTam   VARCHAR2(1);
      nTamNome number;
   
BEGIN

   Retorno := 1;
   nTamNome := length (NomeBloq);
   BEGIN 
      SELECT campo_bloq, pos_inic, tamanho INTO cCampo, cPosic, cTam
      FROM INFOMAT 
      WHERE  substr(campo_bloq, 1, nTamNome) = NomeBloq;

      if (cPosic is Null) or (cTam is NULL) then
	  Retorno := 0;
      else
	  Registro := cCampo || cPosic || cTam;
      END IF;

   EXCEPTION
      WHEN NO_DATA_FOUND THEN
         Retorno := 0;

      WHEN OTHERS THEN
         Retorno := -1;
   END;
   return (Retorno);

END sqlle_info_bloq;
/

