CREATE OR REPLACE FUNCTION sqlgrp_set_fx_tcp (cEnd_Ip in VARCHAR2, cGrupo in VARCHAR2, cFaixa IN OUT VARCHAR2) 
   RETURN NUMBER IS
      nLaces  NUMBER;

BEGIN
	nLaces := -1;
	BEGIN
		SELECT TO_NUMBER(Laces), FxPerm into nLaces, cFaixa
		FROM TabGrpSetFx 
		WHERE End_Ip = cEnd_Ip AND 
			TO_NUMBER(Grupo) = TO_NUMBER(cGrupo);

	EXCEPTION
		WHEN NO_DATA_FOUND THEN   -- linha procurada nao foi encontrado em DAT07 
			nLaces := -1;
		WHEN OTHERS THEN
			nLaces := -2;
	END;
	return (nLaces);
END sqlgrp_set_fx_tcp;
/
