CREATE OR REPLACE FUNCTION sqlgrava_cp_novell_APPL (cEndIp in VARCHAR2, masc in varchar2, Registro in VARCHAR2)
RETURN NUMBER IS
	Ret NUMBER;
	cAuxEndIp VARCHAR2(15);
	cTipoCC VARCHAR2(1);
	stm VARCHAR2(400);
	cSt VARCHAR2(1);
	  
	reco_lock EXCEPTION;
	PRAGMA EXCEPTION_INIT (reco_lock, -54);  

BEGIN
	Ret := 0;
	cSt := substr(Registro, 1, 1);
	cTipoCC := substr(Registro, 4, 1);
	BEGIN
		-- monta comando de SELECT em stm
		stm := 'SELECT End_Ip FROM '|| masc ||  
	 		   ' WHERE End_Ip = :1 and Tipo_cc = :2 FOR UPDATE NOWAIT';
		-- executa comando
		EXECUTE IMMEDIATE stm 
   			INTO cAuxEndIp 
   			USING cEndIp, cTipoCC;
   
   		-- monta comando de UDPATE em stm
   		stm := 'UPDATE '|| masc || ' SET ST = :1 ' ||    
	 		   ' WHERE End_Ip = :2 and Tipo_cc = :3';
		-- executa comando
   		EXECUTE IMMEDIATE stm 
   			USING cSt , cEndIp, cTipoCC;

		COMMIT;

	EXCEPTION
		WHEN NO_DATA_FOUND OR reco_lock THEN
			Ret := -1;
		WHEN OTHERS THEN
			Ret := -1;
	END;
	return (Ret);
END sqlgrava_cp_novell_APPL;
/

