CREATE or REPLACE FUNCTION sqlfim_Ldig (cEndIp in VARCHAR2, cStatus in VARCHAR2) 
RETURN NUMBER IS

Ret NUMBER;
cAuxIp VARCHAR2(15);
reco_lock EXCEPTION;
PRAGMA EXCEPTION_INIT (reco_lock, -54);

BEGIN

	Ret := 0;
	BEGIN
		SELECT END_IP into cAuxIp from DIG002 
			WHERE END_IP = cEndIp FOR UPDATE NOWAIT;

		UPDATE DIG002 set STATUS = cStatus
			WHERE END_IP = cEndIp;
			
		COMMIT;
			
	EXCEPTION
		WHEN NO_DATA_FOUND then 
			Ret := 0;
		WHEN reco_lock then
			Ret := -1;
		WHEN OTHERS then 
			Ret := -2;
				
	END;
	
	return (Ret);
END sqlfim_Ldig;
/
