create or replace procedure sqllimp_exced is
reco_lock EXCEPTION;
PRAGMA EXCEPTION_INIT (reco_lock, -54);  
r_identif pend_on001.identif%type ;
r_numserial pend_on001.numserial%type;
r_status pend_on001.status%type;
p_rec pend_on001%rowtype;

TYPE identif_exced IS TABLE OF pend_on001.identif%TYPE 
	INDEX BY binary_integer;

TYPE numserial_exced IS TABLE OF pend_on001.numserial%TYPE 
	INDEX BY binary_integer;

identif_ids identif_exced;
numserial_ids numserial_exced;

total number;

begin

	SELECT distinct identif, numserial 
	BULK COLLECT INTO identif_ids, numserial_ids 	
		FROM pend_on001 
	 WHERE identif not in (select identif from atuali);

	total := identif_ids.count;
	FOR indx IN 1 .. total
	LOOP
		for x in (select end_ip, rowid from pend_on001  
					where numserial = numserial_ids(indx) and
	          			end_ip > '000.000.000.000' and
	          			identif = identif_ids (indx))
		loop
			begin
				select * into p_rec from pend_on001
					where rowid = x.rowid
					for update nowait;
 
	          	delete pend_on001
	          		where rowid = x.rowid ;
          
			exception 
				when reco_lock then NULL;
				when NO_DATA_FOUND then NULL;
				when others then NULL;
			end;
		end loop;
		
		if (MOD (indx,10) = 0) then
			COMMIT;
		end if;
		
	end loop;
	
	IF (total != 0) then
		COMMIT;
	END IF;
	
           
end sqllimp_exced;
/

