CREATE OR REPLACE FUNCTION sqlescreve_sn (cBlueB in VARCHAR2, cCodigo in VARCHAR2, mensagem out VARCHAR2)
   RETURN NUMBER IS
      Ret NUMBER;
      reco_lock EXCEPTION;
      ValSinal VARCHAR2(2);
      PRAGMA EXCEPTION_INIT (reco_lock, -54);  -- erro quando registro lockado 

BEGIN
   Ret := 0;
   BEGIN
     SELECT Sinal INTO ValSinal FROM SNBE
         WHERE BlueB = cBlueB;
     SELECT Sinal INTO ValSinal FROM SNBE
        WHERE BlueB = cBlueB FOR UPDATE NOWAIT;

      UPDATE SNBE SET Sinal = cCodigo
         WHERE BlueB = cBlueB;
      COMMIT;
   
   EXCEPTION
      WHEN reco_lock THEN   -- reg. ja'lockado ou nao encontrado 
         mensagem := 'Registro '||cBlueB || ' ja lockado!!';
         Ret := -1;
      WHEN NO_DATA_FOUND THEN
         mensagem := 'Registro nao encontrado';
         Ret := -1;
      WHEN OTHERS THEN
         mensagem := 'ERRO !!!';
         Ret := -1;
   END;
   return (Ret);
END sqlescreve_sn;
/

